/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import org.drools.workbench.models.commons.backend.rule.Splitter;
import org.junit.Assert;
import org.junit.Test;

public class SplitterTest {
    @Test
    public void testSimple() {
        String[] split = Splitter.split((String)"test.method()");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"test", (Object)split[0]);
        Assert.assertEquals((Object)"method()", (Object)split[1]);
    }

    @Test
    public void testLong() {
        String[] split = Splitter.split((String)"test.method().Something().VALUE");
        Assert.assertEquals((long)4L, (long)split.length);
        Assert.assertEquals((Object)"test", (Object)split[0]);
        Assert.assertEquals((Object)"method()", (Object)split[1]);
        Assert.assertEquals((Object)"Something()", (Object)split[2]);
        Assert.assertEquals((Object)"VALUE", (Object)split[3]);
    }

    @Test
    public void testNested() {
        String[] split = Splitter.split((String)"test( $var.get() )");
        Assert.assertEquals((long)1L, (long)split.length);
        Assert.assertEquals((Object)"test( $var.get() )", (Object)split[0]);
    }

    @Test
    public void testNestedComplex() {
        String[] split = Splitter.split((String)"var.test( $var.get() ).more( 12, 14)");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"var", (Object)split[0]);
        Assert.assertEquals((Object)"test( $var.get() )", (Object)split[1]);
        Assert.assertEquals((Object)"more( 12, 14)", (Object)split[2]);
    }
}

