/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.rule;

import java.util.List;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleModelTest {
    private RuleModel model;

    @Before
    public void setup() {
        this.model = new RuleModel();
        FactPattern fp1 = new FactPattern();
        fp1.setBoundName("$p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        fp1.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraintEBLeftSide sfc2 = new SingleFieldConstraintEBLeftSide();
        sfc2.setFieldBinding("$sfc2");
        fp1.addConstraint((FieldConstraint)sfc2);
        FromCompositeFactPattern fcfp = new FromCompositeFactPattern();
        FactPattern fp2 = new FactPattern();
        fp2.setBoundName("$p2");
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFieldBinding("$sfc3");
        fp2.addConstraint((FieldConstraint)sfc3);
        fcfp.setFactPattern(fp2);
        this.model.addLhsItem((IPattern)fp1);
        this.model.addLhsItem((IPattern)fcfp);
    }

    @Test
    public void checkGetAllLHSVariables() {
        List allLHSVariables = this.model.getAllLHSVariables();
        Assert.assertEquals((long)5L, (long)allLHSVariables.size());
        Assert.assertTrue((boolean)allLHSVariables.contains("$p1"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$p2"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$sfc1"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$sfc2"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$sfc3"));
    }

    @Test
    public void checkGetLHSPatternVariables() {
        List allLHSVariables = this.model.getLHSPatternVariables();
        Assert.assertEquals((long)2L, (long)allLHSVariables.size());
        Assert.assertTrue((boolean)allLHSVariables.contains("$p1"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$p2"));
    }

    @Test
    public void checkGetLHSFieldVariables() {
        List allLHSVariables = this.model.getLHSVariables(false, true);
        Assert.assertEquals((long)3L, (long)allLHSVariables.size());
        Assert.assertTrue((boolean)allLHSVariables.contains("$sfc1"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$sfc2"));
        Assert.assertTrue((boolean)allLHSVariables.contains("$sfc3"));
    }
}

