/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.rule.util;

import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.util.FieldConstraintArrayUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FieldConstraintArrayUtilTest {
    @Test
    public void up() {
        FieldConstraint bottom;
        FieldConstraint[] fieldConstraints = new FieldConstraint[]{(FieldConstraint)Mockito.mock(FieldConstraint.class), bottom = (FieldConstraint)Mockito.mock(FieldConstraint.class)};
        FieldConstraintArrayUtil.moveUp((int)1, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[0]);
    }

    @Test
    public void upWhenAlreadyTop() {
        FieldConstraint top = (FieldConstraint)Mockito.mock(FieldConstraint.class);
        FieldConstraint[] fieldConstraints = new FieldConstraint[]{top, (FieldConstraint)Mockito.mock(FieldConstraint.class)};
        FieldConstraintArrayUtil.moveUp((int)0, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[0]);
    }

    @Test
    public void shouldNotMoveHigherThanUsedVariables() {
        FieldConstraint[] fieldConstraints = new FieldConstraint[2];
        SingleFieldConstraint top = new SingleFieldConstraint();
        top.setFieldBinding("a");
        fieldConstraints[0] = top;
        SingleFieldConstraint bottom = new SingleFieldConstraint();
        bottom.setConstraintValueType(2);
        bottom.setValue("a");
        fieldConstraints[1] = bottom;
        FieldConstraintArrayUtil.moveUp((int)1, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[0]);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[1]);
    }

    @Test
    public void down() {
        FieldConstraint top = (FieldConstraint)Mockito.mock(FieldConstraint.class);
        FieldConstraint[] fieldConstraints = new FieldConstraint[]{top, (FieldConstraint)Mockito.mock(FieldConstraint.class)};
        FieldConstraintArrayUtil.moveDown((int)0, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[1]);
    }

    @Test
    public void downWhenAlreadyBottom() {
        FieldConstraint bottom;
        FieldConstraint[] fieldConstraints = new FieldConstraint[]{(FieldConstraint)Mockito.mock(FieldConstraint.class), bottom = (FieldConstraint)Mockito.mock(FieldConstraint.class)};
        FieldConstraintArrayUtil.moveDown((int)1, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[1]);
    }

    @Test
    public void shouldNotMoveLowerThanUsedVariables() {
        FieldConstraint[] fieldConstraints = new FieldConstraint[2];
        SingleFieldConstraint top = new SingleFieldConstraint();
        top.setFieldBinding("a");
        fieldConstraints[0] = top;
        SingleFieldConstraint bottom = new SingleFieldConstraint();
        bottom.setConstraintValueType(2);
        bottom.setValue("a");
        fieldConstraints[1] = bottom;
        FieldConstraintArrayUtil.moveDown((int)0, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[0]);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[1]);
    }

    @Test
    public void shouldNotMoveUpperThanUsedVariables_MoveToMiddle() {
        FieldConstraint[] fieldConstraints = new FieldConstraint[3];
        SingleFieldConstraint top = new SingleFieldConstraint();
        top.setConstraintValueType(2);
        top.setValue("b");
        fieldConstraints[0] = top;
        SingleFieldConstraint middle = new SingleFieldConstraint();
        middle.setConstraintValueType(2);
        middle.setValue("a");
        fieldConstraints[1] = middle;
        SingleFieldConstraint bottom = new SingleFieldConstraint();
        bottom.setFieldBinding("a");
        fieldConstraints[2] = bottom;
        FieldConstraintArrayUtil.moveUp((int)2, (FieldConstraint[])fieldConstraints);
        FieldConstraintArrayUtil.moveUp((int)1, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[0]);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[1]);
        Assert.assertEquals((Object)middle, (Object)fieldConstraints[2]);
    }

    @Test
    public void shouldNotMoveLowerThanUsedVariables_MoveToMiddle() {
        FieldConstraint[] fieldConstraints = new FieldConstraint[3];
        SingleFieldConstraint top = new SingleFieldConstraint();
        top.setFieldBinding("a");
        fieldConstraints[0] = top;
        SingleFieldConstraint middle = new SingleFieldConstraint();
        middle.setConstraintValueType(2);
        middle.setValue("a");
        fieldConstraints[1] = middle;
        SingleFieldConstraint bottom = new SingleFieldConstraint();
        bottom.setConstraintValueType(2);
        bottom.setValue("b");
        fieldConstraints[2] = bottom;
        FieldConstraintArrayUtil.moveDown((int)0, (FieldConstraint[])fieldConstraints);
        FieldConstraintArrayUtil.moveDown((int)1, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[0]);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[1]);
        Assert.assertEquals((Object)middle, (Object)fieldConstraints[2]);
    }

    @Test
    public void testMove_DifferentBindings() {
        FieldConstraint[] fieldConstraints = new FieldConstraint[3];
        SingleFieldConstraint top = new SingleFieldConstraint();
        top.setFieldBinding("a");
        fieldConstraints[0] = top;
        SingleFieldConstraint middle = new SingleFieldConstraint();
        middle.setFieldBinding("b");
        fieldConstraints[1] = middle;
        SingleFieldConstraint bottom = new SingleFieldConstraint();
        bottom.setFieldBinding("c");
        fieldConstraints[2] = bottom;
        FieldConstraintArrayUtil.moveDown((int)0, (FieldConstraint[])fieldConstraints);
        FieldConstraintArrayUtil.moveUp((int)2, (FieldConstraint[])fieldConstraints);
        Assert.assertEquals((Object)middle, (Object)fieldConstraints[0]);
        Assert.assertEquals((Object)bottom, (Object)fieldConstraints[1]);
        Assert.assertEquals((Object)top, (Object)fieldConstraints[2]);
    }
}

