/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.rule;

import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.CEPWindow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CEPWindowTest {
    private CEPWindow cepWindowAllFieldsFilled;
    private CEPWindow cepWindowDefaultValues;
    private CEPWindow cepWindowNullValues;
    private CEPWindow cepWindowNullParameters;
    private CEPWindow cepWindowNullOperator;

    @Before
    public void setUp() throws Exception {
        this.cepWindowAllFieldsFilled = new CEPWindow();
        this.cepWindowAllFieldsFilled.setOperator("over window:time");
        this.cepWindowAllFieldsFilled.setParameters(this.makeTestParameters());
        this.cepWindowDefaultValues = new CEPWindow();
        this.cepWindowNullValues = new CEPWindow();
        this.cepWindowNullValues.setOperator(null);
        this.cepWindowNullValues.setParameters(null);
        this.cepWindowNullParameters = new CEPWindow();
        this.cepWindowNullParameters.setOperator("over window:time");
        this.cepWindowNullParameters.setParameters(null);
        this.cepWindowNullOperator = new CEPWindow();
        this.cepWindowNullOperator.setOperator(null);
        this.cepWindowNullOperator.setParameters(this.makeTestParameters());
    }

    private Map<String, String> makeTestParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("a", "b");
        return result;
    }

    @Test
    public void genericValues() {
        CEPWindow other = new CEPWindow();
        other.setOperator("over window:time");
        other.setParameters(this.makeTestParameters());
        Assert.assertNotNull((Object)this.cepWindowAllFieldsFilled.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)other.hashCode());
    }

    @Test
    public void genericValuesDifferentParameters() {
        CEPWindow other = new CEPWindow();
        other.setOperator("over window:time");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("c", "d");
        other.setParameters(parameters);
        Assert.assertNotNull((Object)this.cepWindowAllFieldsFilled.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertNotEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)other.hashCode());
    }

    @Test
    public void genericValuesDifferentOperator() {
        CEPWindow other = new CEPWindow();
        other.setOperator("over window:length( 10 )");
        other.setParameters(this.makeTestParameters());
        Assert.assertNotNull((Object)this.cepWindowAllFieldsFilled.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertNotEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)other.hashCode());
    }

    @Test
    public void defaultValues() {
        CEPWindow other = new CEPWindow();
        Assert.assertNotNull((Object)this.cepWindowDefaultValues.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertEquals((long)this.cepWindowDefaultValues.hashCode(), (long)other.hashCode());
    }

    @Test
    public void checkNulls() {
        CEPWindow other = new CEPWindow();
        other.setOperator(null);
        other.setParameters(null);
        Assert.assertNotNull((Object)this.cepWindowNullValues.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertEquals((long)this.cepWindowNullValues.hashCode(), (long)other.hashCode());
    }

    @Test
    public void nullParameters() {
        CEPWindow other = new CEPWindow();
        other.setOperator("over window:time");
        other.setParameters(null);
        Assert.assertNotNull((Object)this.cepWindowNullParameters.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertEquals((long)this.cepWindowNullParameters.hashCode(), (long)other.hashCode());
    }

    @Test
    public void nullOperator() {
        CEPWindow other = new CEPWindow();
        other.setOperator(null);
        other.setParameters(this.makeTestParameters());
        Assert.assertNotNull((Object)this.cepWindowNullOperator.hashCode());
        Assert.assertNotNull((Object)other.hashCode());
        Assert.assertEquals((long)this.cepWindowNullOperator.hashCode(), (long)other.hashCode());
    }

    @Test
    public void hashCodesShouldNotBeEqual() {
        Assert.assertNotEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)this.cepWindowDefaultValues.hashCode());
        Assert.assertNotEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)this.cepWindowNullValues.hashCode());
        Assert.assertNotEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)this.cepWindowNullParameters.hashCode());
        Assert.assertNotEquals((long)this.cepWindowAllFieldsFilled.hashCode(), (long)this.cepWindowNullOperator.hashCode());
        Assert.assertEquals((long)this.cepWindowDefaultValues.hashCode(), (long)this.cepWindowNullValues.hashCode());
        Assert.assertNotEquals((long)this.cepWindowDefaultValues.hashCode(), (long)this.cepWindowNullParameters.hashCode());
        Assert.assertNotEquals((long)this.cepWindowDefaultValues.hashCode(), (long)this.cepWindowNullOperator.hashCode());
        Assert.assertNotEquals((long)this.cepWindowNullValues.hashCode(), (long)this.cepWindowNullParameters.hashCode());
        Assert.assertNotEquals((long)this.cepWindowNullValues.hashCode(), (long)this.cepWindowNullOperator.hashCode());
        Assert.assertNotEquals((long)this.cepWindowNullParameters.hashCode(), (long)this.cepWindowNullOperator.hashCode());
    }
}

