/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.template.backend;

import org.drools.workbench.models.commons.backend.rule.RuleModelPersistence;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.template.backend.RuleTemplateModelDRLPersistenceImpl;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class RuleTemplateModelDRLPersistenceTest {
    private RuleModelPersistence ruleModelPersistence;

    @Before
    public void setUp() throws Exception {
        this.ruleModelPersistence = RuleTemplateModelDRLPersistenceImpl.getInstance();
    }

    private void checkMarshall(String expected, RuleModel m) {
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        if (expected != null) {
            this.assertEqualsIgnoreWhitespace(expected, drl);
        }
    }

    @Test
    public void testSimpleSingleValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testRHSInsert() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact actionInsertFact = new ActionInsertFact();
        actionInsertFact.setFactType("Applicant");
        ActionFieldValue actionFieldValue = new ActionFieldValue("age", "123", "Integer");
        actionFieldValue.setNature(1);
        actionInsertFact.addFieldValue(actionFieldValue);
        m.addRhsItem((IAction)actionInsertFact);
        m.addRow(new String[]{"foo"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\" )\nthen \n  Applicant fact0 = new Applicant(); \n  fact0.setAge(123); \n  insert(fact0); \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleSingleTemplateValueSingleLiteralValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("bar");
        con2.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\", field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo", "bar"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\", field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo", null});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{null, "bar"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testGeneratorFactoryReuse() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("$f1");
        con.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con.setFieldType("String");
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("$f2");
        con2.setConstraintValueType(7);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        m.addRow(new String[]{"foo", "bar"});
        String expected = "rule \"t1_0\"dialect \"mvel\"\nwhen \nPerson( field1 == \"foo\", field2 == \"bar\" )then \nend";
        this.checkMarshall(expected, (RuleModel)m);
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintsBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintsFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintsSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintWithConnectiveConstraintBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("goo");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || == \"goo\" || field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintWithConnectiveConstraintFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("goo");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeConstraintWithConnectiveConstraintSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p1.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        comp.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("goo");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("field2");
        Y.setFieldType("String");
        Y.setConstraintValueType(7);
        Y.setValue("$f2");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeFactPatternBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        p1.addConstraint((FieldConstraint)sfc1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        p2.addConstraint((FieldConstraint)sfc2);
        cp.addFactPattern((IFactPattern)p1);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\n(\nPerson( field1 == \"foo\" )\nor\nPerson( field2 == \"bar\" )\n)\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeFactPatternFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        p1.addConstraint((FieldConstraint)sfc1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        p2.addConstraint((FieldConstraint)sfc2);
        cp.addFactPattern((IFactPattern)p1);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\n(\nPerson( field1 == \"foo\" )\nor\nPerson( )\n)\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testCompositeFactPatternSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        p1.addConstraint((FieldConstraint)sfc1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        p2.addConstraint((FieldConstraint)sfc2);
        cp.addFactPattern((IFactPattern)p1);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\n(\nPerson( )\nor\nPerson( field2 == \"bar\" )\n)\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsAllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || ( field2 == \"bar\" && field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field2 == \"bar\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraintsThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldType("String");
        comp2sfc2.setFieldName("field3");
        comp2sfc2.setOperator("==");
        comp2sfc2.setValue("$f3");
        comp2sfc2.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints2AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || ( field2 == \"bar\" ) )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints2FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints2SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field2");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f2");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field2 == \"bar\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2== \"bar\" || ( field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2== \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints3ThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldName("field2");
        sfc2.setFieldType("String");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc2);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        comp.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( ( field3 == \"goo\" ) )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2== \"bar\", field3 == \"goo\" || field4 == \"boo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo", "boo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints4SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2== \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    @Ignore(value="Second CompositeFieldConstraint is incorrectly prefixed with ',' separator from the first CompositeFieldConstraint")
    public void testNestedCompositeConstraints4ThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field3 == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    @Ignore(value="Second CompositeFieldConstraint is incorrectly prefixed with ',' separator from the first CompositeFieldConstraint")
    public void testNestedCompositeConstraints4FourthValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp1 = new CompositeFieldConstraint();
        comp1.setCompositeJunctionType("||");
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp1.addConstraint((FieldConstraint)comp1sfc2);
        p.addConstraint((FieldConstraint)comp1);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("||");
        SingleFieldConstraint comp2sfc1 = new SingleFieldConstraint();
        comp2sfc1.setFieldType("String");
        comp2sfc1.setFieldName("field3");
        comp2sfc1.setOperator("==");
        comp2sfc1.setValue("$f3");
        comp2sfc1.setConstraintValueType(7);
        comp2.addConstraint((FieldConstraint)comp2sfc1);
        SingleFieldConstraint comp2sfc2 = new SingleFieldConstraint();
        comp2sfc2.setFieldName("field4");
        comp2sfc2.setFieldType("String");
        comp2sfc2.setConstraintValueType(7);
        comp2sfc2.setValue("$f4");
        comp2sfc2.setOperator("==");
        comp2.addConstraint((FieldConstraint)comp2sfc2);
        p.addConstraint((FieldConstraint)comp2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field4 == \"boo\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, null, "boo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || field2 == \"bar\" || field3 == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar", "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5FirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5SecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints5ThirdValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint comp1sfc1 = new SingleFieldConstraint();
        comp1sfc1.setFieldName("field1");
        comp1sfc1.setFieldType("String");
        comp1sfc1.setConstraintValueType(7);
        comp1sfc1.setValue("$f1");
        comp1sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc1);
        SingleFieldConstraint comp1sfc2 = new SingleFieldConstraint();
        comp1sfc2.setFieldName("field2");
        comp1sfc2.setFieldType("String");
        comp1sfc2.setConstraintValueType(7);
        comp1sfc2.setValue("$f2");
        comp1sfc2.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc2);
        SingleFieldConstraint comp1sfc3 = new SingleFieldConstraint();
        comp1sfc3.setFieldName("field3");
        comp1sfc3.setFieldType("String");
        comp1sfc3.setConstraintValueType(7);
        comp1sfc3.setValue("$f3");
        comp1sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)comp1sfc3);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field3 == \"goo\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, "goo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6AllValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v1", "v2", "v3", "v4", "v5", "v6"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6NoValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( )\nthen\nend\n";
        m.addRow(new String[]{null, null, null, null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6VariablesAndLiterals() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(1);
        cfc1sfc2.setValue("v2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(1);
        cfc2sfc2.setValue("v4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(1);
        cfc3sfc2.setValue("v6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v1", "v3", "v5"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6VariablesNoValuesAndLiterals() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(1);
        cfc1sfc2.setValue("v2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(1);
        cfc2sfc2.setValue("v4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(1);
        cfc3sfc2.setValue("v6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field2 == \"v2\", field4 == \"v4\", field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6VariablesWithValuesAndLiterals() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(7);
        cfc1sfc1.setValue("$f1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(1);
        cfc1sfc2.setValue("v2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(7);
        cfc2sfc1.setValue("$f3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(1);
        cfc2sfc2.setValue("v4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(7);
        cfc3sfc1.setValue("$f5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(1);
        cfc3sfc2.setValue("v6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v1", "v3", "v5"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6LiteralsAndVariablesNoValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(1);
        cfc1sfc1.setValue("v1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(1);
        cfc2sfc1.setValue("v3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(1);
        cfc3sfc1.setValue("v5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\", field3 == \"v3\", field5 == \"v5\" )\nthen\nend\n";
        m.addRow(new String[]{null, null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testNestedCompositeConstraints6LiteralsAndVariablesWithValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p = new FactPattern("Person");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint cfc1 = new CompositeFieldConstraint();
        cfc1.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc1);
        SingleFieldConstraint cfc1sfc1 = new SingleFieldConstraint();
        cfc1sfc1.setFieldName("field1");
        cfc1sfc1.setFieldType("String");
        cfc1sfc1.setConstraintValueType(1);
        cfc1sfc1.setValue("v1");
        cfc1sfc1.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc1);
        SingleFieldConstraint cfc1sfc2 = new SingleFieldConstraint();
        cfc1sfc2.setFieldName("field2");
        cfc1sfc2.setFieldType("String");
        cfc1sfc2.setConstraintValueType(7);
        cfc1sfc2.setValue("$f2");
        cfc1sfc2.setOperator("==");
        cfc1.addConstraint((FieldConstraint)cfc1sfc2);
        CompositeFieldConstraint cfc2 = new CompositeFieldConstraint();
        cfc2.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc2);
        SingleFieldConstraint cfc2sfc1 = new SingleFieldConstraint();
        cfc2sfc1.setFieldName("field3");
        cfc2sfc1.setFieldType("String");
        cfc2sfc1.setConstraintValueType(1);
        cfc2sfc1.setValue("v3");
        cfc2sfc1.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc1);
        SingleFieldConstraint cfc2sfc2 = new SingleFieldConstraint();
        cfc2sfc2.setFieldName("field4");
        cfc2sfc2.setFieldType("String");
        cfc2sfc2.setConstraintValueType(7);
        cfc2sfc2.setValue("$f4");
        cfc2sfc2.setOperator("==");
        cfc2.addConstraint((FieldConstraint)cfc2sfc2);
        CompositeFieldConstraint cfc3 = new CompositeFieldConstraint();
        cfc3.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)cfc3);
        SingleFieldConstraint cfc3sfc1 = new SingleFieldConstraint();
        cfc3sfc1.setFieldName("field5");
        cfc3sfc1.setFieldType("String");
        cfc3sfc1.setConstraintValueType(1);
        cfc3sfc1.setValue("v5");
        cfc3sfc1.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc1);
        SingleFieldConstraint cfc3sfc2 = new SingleFieldConstraint();
        cfc3sfc2.setFieldName("field6");
        cfc3sfc2.setFieldType("String");
        cfc3sfc2.setConstraintValueType(7);
        cfc3sfc2.setValue("$f6");
        cfc3sfc2.setOperator("==");
        cfc3.addConstraint((FieldConstraint)cfc3sfc2);
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"v1\" || field2 == \"v2\", field3 == \"v3\" || field4 == \"v4\", field5 == \"v5\" || field6 == \"v6\" )\nthen\nend\n";
        m.addRow(new String[]{"v2", "v4", "v6"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testConnectiveConstraintBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        p1.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(7);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("$f2");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" || == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testConnectiveConstraintFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        p1.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(7);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("$f2");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\" )\nthen\nend\n";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testConnectiveConstraintSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "t1";
        FactPattern p1 = new FactPattern("Person");
        m.addLhsItem((IPattern)p1);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("field1");
        X.setFieldType("String");
        X.setConstraintValueType(7);
        X.setValue("$f1");
        X.setOperator("==");
        p1.addConstraint((FieldConstraint)X);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(7);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("$f2");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = connective;
        String expected = "rule \"t1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"bar\" )\nthen\nend\n";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollect() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(new FactPattern("java.util.List"));
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( ) from collect ( Person( field1 == \"foo\" ) ) \nthen\nend";
        m.addRow(new String[]{"foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field1 == \"foo\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", "foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( ) )\nthen\nend";
        m.addRow(new String[]{"1", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List() from collect ( Person( field1 == \"foo\" ) )then\nend";
        m.addRow(new String[]{null, "foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFromCollectFreeFormLineBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        FactPattern fp = new FactPattern("java.util.List");
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)ffl);
        fac.setFactPattern(fp);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List() from collect ( Person( field1 == \"foo\", field2 == \"bar\" ) ) \nthen\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFromCollectFreeFormLineFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        FactPattern fp = new FactPattern("java.util.List");
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)ffl);
        fac.setFactPattern(fp);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFromCollectFreeFormLineSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        FactPattern fp = new FactPattern("java.util.List");
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)ffl);
        fac.setFactPattern(fp);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{null, "foo"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectMultipleSubPatternValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint("field2");
        sfc1.setConstraintValueType(7);
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f3");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field1 == \"foo\", field2 == \"bar\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", "foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectMultipleSubPatternValuesFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint("field2");
        sfc1.setConstraintValueType(7);
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f3");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field1 == \"foo\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", "foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testSimpleFromCollectMultipleSubPatternValuesSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setConstraintValueType(7);
        sfc.setFieldType("String");
        sfc.setOperator("==");
        sfc.setValue("$f1");
        fp.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint("field2");
        sfc1.setConstraintValueType(7);
        sfc1.setFieldType("String");
        sfc1.setOperator("==");
        sfc1.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern("java.util.List");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("size");
        sfc2.setConstraintValueType(7);
        sfc2.setFieldType("Integer");
        sfc2.setOperator(">");
        sfc2.setValue("$f3");
        fp2.addConstraint((FieldConstraint)sfc2);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fp);
        fac.setFactPattern(fp2);
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\njava.util.List( size > 1 ) from collect ( Person( field2 == \"bar\" ) ) \nthen\nend";
        m.addRow(new String[]{"1", null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFreeFormLineBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        m.addLhsItem((IPattern)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nPerson( field1 == \"foo\", field2 == \"bar\" ) \nthen\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFreeFormLineFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        m.addLhsItem((IPattern)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testFreeFormLineSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("Person( field1 == \"@{f1}\", field2 == \"@{f2}\" )");
        m.addLhsItem((IPattern)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionFreeFormLineBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("System.println( \"@{f1}\" + \"@{f2}\" );");
        m.addRhsItem((IAction)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nSystem.println( \"foo\" + \"bar\" );end";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionFreeFormLineFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("System.println( \"@{f1}\" + \"@{f2}\" );");
        m.addRhsItem((IAction)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionFreeFormLineSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("System.println( \"@{f1}\" + \"@{f2}\" );");
        m.addRhsItem((IAction)ffl);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\nthen\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\nf0.setField1(\"foo\");\nf0.setField2(\"bar\");\ninsert(f0);\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactZeroValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\ninsert(f0);\nend";
        m.addRow(new String[]{null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\nf0.setField1(\"foo\");\ninsert(f0);\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionInsertFactSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionInsertFact aif = new ActionInsertFact("Present");
        aif.setBoundName("f0");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        aif.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        aif.addFieldValue(afv1);
        m.addRhsItem((IAction)aif);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nPresent f0 = new Present();\nf0.setField2(\"bar\");\ninsert(f0);\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactBothValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField1(\"foo\");\n$p.setField2(\"bar\");\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactZeroValues() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\nend";
        m.addRow(new String[]{null, null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactFirstValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField1(\"foo\");\nend";
        m.addRow(new String[]{"foo", null});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testActionUpdateFactSecondValue() {
        TemplateModel m = new TemplateModel();
        m.name = "r1";
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        m.addLhsItem((IPattern)fp);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setField("field1");
        afv0.setValue("$f1");
        asf.addFieldValue(afv0);
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("field2");
        afv1.setValue("$f2");
        asf.addFieldValue(afv1);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"r1_0\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField2(\"bar\");\nend";
        m.addRow(new String[]{null, "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    @Test
    public void testEmptyFreeForm() {
        TemplateModel m = new TemplateModel();
        m.name = "Empty FreeFormLine";
        FreeFormLine fl = new FreeFormLine();
        m.addLhsItem((IPattern)fl);
        FactPattern fp = new FactPattern("Person");
        fp.setBoundName("$p");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldName("field1");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        sfc1.setOperator("==");
        fp.addConstraint((FieldConstraint)sfc1);
        m.addLhsItem((IPattern)fp);
        FreeFormLine fr = new FreeFormLine();
        m.addRhsItem((IAction)fr);
        ActionSetField asf = new ActionSetField("$p");
        ActionFieldValue afv0 = new ActionFieldValue();
        afv0.setNature(7);
        afv0.setType("String");
        afv0.setField("field1");
        afv0.setValue("$asf1");
        asf.addFieldValue(afv0);
        m.addRhsItem((IAction)asf);
        String expected = "rule \"Empty FreeFormLine_0\"\ndialect \"mvel\"\nwhen\n$p : Person( field1 == \"foo\" )\nthen\n$p.setField1(\"bar\");\nend";
        m.addRow(new String[]{"foo", "bar"});
        this.checkMarshall(expected, (RuleModel)m);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

