/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.template.backend;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class TemplateWithDSLIntegrationTest {
    @Test
    public void testCompileTemplateWithDSL() {
        String template = "<rule>\n  <name>guided-template-with-dsl</name>\n  <modelVersion>1.0</modelVersion>\n  <attributes/>\n  <metadataList/>\n  <lhs>\n    <dslSentence>\n      <drl>applicant:" + Applicant.class.getCanonicalName() + "(approved=={bool})</drl>\n" + "      <definition>When the applicant approval is {bool:BOOLEAN:checked}</definition>\n" + "      <values>\n" + "        <org.drools.workbench.models.datamodel.rule.DSLVariableValue>\n" + "          <value>false</value>\n" + "        </org.drools.workbench.models.datamodel.rule.DSLVariableValue>\n" + "        <org.drools.workbench.models.datamodel.rule.DSLComplexVariableValue>\n" + "          <value>bool</value>\n" + "          <id>BOOLEAN:checked</id>\n" + "        </org.drools.workbench.models.datamodel.rule.DSLComplexVariableValue>\n" + "      </values>\n" + "    </dslSentence>\n" + "  </lhs>\n" + "  <rhs>\n" + "    <dslSentence>\n" + "      <drl>applicant.setApproved(true)</drl>\n" + "      <definition>Approve the loan</definition>\n" + "      <values/>\n" + "    </dslSentence>\n" + "  </rhs>\n" + "  <imports>\n" + "    <imports/>\n" + "  </imports>\n" + "  <packageName>org.mortgages</packageName>\n" + "  <isNegated>false</isNegated>\n" + "  <table>\n" + "    <entry>\n" + "      <string>__ID_KOL_NAME__</string>\n" + "      <list>\n" + "        <string>1</string>\n" + "      </list>\n" + "    </entry>\n" + "  </table>\n" + "  <idCol>1</idCol>\n" + "  <rowsCount>1</rowsCount>\n" + "</rule>";
        String dsl = "[when]When the applicant approval is {bool:BOOLEAN:checked} = applicant:" + Applicant.class.getCanonicalName() + "(approved=={bool})\n" + "[then]Approve the loan = applicant.setApproved(true)";
        KieHelper kieHelper = new KieHelper();
        KieSession kieSession = kieHelper.addContent(template, ResourceType.TEMPLATE).addContent(dsl, ResourceType.DSL).build(new KieBaseOption[0]).newKieSession();
        Applicant applicant = new Applicant();
        applicant.setApproved(false);
        kieSession.insert((Object)applicant);
        int rulesFired = kieSession.fireAllRules();
        Assert.assertEquals((String)"Incorrect number of rules fired!", (long)1L, (long)rulesFired);
        Assert.assertEquals((String)"Rule RHS wasn't triggered!", (Object)true, (Object)applicant.isApproved());
    }

    public static class Applicant {
        private boolean approved;

        public boolean isApproved() {
            return this.approved;
        }

        public void setApproved(boolean approved) {
            this.approved = approved;
        }
    }
}

