/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.template.backend;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

public class RuleTemplateModelIncrementalCompilationTests {
    @Test
    public void testRuleTemplateInvalidFullBuild() throws Exception {
        String drl = "<rule>\n  <name>t1</name>\n  <modelVersion>1.0</modelVersion>\n  <attributes/>\n  <metadataList/>\n  <lhs>\n    <fact>\n      <constraintList>\n        <constraints>\n          <fieldConstraint>\n            <value>$default</value>\n            <operator>==</operator>\n            <constraintValueType>7</constraintValueType>\n            <expression>\n              <parts/>\n            </expression>\n            <parameters/>\n            <factType>Applicant</factType>\n            <fieldName>age</fieldName>\n            <fieldType>Integer</fieldType>\n          </fieldConstraint>\n        </constraints>\n      </constraintList>\n      <factType>Applicant</factType>\n      <isNegated>false</isNegated>\n      <window>\n        <parameters/>\n      </window>\n    </fact>\n    <freeForm>\n      <text>Smurf()</text>\n    </freeForm>\n  </lhs>\n  <rhs/>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>org.drools.workbench.models.guided.template.backend</packageName>\n  <isNegated>false</isNegated>\n  <table>\n    <entry>\n      <string>__ID_KOL_NAME__</string>\n      <list>\n        <string>1</string>\n      </list>\n    </entry>\n    <entry>\n      <string>$default</string>\n      <list>\n        <string>22</string>\n      </list>\n    </entry>\n  </table>\n  <idCol>1</idCol>\n  <rowsCount>1</rowsCount>\n</rule>";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.template", drl);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List messages = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    public void testRuleTemplateIncrementalCompilationAddInvalidUpdateWithValid() throws Exception {
        String drl1_1 = "<rule>\n  <name>t1</name>\n  <modelVersion>1.0</modelVersion>\n  <attributes/>\n  <metadataList/>\n  <lhs>\n    <fact>\n      <constraintList>\n        <constraints>\n          <fieldConstraint>\n            <value>$default</value>\n            <operator>==</operator>\n            <constraintValueType>7</constraintValueType>\n            <expression>\n              <parts/>\n            </expression>\n            <parameters/>\n            <factType>Applicant</factType>\n            <fieldName>age</fieldName>\n            <fieldType>Integer</fieldType>\n          </fieldConstraint>\n        </constraints>\n      </constraintList>\n      <factType>Applicant</factType>\n      <isNegated>false</isNegated>\n      <window>\n        <parameters/>\n      </window>\n    </fact>\n    <freeForm>\n      <text>Smurf()</text>\n    </freeForm>\n  </lhs>\n  <rhs/>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>org.drools.workbench.models.guided.template.backend</packageName>\n  <isNegated>false</isNegated>\n  <table>\n    <entry>\n      <string>__ID_KOL_NAME__</string>\n      <list>\n        <string>1</string>\n      </list>\n    </entry>\n    <entry>\n      <string>$default</string>\n      <list>\n        <string>22</string>\n      </list>\n    </entry>\n  </table>\n  <idCol>1</idCol>\n  <rowsCount>1</rowsCount>\n</rule>";
        String drl1_2 = "<rule>\n  <name>t1</name>\n  <modelVersion>1.0</modelVersion>\n  <attributes/>\n  <metadataList/>\n  <lhs>\n    <fact>\n      <constraintList>\n        <constraints>\n          <fieldConstraint>\n            <value>$default</value>\n            <operator>==</operator>\n            <constraintValueType>7</constraintValueType>\n            <expression>\n              <parts/>\n            </expression>\n            <parameters/>\n            <factType>Applicant</factType>\n            <fieldName>age</fieldName>\n            <fieldType>Integer</fieldType>\n          </fieldConstraint>\n        </constraints>\n      </constraintList>\n      <factType>Applicant</factType>\n      <isNegated>false</isNegated>\n      <window>\n        <parameters/>\n      </window>\n    </fact>\n  </lhs>\n  <rhs/>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>org.drools.workbench.models.guided.template.backend</packageName>\n  <isNegated>false</isNegated>\n  <table>\n    <entry>\n      <string>__ID_KOL_NAME__</string>\n      <list>\n        <string>1</string>\n      </list>\n    </entry>\n    <entry>\n      <string>$default</string>\n      <list>\n        <string>22</string>\n      </list>\n    </entry>\n  </table>\n  <idCol>1</idCol>\n  <rowsCount>1</rowsCount>\n</rule>";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.template", drl1_1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)1L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        kfs.write("src/main/resources/r1.template", drl1_2);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.template"}).build();
        Assert.assertEquals((long)0L, (long)addResults.getAddedMessages().size());
        Assert.assertEquals((long)1L, (long)addResults.getRemovedMessages().size());
    }

    @Test
    public void testRuleTemplateIncrementalCompilationAddValidUpdateWithInvalid() throws Exception {
        String drl1_1 = "<rule>\n  <name>t1</name>\n  <modelVersion>1.0</modelVersion>\n  <attributes/>\n  <metadataList/>\n  <lhs>\n    <fact>\n      <constraintList>\n        <constraints>\n          <fieldConstraint>\n            <value>$default</value>\n            <operator>==</operator>\n            <constraintValueType>7</constraintValueType>\n            <expression>\n              <parts/>\n            </expression>\n            <parameters/>\n            <factType>Applicant</factType>\n            <fieldName>age</fieldName>\n            <fieldType>Integer</fieldType>\n          </fieldConstraint>\n        </constraints>\n      </constraintList>\n      <factType>Applicant</factType>\n      <isNegated>false</isNegated>\n      <window>\n        <parameters/>\n      </window>\n    </fact>\n  </lhs>\n  <rhs/>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>org.drools.workbench.models.guided.template.backend</packageName>\n  <isNegated>false</isNegated>\n  <table>\n    <entry>\n      <string>__ID_KOL_NAME__</string>\n      <list>\n        <string>1</string>\n      </list>\n    </entry>\n    <entry>\n      <string>$default</string>\n      <list>\n        <string>22</string>\n      </list>\n    </entry>\n  </table>\n  <idCol>1</idCol>\n  <rowsCount>1</rowsCount>\n</rule>";
        String drl1_2 = "<rule>\n  <name>t1</name>\n  <modelVersion>1.0</modelVersion>\n  <attributes/>\n  <metadataList/>\n  <lhs>\n    <fact>\n      <constraintList>\n        <constraints>\n          <fieldConstraint>\n            <value>$default</value>\n            <operator>==</operator>\n            <constraintValueType>7</constraintValueType>\n            <expression>\n              <parts/>\n            </expression>\n            <parameters/>\n            <factType>Applicant</factType>\n            <fieldName>age</fieldName>\n            <fieldType>Integer</fieldType>\n          </fieldConstraint>\n        </constraints>\n      </constraintList>\n      <factType>Applicant</factType>\n      <isNegated>false</isNegated>\n      <window>\n        <parameters/>\n      </window>\n    </fact>\n    <freeForm>\n      <text>Smurf()</text>\n    </freeForm>\n  </lhs>\n  <rhs/>\n  <imports>\n    <imports/>\n  </imports>\n  <packageName>org.drools.workbench.models.guided.template.backend</packageName>\n  <isNegated>false</isNegated>\n  <table>\n    <entry>\n      <string>__ID_KOL_NAME__</string>\n      <list>\n        <string>1</string>\n      </list>\n    </entry>\n    <entry>\n      <string>$default</string>\n      <list>\n        <string>22</string>\n      </list>\n    </entry>\n  </table>\n  <idCol>1</idCol>\n  <rowsCount>1</rowsCount>\n</rule>";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.template", drl1_1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        List messages = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)0L, (long)messages.size());
        kfs.write("src/main/resources/r1.template", drl1_2);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.template"}).build();
        Assert.assertEquals((long)1L, (long)addResults.getAddedMessages().size());
        Assert.assertEquals((long)0L, (long)addResults.getRemovedMessages().size());
    }
}

