/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.commands.jaxb.JaxbListWrapper;
import org.drools.commands.runtime.BatchExecutionCommandImpl;
import org.drools.commands.runtime.GetGlobalCommand;
import org.drools.commands.runtime.SetGlobalCommand;
import org.drools.commands.runtime.process.AbortWorkItemCommand;
import org.drools.commands.runtime.process.CompleteWorkItemCommand;
import org.drools.commands.runtime.process.SignalEventCommand;
import org.drools.commands.runtime.process.StartProcessCommand;
import org.drools.commands.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.commands.runtime.rule.ClearActivationGroupCommand;
import org.drools.commands.runtime.rule.ClearAgendaCommand;
import org.drools.commands.runtime.rule.ClearAgendaGroupCommand;
import org.drools.commands.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.commands.runtime.rule.DeleteCommand;
import org.drools.commands.runtime.rule.FireAllRulesCommand;
import org.drools.commands.runtime.rule.FireUntilHaltCommand;
import org.drools.commands.runtime.rule.GetObjectCommand;
import org.drools.commands.runtime.rule.GetObjectsCommand;
import org.drools.commands.runtime.rule.InsertElementsCommand;
import org.drools.commands.runtime.rule.InsertObjectCommand;
import org.drools.commands.runtime.rule.ModifyCommand;
import org.drools.commands.runtime.rule.QueryCommand;
import org.drools.commands.runtime.rule.UpdateCommand;
import org.drools.core.ClassObjectFilter;
import org.drools.core.ClassObjectSerializationFilter;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.base.RuleNameEqualsAgendaFilter;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DisconnectedFactHandle;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.Setter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;

public class CommandSerializationTest {
    private Class<?>[] annotatedJaxbClasses = new Class[]{JaxbListWrapper.class};
    private static final Random random = new Random();

    private void verifyDisconnectedFactHandle(DisconnectedFactHandle orig, DisconnectedFactHandle copy) {
        ((ObjectAssert)Assertions.assertThat((Object)copy).as("copy disconnected fact handle is null", new Object[0])).isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)copy.getId()).as("id", new Object[0])).isEqualTo(orig.getId());
        ((AbstractIntegerAssert)Assertions.assertThat((int)copy.getIdentityHashCode()).as("identity hash code", new Object[0])).isEqualTo(orig.getIdentityHashCode());
        ((AbstractIntegerAssert)Assertions.assertThat((int)copy.getObjectHashCode()).as("object hash code", new Object[0])).isEqualTo(orig.getObjectHashCode());
        ((AbstractLongAssert)Assertions.assertThat((long)copy.getRecency()).as("recency", new Object[0])).isEqualTo(orig.getRecency());
        ((ObjectAssert)Assertions.assertThat((Object)copy.getEntryPointId()).as("entry point id", new Object[0])).isEqualTo((Object)orig.getEntryPointId());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)copy.getTraitType()).as("trait type", new Object[0])).isEqualTo((Object)orig.getTraitType());
    }

    private <T> T roundTrip(Object obj) throws Exception {
        Class[] classes = new Class[]{obj.getClass()};
        JAXBContext ctx = this.getJaxbContext(classes);
        String xmlOut = this.marshall(ctx, obj);
        return this.unmarshall(ctx, xmlOut);
    }

    private <T> T unmarshall(JAXBContext ctx, String xmlIn) throws Exception {
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlIn.getBytes(Charset.forName("UTF-8")));
        Object out = ctx.createUnmarshaller().unmarshal((InputStream)xmlStrInputStream);
        return (T)out;
    }

    private String marshall(JAXBContext ctx, Object obj) throws Exception {
        StringWriter writer = new StringWriter();
        ctx.createMarshaller().marshal(obj, (Writer)writer);
        return writer.getBuffer().toString();
    }

    private JAXBContext getJaxbContext(Class<?> ... classes) throws Exception {
        ArrayList jaxbClassList = new ArrayList();
        jaxbClassList.addAll(Arrays.asList(classes));
        jaxbClassList.addAll(Arrays.asList(this.annotatedJaxbClasses));
        Class[] jaxbClasses = jaxbClassList.toArray(new Class[jaxbClassList.size()]);
        return JAXBContext.newInstance((Class[])jaxbClasses);
    }

    @Test
    public void updateCommandTest() throws Exception {
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2L, 3, 4, 5L, "entry-point-id", (Object)"str-obj", true);
        DisconnectedFactHandle copyDiscFactHandle = (DisconnectedFactHandle)this.roundTrip(discFactHandle);
        this.verifyDisconnectedFactHandle(discFactHandle, copyDiscFactHandle);
        UpdateCommand cmd = new UpdateCommand((FactHandle)discFactHandle, (Object)"new-str-object");
        UpdateCommand copyCmd = (UpdateCommand)this.roundTrip(cmd);
        this.verifyDisconnectedFactHandle(discFactHandle, copyCmd.getHandle());
        ((AbstractStringAssert)Assertions.assertThat((String)copyCmd.getEntryPoint()).as("entry point", new Object[0])).isEqualTo(cmd.getEntryPoint());
        ((ObjectAssert)Assertions.assertThat((Object)copyCmd.getObject()).as("object", new Object[0])).isEqualTo(cmd.getObject());
    }

    @Test
    public void insertObjectCommandTest() throws Exception {
        InsertObjectCommand cmd = new InsertObjectCommand((Object)"obj", "out-id");
        cmd.setReturnObject(false);
        cmd.setEntryPoint("entry-point");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        ((ObjectAssert)Assertions.assertThat((Object)copyCmd.getObject()).as("object", new Object[0])).isEqualTo(cmd.getObject());
        ((AbstractStringAssert)Assertions.assertThat((String)copyCmd.getOutIdentifier()).as("out id", new Object[0])).isEqualTo(cmd.getOutIdentifier());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)copyCmd.isReturnObject()).as("return obj", new Object[0])).isEqualTo(cmd.isReturnObject());
        ((AbstractStringAssert)Assertions.assertThat((String)copyCmd.getEntryPoint()).as("entry point", new Object[0])).isEqualTo(cmd.getEntryPoint());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)copyCmd.isDisconnected()).as("disconnected", new Object[0])).isEqualTo(cmd.isDisconnected());
    }

    @Test
    public void insertObjectCommandListTest() throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.add("obj");
        InsertObjectCommand cmd = new InsertObjectCommand(objectList, "out-id");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assertions.assertThat((Object)copyCmd).isNotNull();
        Assertions.assertThat((Object)copyCmd.getObject()).isInstanceOf(List.class);
        ((ObjectAssert)Assertions.assertThat((Object)copyCmd.getObject()).as("object", new Object[0])).isEqualTo(cmd.getObject());
    }

    @Test
    public void insertObjectCommandEmptyListTest() throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.add("one-element");
        InsertObjectCommand cmd = new InsertObjectCommand(objectList, "out-id");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assertions.assertThat((Object)copyCmd).isNotNull();
        Assertions.assertThat((Object)copyCmd.getObject()).isInstanceOf(List.class);
        ((ObjectAssert)Assertions.assertThat((Object)copyCmd.getObject()).as("object", new Object[0])).isEqualTo(cmd.getObject());
        objectList.clear();
        copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assertions.assertThat((Object)copyCmd).isNotNull();
        Assertions.assertThat((Object)copyCmd.getObject()).isInstanceOf(List.class);
        ((ObjectAssert)Assertions.assertThat((Object)copyCmd.getObject()).as("object", new Object[0])).isEqualTo(cmd.getObject());
    }

    private static String randomString() {
        return UUID.randomUUID().toString();
    }

    @Test
    public void batchExecutionImplSerializationTest() throws Exception {
        FireAllRulesCommand cmd;
        DefaultFactHandle factHandle = new DefaultFactHandle(13L, "entry-point-id", 42, 84, 400L, (Object)"fact");
        BatchExecutionCommandImpl batchCmd = new BatchExecutionCommandImpl();
        batchCmd.setLookup("lookup");
        AbortWorkItemCommand cmd2 = new AbortWorkItemCommand(23L);
        batchCmd.addCommand((Command)cmd2);
        String externalForm = factHandle.toExternalForm();
        ((AbstractStringAssert)Assertions.assertThat((String)DisconnectedFactHandle.newFrom((FactHandle)factHandle).toExternalForm()).as("FactHandle string", new Object[0])).isEqualTo(externalForm);
        Object cmd3 = new DeleteCommand((FactHandle)factHandle);
        batchCmd.addCommand((Command)cmd3);
        cmd2 = new GetGlobalCommand("global-id");
        cmd2.setOutIdentifier("out-id");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new SetGlobalCommand("global-id", (Object)new Integer(23));
        cmd2.setOutIdentifier("out-id");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new InsertElementsCommand();
        cmd2.setEntryPoint("entry-point");
        cmd2.setOutIdentifier("out-id");
        cmd2.setReturnObject(true);
        HashMap<String, String> mapObj = new HashMap<String, String>();
        mapObj.put("key", "value");
        ArrayList<HashMap<String, String>> objects = new ArrayList<HashMap<String, String>>(1);
        objects.add(mapObj);
        cmd2.setObjects(objects);
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new QueryCommand();
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add("this");
        args.add(42);
        args.add("other");
        cmd2.setArguments(args);
        cmd2.setName("query-name");
        cmd2.setOutIdentifier("out-id");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new InsertObjectCommand();
        cmd2.setEntryPoint("entry-point");
        cmd2.setOutIdentifier("out-id");
        cmd2.setReturnObject(true);
        cmd2.setObject((Object)"object");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ModifyCommand();
        cmd2.setFactHandle(DisconnectedFactHandle.newFrom((FactHandle)factHandle));
        AgendaFilter[] setters = new ArrayList(2);
        Object setter = new Setter(){

            public String getValue() {
                return "blue";
            }

            public String getAccessor() {
                return "heart";
            }
        };
        setters.add(setter);
        setter = new Setter(){

            public String getValue() {
                return "hot";
            }

            public String getAccessor() {
                return "fingers";
            }
        };
        setters.add(setter);
        cmd2.setSetters(setters);
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new GetObjectCommand((FactHandle)factHandle, "out-id");
        batchCmd.addCommand((Command)cmd2);
        AgendaFilter[] filters = new AgendaFilter[]{new RuleNameEndsWithAgendaFilter("suffix", false), new RuleNameEqualsAgendaFilter("name", true), new RuleNameMatchesAgendaFilter("regexp", false), new RuleNameStartsWithAgendaFilter("prefix", false)};
        for (AgendaFilter filter : filters) {
            cmd = new FireAllRulesCommand(CommandSerializationTest.randomString(), random.nextInt(1000), filter);
            batchCmd.addCommand((Command)cmd);
        }
        filters = new AgendaFilter[]{new RuleNameEndsWithAgendaFilter("suffix", false), new RuleNameEqualsAgendaFilter("name", true), new RuleNameMatchesAgendaFilter("regexp", false), new RuleNameStartsWithAgendaFilter("prefix", false)};
        for (AgendaFilter filter : filters) {
            cmd = new FireUntilHaltCommand(filter);
            batchCmd.addCommand((Command)cmd);
        }
        HashMap results = new HashMap(1);
        ArrayList<String> resultValList = new ArrayList<String>(2);
        resultValList.add("yellow");
        resultValList.add("chances");
        results.put("list", resultValList);
        CompleteWorkItemCommand cmd4 = new CompleteWorkItemCommand((long)random.nextInt(1000), results);
        batchCmd.addCommand((Command)cmd4);
        ClassObjectFilter filter = new ClassObjectFilter(String.class);
        cmd3 = new GetObjectsCommand((ObjectFilter)filter, "out-id");
        batchCmd.addCommand((Command)cmd3);
        cmd2 = new AgendaGroupSetFocusCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearActivationGroupCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearAgendaCommand();
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearAgendaGroupCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearRuleFlowGroupCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        BatchExecutionCommandImpl batchCmdCopy = (BatchExecutionCommandImpl)this.roundTrip(batchCmd);
        ((AbstractStringAssert)Assertions.assertThat((String)batchCmdCopy.getLookup()).as("Batch cmd lookup", new Object[0])).isEqualTo(batchCmd.getLookup());
        ((AbstractIntegerAssert)Assertions.assertThat((int)batchCmdCopy.getCommands().size()).as("Batch cmd num commands", new Object[0])).isEqualTo(batchCmd.getCommands().size());
        for (Command copyCmd : batchCmdCopy.getCommands()) {
            for (Command origCmd : batchCmd.getCommands()) {
                Object afFieldCopyVal;
                Iterator afFieldOrigVal;
                AgendaFilter origFilter;
                Class<?> cmdClass = origCmd.getClass();
                if (!copyCmd.getClass().equals(cmdClass)) continue;
                if (cmdClass.equals(DeleteCommand.class)) {
                    CommandSerializationTest.compareFactHandles(((DeleteCommand)origCmd).getFactHandle(), ((DeleteCommand)copyCmd).getFactHandle(), DeleteCommand.class);
                    continue;
                }
                if (cmdClass.equals(FireAllRulesCommand.class)) {
                    origFilter = ((FireAllRulesCommand)origCmd).getAgendaFilter();
                    AgendaFilter copyFilter = ((FireAllRulesCommand)copyCmd).getAgendaFilter();
                    if (!origFilter.getClass().equals(copyFilter.getClass())) continue;
                    Class<?> agendaFilterClass = origFilter.getClass();
                    for (Field agendaFilterField : agendaFilterClass.getDeclaredFields()) {
                        agendaFilterField.setAccessible(true);
                        afFieldOrigVal = agendaFilterField.get(origFilter);
                        afFieldCopyVal = agendaFilterField.get(copyFilter);
                        if (afFieldOrigVal instanceof Pattern) {
                            afFieldOrigVal = ((Pattern)((Object)afFieldOrigVal)).pattern();
                            afFieldCopyVal = ((Pattern)afFieldCopyVal).pattern();
                        }
                        ((ObjectAssert)Assertions.assertThat((Object)afFieldCopyVal).as(agendaFilterClass.getSimpleName() + "." + agendaFilterField.getName(), new Object[0])).isEqualTo((Object)afFieldOrigVal);
                    }
                    ((AbstractIntegerAssert)Assertions.assertThat((int)((FireAllRulesCommand)copyCmd).getMax()).as(FireAllRulesCommand.class.getSimpleName() + ".max", new Object[0])).isEqualTo(((FireAllRulesCommand)origCmd).getMax());
                    ((AbstractStringAssert)Assertions.assertThat((String)((FireAllRulesCommand)copyCmd).getOutIdentifier()).as(FireAllRulesCommand.class.getSimpleName() + ".outIdentifier", new Object[0])).isEqualTo(((FireAllRulesCommand)origCmd).getOutIdentifier());
                    continue;
                }
                if (cmdClass.equals(FireUntilHaltCommand.class)) {
                    origFilter = ((FireUntilHaltCommand)origCmd).getAgendaFilter();
                    AgendaFilter copyFilter = ((FireUntilHaltCommand)copyCmd).getAgendaFilter();
                    if (!origFilter.getClass().equals(copyFilter.getClass())) continue;
                    Class<?> agendaFilterClass = origFilter.getClass();
                    for (Field agendaFilterField : agendaFilterClass.getDeclaredFields()) {
                        agendaFilterField.setAccessible(true);
                        afFieldOrigVal = agendaFilterField.get(origFilter);
                        afFieldCopyVal = agendaFilterField.get(copyFilter);
                        if (afFieldOrigVal instanceof Pattern) {
                            afFieldOrigVal = ((Pattern)((Object)afFieldOrigVal)).pattern();
                            afFieldCopyVal = ((Pattern)afFieldCopyVal).pattern();
                        }
                        ((ObjectAssert)Assertions.assertThat((Object)afFieldCopyVal).as(agendaFilterClass.getSimpleName() + "." + agendaFilterField.getName(), new Object[0])).isEqualTo((Object)afFieldOrigVal);
                    }
                    continue;
                }
                for (Field cmdField : cmdClass.getDeclaredFields()) {
                    cmdField.setAccessible(true);
                    if (Modifier.isTransient(cmdField.getModifiers())) continue;
                    Object origVal = cmdField.get(origCmd);
                    ((ObjectAssert)Assertions.assertThat((Object)origVal).as(cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isNotNull();
                    Object copyVal = cmdField.get(copyCmd);
                    ((ObjectAssert)Assertions.assertThat((Object)copyVal).as("Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isNotNull();
                    if (origVal instanceof FactHandle) {
                        CommandSerializationTest.compareFactHandles((FactHandle)origVal, (FactHandle)copyVal, cmdClass);
                        continue;
                    }
                    if (origVal instanceof ClassObjectSerializationFilter) {
                        ((ClassAssert)Assertions.assertThat(((ClassObjectSerializationFilter)copyVal).getClass()).as("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isEqualTo(((ClassObjectSerializationFilter)origVal).getClass());
                        continue;
                    }
                    if (origVal instanceof List) {
                        List origList = (List)origVal;
                        if (((List)copyVal).isEmpty()) {
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)origList.isEmpty()).as("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isTrue();
                            continue;
                        }
                        if (origList.get(0) instanceof Setter) {
                            for (Object obj : (List)origVal) {
                                ((AbstractBooleanAssert)Assertions.assertThat((boolean)(obj instanceof Setter)).as("Expected a " + Setter.class.getSimpleName() + " instance (not " + obj.getClass().getSimpleName() + " in " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isTrue();
                                Iterator iter = ((List)copyVal).iterator();
                                while (iter.hasNext()) {
                                    Setter copySetter = (Setter)iter.next();
                                    if (!((Setter)obj).getAccessor().equals(copySetter.getAccessor())) continue;
                                    ((AbstractStringAssert)Assertions.assertThat((String)copySetter.getValue()).as("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isEqualTo(((Setter)obj).getValue());
                                    iter.remove();
                                }
                            }
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)((List)copyVal).isEmpty()).as("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isTrue();
                            continue;
                        }
                        if (!(origList.get(0) instanceof Map)) continue;
                        Map copyMap = (Map)((List)copyVal).get(0);
                        for (Map.Entry entry : ((Map)origList.get(0)).entrySet()) {
                            ((AbstractBooleanAssert)Assertions.assertThat((boolean)copyMap.containsKey(entry.getKey())).as("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isTrue();
                        }
                        continue;
                    }
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)origVal.equals(copyVal)).as("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName(), new Object[0])).isTrue();
                }
            }
        }
        Field commandsField = BatchExecutionCommandImpl.class.getDeclaredField("commands");
        XmlElements xmlElemsAnno = commandsField.getAnnotation(XmlElements.class);
        ArrayList<Class> cmdTypes = new ArrayList<Class>(xmlElemsAnno.value().length);
        for (XmlElement xmlElem : xmlElemsAnno.value()) {
            cmdTypes.add(xmlElem.type());
        }
        cmdTypes.remove(SignalEventCommand.class);
        cmdTypes.remove(StartProcessCommand.class);
        for (Command cmd5 : batchCmd.getCommands()) {
            cmdTypes.remove(cmd5.getClass());
        }
    }

    private static void compareFactHandles(FactHandle orig, FactHandle copy, Class cmdClass) {
        String origFHString = orig.toExternalForm();
        origFHString = origFHString.substring(0, origFHString.lastIndexOf(":"));
        String copyFHString = copy.toExternalForm();
        copyFHString = copyFHString.substring(0, copyFHString.lastIndexOf(":"));
        ((AbstractStringAssert)Assertions.assertThat((String)copyFHString).as(cmdClass.getSimpleName() + ".facthandle string", new Object[0])).isEqualTo(origFHString);
    }
}

