/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.commands.runtime.ExecutionResultImpl;
import org.drools.commands.runtime.FlatQueryResults;
import org.drools.commands.runtime.process.StartProcessCommand;
import org.drools.commands.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.commands.runtime.rule.ClearActivationGroupCommand;
import org.drools.commands.runtime.rule.ClearAgendaCommand;
import org.drools.commands.runtime.rule.ClearAgendaGroupCommand;
import org.drools.commands.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.commands.runtime.rule.DeleteCommand;
import org.drools.commands.runtime.rule.FireAllRulesCommand;
import org.drools.commands.runtime.rule.GetFactHandlesCommand;
import org.drools.commands.runtime.rule.ModifyCommand;
import org.drools.commands.runtime.rule.UpdateCommand;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.common.DefaultFactHandle;
import org.drools.xml.support.XStreamXML;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Setter;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.utll.xml.XStreamUtils;

public class XStreamXMLTest {
    private XStream xstream;

    @Before
    public void setup() {
        this.xstream = XStreamUtils.createTrustingXStream();
        this.xstream = XStreamXML.newXStreamMarshaller((XStream)this.xstream);
    }

    @Test
    public void testMarshallStartProcessCmd() {
        StartProcessCommand cmd = new StartProcessCommand("some-process-id", "some-out-identifier");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((boolean)xmlString.contains("processId=\"some-process-id\"")).isTrue();
        Assertions.assertThat((boolean)xmlString.contains("out-identifier=\"some-out-identifier\"")).isTrue();
    }

    @Test
    public void testMarshallStartProcessCmdWithNoOutIdentifier() {
        StartProcessCommand cmd = new StartProcessCommand("some-process-id");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((boolean)xmlString.contains("processId=\"some-process-id\"")).isTrue();
    }

    @Test
    public void testUnMarshallStartProcessCmdWithNoOutIdentifier() {
        Object obj = this.xstream.fromXML("<start-process processId=\"some-process-id\"/>");
        Assertions.assertThat(obj.getClass()).isEqualTo(StartProcessCommand.class);
        StartProcessCommand cmd = (StartProcessCommand)obj;
        Assertions.assertThat((String)cmd.getProcessId()).isEqualTo("some-process-id");
    }

    @Test
    public void testMarshallAgendaGroupSetFocusCommand() {
        AgendaGroupSetFocusCommand cmd = new AgendaGroupSetFocusCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<set-focus name=\"foo-group\"/>");
        AgendaGroupSetFocusCommand cmd2 = (AgendaGroupSetFocusCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getName()).isEqualTo(cmd.getName());
    }

    @Test
    public void testClearActivationGroupCommand() {
        ClearActivationGroupCommand cmd = new ClearActivationGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<clear-activation-group name=\"foo-group\"/>");
        ClearActivationGroupCommand cmd2 = (ClearActivationGroupCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getName()).isEqualTo(cmd.getName());
    }

    @Test
    public void testClearAgendaGroupCommand() {
        ClearAgendaGroupCommand cmd = new ClearAgendaGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<clear-agenda-group name=\"foo-group\"/>");
        ClearAgendaGroupCommand cmd2 = (ClearAgendaGroupCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getName()).isEqualTo(cmd.getName());
    }

    @Test
    public void testClearAgendaCommand() {
        ClearAgendaCommand cmd = new ClearAgendaCommand();
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<clear-agenda/>");
        ClearAgendaCommand cmd2 = (ClearAgendaCommand)this.xstream.fromXML(xmlString);
    }

    @Test
    public void testClearRuleFlowGroupCommand() {
        ClearRuleFlowGroupCommand cmd = new ClearRuleFlowGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<clear-ruleflow-group name=\"foo-group\"/>");
        ClearRuleFlowGroupCommand cmd2 = (ClearRuleFlowGroupCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getName()).isEqualTo(cmd.getName());
    }

    @Test
    public void testModifyCommand() {
        DefaultFactHandle factHandle = DefaultFactHandle.createFromExternalFormat((String)"0:1:10:10:20:null:NON_TRAIT:null");
        ModifyCommand cmd = new ModifyCommand((FactHandle)factHandle, Arrays.asList(new ModifyCommand.SetterImpl("name", "value")));
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<modify fact-handle=\"0:1:10:10:20:null:NON_TRAIT:null\">\n  <set accessor=\"name\" value=\"value\"/>\n</modify>");
        ModifyCommand cmd2 = (ModifyCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getFactHandle().toExternalForm()).isEqualTo(factHandle.toExternalForm());
        Assertions.assertThat((int)cmd2.getSetters().size()).isEqualTo(1);
        Assertions.assertThat((String)((Setter)cmd2.getSetters().get(0)).getAccessor()).isEqualTo("name");
        Assertions.assertThat((String)((Setter)cmd2.getSetters().get(0)).getValue()).isEqualTo("value");
    }

    @Test
    public void testDeleteCommand() {
        DefaultFactHandle factHandle = DefaultFactHandle.createFromExternalFormat((String)"0:1:10:10:20:null:NON_TRAIT:null");
        DeleteCommand cmd = new DeleteCommand((FactHandle)factHandle);
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<delete fact-handle=\"0:1:10:10:20:null:NON_TRAIT:null\"/>");
        DeleteCommand cmd2 = (DeleteCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getFactHandle().toExternalForm()).isEqualTo(factHandle.toExternalForm());
    }

    @Test
    public void testGetFactHandlesCommand() {
        GetFactHandlesCommand cmd = new GetFactHandlesCommand();
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<get-fact-handles disconnected=\"false\"/>");
        GetFactHandlesCommand cmd2 = (GetFactHandlesCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getOutIdentifier()).isNull();
    }

    @Test
    public void testGetFactHandlesCommandWithOutIdentifier() {
        GetFactHandlesCommand cmd = new GetFactHandlesCommand();
        cmd.setOutIdentifier("facts");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assertions.assertThat((String)xmlString).isEqualTo("<get-fact-handles disconnected=\"false\" out-identifier=\"facts\"/>");
        GetFactHandlesCommand cmd2 = (GetFactHandlesCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getOutIdentifier()).isEqualTo("facts");
    }

    @Test
    public void testExecutionResults() {
        Message msg = new Message("Hello World!");
        DefaultFactHandle msgHandle = new DefaultFactHandle(1L, null, 10, 10, 20L, (Object)msg);
        Message msg2 = new Message("Hello World again!");
        DefaultFactHandle msgHandle2 = new DefaultFactHandle(2L, null, 10, 10, 20L, (Object)msg2);
        LinkedHashMap<String, DefaultFactHandle> factHandles = new LinkedHashMap<String, DefaultFactHandle>();
        factHandles.put("first", msgHandle);
        factHandles.put("second", msgHandle2);
        ExecutionResultImpl executionResult = new ExecutionResultImpl();
        executionResult.setFactHandles(factHandles);
        LinkedHashMap<String, Message> results = new LinkedHashMap<String, Message>();
        results.put("message1", msg);
        results.put("message2", msg2);
        executionResult.setResults(results);
        String xmlString = this.xstream.toXML((Object)executionResult);
        Assertions.assertThat((String)xmlString).isEqualTo("<execution-results>\n  <result identifier=\"message1\">\n    <org.drools.xml.support.XStreamXMLTest_-Message>\n      <msg>Hello World!</msg>\n    </org.drools.xml.support.XStreamXMLTest_-Message>\n  </result>\n  <result identifier=\"message2\">\n    <org.drools.xml.support.XStreamXMLTest_-Message>\n      <msg>Hello World again!</msg>\n    </org.drools.xml.support.XStreamXMLTest_-Message>\n  </result>\n  <fact-handle identifier=\"first\" external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.xml.support.XStreamXMLTest$Message\"/>\n  <fact-handle identifier=\"second\" external-form=\"0:2:10:10:20:null:NON_TRAIT:org.drools.xml.support.XStreamXMLTest$Message\"/>\n</execution-results>");
        ExecutionResultImpl executionResult2 = (ExecutionResultImpl)this.xstream.fromXML(xmlString);
        Assertions.assertThat((int)executionResult2.getFactHandles().size()).isEqualTo(executionResult.getFactHandles().size());
        Assertions.assertThat((int)executionResult2.getResults().size()).isEqualTo(executionResult.getResults().size());
    }

    @Test
    public void testGetFactHandlesExecutionResults() {
        Message msg = new Message("Hello World!");
        DefaultFactHandle msgHandle = new DefaultFactHandle(1L, null, 10, 10, 20L, (Object)msg);
        Message msg2 = new Message("Hello World again!");
        DefaultFactHandle msgHandle2 = new DefaultFactHandle(2L, null, 10, 10, 20L, (Object)msg2);
        ArrayList<DefaultFactHandle> factHandleList = new ArrayList<DefaultFactHandle>();
        factHandleList.add(msgHandle);
        factHandleList.add(msgHandle2);
        LinkedHashMap factHandles = new LinkedHashMap();
        ExecutionResultImpl executionResult = new ExecutionResultImpl();
        executionResult.setFactHandles(factHandles);
        LinkedHashMap<String, ArrayList<DefaultFactHandle>> results = new LinkedHashMap<String, ArrayList<DefaultFactHandle>>();
        results.put("facts", factHandleList);
        executionResult.setResults(results);
        String xmlString = this.xstream.toXML((Object)executionResult);
        Assertions.assertThat((String)xmlString).isEqualTo("<execution-results>\n  <result identifier=\"facts\">\n    <list>\n      <fact-handle external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.xml.support.XStreamXMLTest$Message\"/>\n      <fact-handle external-form=\"0:2:10:10:20:null:NON_TRAIT:org.drools.xml.support.XStreamXMLTest$Message\"/>\n    </list>\n  </result>\n</execution-results>");
        ExecutionResultImpl executionResult2 = (ExecutionResultImpl)this.xstream.fromXML(xmlString);
        Assertions.assertThat((int)executionResult2.getFactHandles().size()).isEqualTo(executionResult.getFactHandles().size());
        Assertions.assertThat((int)executionResult2.getResults().size()).isEqualTo(executionResult.getResults().size());
    }

    @Test
    public void testQueryResultsConverter() {
        final Message msg = new Message("Hello World!");
        DefaultFactHandle msgHandle = new DefaultFactHandle(1L, null, 10, 10, 20L, (Object)msg);
        HashSet<String> identifiers = new HashSet<String>(){
            {
                this.add("greeting");
            }
        };
        ArrayList<Map<String, FactHandle>> idFactHandleMaps = new ArrayList<Map<String, FactHandle>>((FactHandle)msgHandle){
            final /* synthetic */ FactHandle val$msgHandle;
            {
                this.val$msgHandle = factHandle;
                this.add(new HashMap<String, FactHandle>(){
                    {
                        this.put("greeting", val$msgHandle);
                    }
                });
            }
        };
        ArrayList<Map<String, Object>> factHandleResultMap = new ArrayList<Map<String, Object>>(){
            {
                this.add(new HashMap<String, Object>(){
                    {
                        this.put("greeting", msg);
                    }
                });
            }
        };
        String EXPECTED_XML = "<query-results>\n  <identifiers>\n    <identifier>greeting</identifier>\n  </identifiers>\n  <row>\n    <identifier id=\"greeting\">\n      <org.drools.xml.support.XStreamXMLTest_-Message>\n        <msg>Hello World!</msg>\n      </org.drools.xml.support.XStreamXMLTest_-Message>\n      <fact-handle external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.xml.support.XStreamXMLTest$Message\"/>\n    </identifier>\n  </row>\n</query-results>";
        FlatQueryResults results = new FlatQueryResults((Set)identifiers, (ArrayList)idFactHandleMaps, (ArrayList)factHandleResultMap);
        String xmlString = this.xstream.toXML((Object)results);
        Assertions.assertThat((String)xmlString).isEqualTo("<query-results>\n  <identifiers>\n    <identifier>greeting</identifier>\n  </identifiers>\n  <row>\n    <identifier id=\"greeting\">\n      <org.drools.xml.support.XStreamXMLTest_-Message>\n        <msg>Hello World!</msg>\n      </org.drools.xml.support.XStreamXMLTest_-Message>\n      <fact-handle external-form=\"0:1:10:10:20:null:NON_TRAIT:org.drools.xml.support.XStreamXMLTest$Message\"/>\n    </identifier>\n  </row>\n</query-results>");
        QueryResults results2 = (QueryResults)this.xstream.fromXML(xmlString);
        Assertions.assertThat((Iterable)results2).isEqualTo((Object)results);
    }

    @Test
    public void testUpdateCommand() {
        DefaultFactHandle factHandle = DefaultFactHandle.createFromExternalFormat((String)"0:1:10:10:20:null:NON_TRAIT:null");
        UpdateCommand cmd = new UpdateCommand((FactHandle)factHandle, (Object)new Message("Hello World!"), new String[]{"msg"});
        String xmlString = this.xstream.toXML((Object)cmd);
        String expected = "<update fact-handle=\"0:1:10:10:20:null:NON_TRAIT:null\" entryPoint=\"DEFAULT\">\n  <org.drools.xml.support.XStreamXMLTest_-Message>\n    <msg>Hello World!</msg>\n  </org.drools.xml.support.XStreamXMLTest_-Message>\n  <modifiedProperty value=\"msg\"/>\n</update>";
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)xmlString);
        UpdateCommand cmd2 = (UpdateCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((String)cmd2.getHandle().toExternalForm()).isEqualTo(factHandle.toExternalForm());
        Assertions.assertThat((int)cmd2.getModifiedProperties().length).isEqualTo(1);
        Assertions.assertThat((String)cmd2.getModifiedProperties()[0]).isEqualTo("msg");
    }

    @Test
    public void testFireAllRulesCommand() {
        RuleNameEndsWithAgendaFilter filter = new RuleNameEndsWithAgendaFilter("mySuffix", true);
        FireAllRulesCommand cmd = new FireAllRulesCommand("ABC", 100, (AgendaFilter)filter);
        String xmlString = this.xstream.toXML((Object)cmd);
        String expected = "<fire-all-rules max=\"100\" out-identifier=\"ABC\">\n  <agendaFilter class=\"org.drools.core.base.RuleNameEndsWithAgendaFilter\">\n    <suffix>mySuffix</suffix>\n    <accept>true</accept>\n  </agendaFilter>\n</fire-all-rules>";
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)xmlString);
        FireAllRulesCommand cmd2 = (FireAllRulesCommand)this.xstream.fromXML(xmlString);
        Assertions.assertThat((int)cmd2.getMax()).isEqualTo(100);
        Assertions.assertThat(cmd2.getAgendaFilter().getClass()).isEqualTo(RuleNameEndsWithAgendaFilter.class);
        Assertions.assertThat((String)((RuleNameEndsWithAgendaFilter)cmd2.getAgendaFilter()).getSuffix()).isEqualTo("mySuffix");
        Assertions.assertThat((boolean)((RuleNameEndsWithAgendaFilter)cmd2.getAgendaFilter()).isAccept()).isTrue();
    }

    private static class Message {
        String msg;

        public Message() {
        }

        public Message(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message message = (Message)o;
            return !(this.msg == null ? message.msg != null : !this.msg.equals(message.msg));
        }

        public int hashCode() {
            return this.msg != null ? this.msg.hashCode() : 0;
        }
    }
}

