/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.spring.extension;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import org.jboss.seam.spring.context.SpringContext;
import org.jboss.seam.spring.extension.SpringBeanProducer;
import org.jboss.seam.spring.extension.SpringContextBean;
import org.jboss.seam.spring.extension.SpringContextLiteral;
import org.jboss.seam.spring.extension.SpringContextProducer;
import org.jboss.seam.spring.inject.SpringBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringContextBootstrapExtension
implements Extension {
    public Map<String, ConfigurableApplicationContext> contextDefinitions = new HashMap<String, ConfigurableApplicationContext>();
    private Set<String> vetoedTypes = new HashSet<String>();

    public void handleSpringExtensionProducers(@Observes ProcessProducer<?, Object> processProducer, BeanManager beanManager) {
        if (processProducer.getAnnotatedMember().isAnnotationPresent(SpringBean.class)) {
            processProducer.setProducer((Producer)new SpringBeanProducer(processProducer, beanManager));
        } else if (processProducer.getAnnotatedMember().isAnnotationPresent(SpringContext.class)) {
            processProducer.setProducer((Producer)new SpringContextProducer(processProducer, processProducer.getProducer()));
        }
    }

    public void loadSpringContext(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/org.jboss.seam.spring.contexts");
        if (inputStream != null) {
            Properties contextLocations = new Properties();
            try {
                contextLocations.load(inputStream);
                for (String contextName : contextLocations.stringPropertyNames()) {
                    ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contextLocations.getProperty(contextName));
                    this.contextDefinitions.put(contextName, (ConfigurableApplicationContext)context);
                    for (String beanDefinitionName : context.getBeanDefinitionNames()) {
                        this.vetoedTypes.add(context.getBeanFactory().getBeanDefinition(beanDefinitionName).getBeanClassName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void registerSpringContextBeans(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        for (String contextName : this.contextDefinitions.keySet()) {
            afterBeanDiscovery.addBean((Bean)new SpringContextBean(this.contextDefinitions.get(contextName), new SpringContextLiteral(contextName)));
        }
    }

    public void autoVeto(@Observes ProcessAnnotatedType<?> processAnnotatedType) {
        String name = processAnnotatedType.getAnnotatedType().getJavaClass().getName();
        if (this.vetoedTypes.contains(name)) {
            processAnnotatedType.veto();
        }
    }
}

