/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.spring.factorybean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.spring.factorybean.CdiBeanLookup;
import org.jboss.seam.spring.utils.AnnotationInvocationHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TypeSafeCdiBeanLookup<T>
implements CdiBeanLookup<T>,
ApplicationContextAware {
    private final Class<T> expectedType;
    private Qualifier[] qualifiers = new Qualifier[0];
    private ConversionService conversionService;

    public TypeSafeCdiBeanLookup(Class<T> expectedType) {
        Assert.notNull(expectedType, (String)"Expected type cannot be null");
        this.expectedType = expectedType;
    }

    public void setQualifiers(Qualifier[] qualifiers) {
        this.qualifiers = qualifiers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            Object conversionServiceBeanInstance = applicationContext.getBean("conversionService");
            if (conversionServiceBeanInstance instanceof ConversionService) {
                this.conversionService = (ConversionService)conversionServiceBeanInstance;
            }
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        this.conversionService = new GenericConversionService();
    }

    @Override
    public T lookupBean(BeanManager beanManager) {
        try {
            ArrayList<Annotation> qualifierAnnotations = new ArrayList<Annotation>();
            for (Qualifier qualifier : this.qualifiers) {
                Class<?> qualifierClass = ClassUtils.getDefaultClassLoader().loadClass(qualifier.getClassName());
                if (!beanManager.isQualifier(qualifierClass)) {
                    throw new BeanCreationException(qualifierClass + " is not a valid JSR-299 qualifier");
                }
                AnnotationInvocationHandler annotationInvocationHandler = new AnnotationInvocationHandler(qualifierClass).withConversionService(this.conversionService).withAttributes(qualifier.getAttributes());
                qualifierAnnotations.add((Annotation)Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), new Class[]{qualifierClass}, (InvocationHandler)annotationInvocationHandler));
            }
            Bean resolvedBean = beanManager.resolve(beanManager.getBeans(this.expectedType, qualifierAnnotations.toArray(new Annotation[0])));
            Assert.notNull((Object)resolvedBean, (String)"Cannot find a CDI bean");
            return (T)beanManager.getReference(resolvedBean, this.expectedType, beanManager.createCreationalContext((Contextual)resolvedBean));
        }
        catch (Exception e) {
            throw new BeanCreationException("Cannot look up bean: ", (Throwable)e);
        }
    }

    @Override
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public static class Qualifier {
        private String className;
        private Map<String, Object> attributes;

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }
    }
}

