/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.spring.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;

public class AnnotationInvocationHandler
implements InvocationHandler,
Annotation {
    private Map<String, Object> registeredValues = new HashMap<String, Object>();
    private ConversionService conversionService = null;
    private Class<? extends Annotation> annotationType;

    public AnnotationInvocationHandler(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    public static AnnotationInvocationHandler ofType(Class<Annotation> annotationType) {
        return new AnnotationInvocationHandler(annotationType);
    }

    public AnnotationInvocationHandler withConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public AnnotationInvocationHandler withAttributes(Map<String, Object> registeredValues) {
        this.registeredValues = registeredValues;
        for (Method method : this.annotationType.getDeclaredMethods()) {
            String currentAttribute = method.getName();
            Object registeredValue = registeredValues.get(currentAttribute);
            if (registeredValue != null || method.getDefaultValue() != null) continue;
            throw new IllegalArgumentException("Required attribute '" + currentAttribute + "' not set for " + this.annotationType.getName() + " instance, and no default is specified");
        }
        return this;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(AnnotationInvocationHandler.class) || method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().equals(Annotation.class)) {
            return method.invoke((Object)this, args);
        }
        if (this.registeredValues != null && this.registeredValues.containsKey(method.getName())) {
            if (this.conversionService != null) {
                return this.conversionService.convert(this.registeredValues.get(method.getName()), method.getReturnType());
            }
            return this.registeredValues.get(method.getName());
        }
        return method.getDefaultValue();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationInvocationHandler)) {
            return false;
        }
        AnnotationInvocationHandler that = (AnnotationInvocationHandler)o;
        if (this.annotationType != null ? !this.annotationType.equals(that.annotationType) : that.annotationType != null) {
            return false;
        }
        return !(this.registeredValues != null ? !((Object)this.registeredValues).equals(that.registeredValues) : that.registeredValues != null);
    }

    @Override
    public int hashCode() {
        int result = this.registeredValues != null ? ((Object)this.registeredValues).hashCode() : 0;
        result = 31 * result + (this.annotationType != null ? this.annotationType.hashCode() : 0);
        return result;
    }
}

