/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.ldap;

import java.util.Collections;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractUntypedSearchConditionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapQueryVisitor<T>
extends AbstractUntypedSearchConditionVisitor<T, String> {
    public LdapQueryVisitor() {
        this(Collections.emptyMap());
    }

    public LdapQueryVisitor(Map<String, String> fieldMap) {
        super(fieldMap);
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        StringBuilder sb = this.getStringBuilder();
        if (sb == null) {
            sb = new StringBuilder();
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                String rvalStr = statement.getValue().toString();
                String name = this.getRealPropertyName(statement.getProperty());
                sb.append("(");
                if (sc.getConditionType() == ConditionType.NOT_EQUALS) {
                    sb.append("!");
                }
                String ldapOperator = LdapQueryVisitor.conditionTypeToLdapOperator(sc.getConditionType());
                sb.append(name).append(ldapOperator).append(rvalStr);
                sb.append(")");
            }
        } else {
            sb.append("(");
            if (sc.getConditionType() == ConditionType.AND) {
                sb.append("&");
            } else {
                sb.append("|");
            }
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                this.saveStringBuilder(sb);
                condition.accept(this);
                sb = this.getStringBuilder();
            }
            sb.append(")");
        }
        this.saveStringBuilder(sb);
    }

    public static String conditionTypeToLdapOperator(ConditionType ct) {
        String op;
        switch (ct) {
            case EQUALS: 
            case NOT_EQUALS: {
                op = "=";
                break;
            }
            case GREATER_THAN: 
            case GREATER_OR_EQUALS: {
                op = ">=";
                break;
            }
            case LESS_THAN: 
            case LESS_OR_EQUALS: {
                op = "<=";
                break;
            }
            default: {
                String msg = String.format("Condition type %s is not supported", ct.name());
                throw new RuntimeException(msg);
            }
        }
        return op;
    }
}

