/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.RuntimeCamelException;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

public class CxfPayload<T> {
    private List<Source> body;
    private List<T> headers;
    private Map<String, String> nsMap;

    public CxfPayload(List<T> headers, List<Source> body, Map<String, String> nsMap) {
        this.headers = headers;
        this.body = body;
        this.nsMap = nsMap;
    }

    public CxfPayload(List<T> headers, List<Element> body) {
        this.headers = headers;
        this.body = new ArrayList<Source>(body.size());
        for (Element el : body) {
            this.body.add(new DOMSource(el));
        }
    }

    public List<Element> getBody() {
        return new AbstractList<Element>(){

            @Override
            public boolean add(Element e) {
                return CxfPayload.this.body.add(new DOMSource(e));
            }

            @Override
            public Element set(int index, Element element) {
                Source s = CxfPayload.this.body.set(index, new DOMSource(element));
                try {
                    return StaxUtils.read((Source)s).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeCamelException("Problem converting content to Element", (Throwable)e);
                }
            }

            @Override
            public void add(int index, Element element) {
                CxfPayload.this.body.add(index, new DOMSource(element));
            }

            @Override
            public Element remove(int index) {
                Source s = (Source)CxfPayload.this.body.remove(index);
                try {
                    return StaxUtils.read((Source)s).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeCamelException("Problem converting content to Element", (Throwable)e);
                }
            }

            @Override
            public Element get(int index) {
                Source s = (Source)CxfPayload.this.body.get(index);
                try {
                    Element el = StaxUtils.read((Source)s).getDocumentElement();
                    CxfPayload.addNamespace(el, CxfPayload.this.nsMap);
                    CxfPayload.this.body.set(index, new DOMSource(el));
                    return el;
                }
                catch (Exception ex) {
                    throw new RuntimeCamelException("Problem converting content to Element", (Throwable)ex);
                }
            }

            @Override
            public int size() {
                return CxfPayload.this.body.size();
            }
        };
    }

    protected static void addNamespace(Element element, Map<String, String> nsMap) {
        if (nsMap != null) {
            for (String ns : nsMap.keySet()) {
                element.setAttribute("xmlns:" + ns, nsMap.get(ns));
            }
        }
    }

    public List<Source> getBodySources() {
        return this.body;
    }

    public List<T> getHeaders() {
        return this.headers;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append(" headers: " + this.headers);
        if (this.body == null) {
            buf.append("body: " + this.body);
        } else {
            buf.append("body: [ ");
            for (Element src : this.getBody()) {
                String elementString;
                try {
                    elementString = StaxUtils.toString((Element)src);
                }
                catch (XMLStreamException e) {
                    elementString = src.toString();
                }
                buf.append("[" + elementString + "]");
            }
            buf.append("]");
        }
        return buf.toString();
    }
}

