/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private static final Logger LOG = Log.getLogger(BlockingChannelConnector.class);
    private transient ServerSocketChannel _acceptChannel;
    private final Set<BlockingChannelEndPoint> _endpoints = new ConcurrentHashSet();

    public Object getConnection() {
        return this._acceptChannel;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getThreadPool().dispatch(new Runnable(){

            public void run() {
                while (BlockingChannelConnector.this.isRunning()) {
                    try {
                        Thread.sleep(400L);
                        long now = System.currentTimeMillis();
                        for (BlockingChannelEndPoint endp : BlockingChannelConnector.this._endpoints) {
                            endp.checkIdleTimestamp(now);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.ignore((Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }
        });
    }

    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        BlockingChannelEndPoint connection = new BlockingChannelEndPoint(channel);
        connection.dispatch();
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        endpoint.setMaxIdleTime(this._maxIdleTime);
        this.configure(((SocketChannel)endpoint.getTransport()).socket());
    }

    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    private class BlockingChannelEndPoint
    extends ChannelEndPoint
    implements Runnable,
    ConnectedEndPoint {
        private Connection _connection;
        private int _timeout;
        private volatile long _idleTimestamp;

        BlockingChannelEndPoint(ByteChannel channel) throws IOException {
            super(channel, BlockingChannelConnector.this._maxIdleTime);
            this._connection = new BlockingHttpConnection(BlockingChannelConnector.this, (EndPoint)this, BlockingChannelConnector.this.getServer());
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            this._connection = connection;
        }

        public void checkIdleTimestamp(long now) {
            if (this._idleTimestamp != 0L && this._timeout > 0 && now > this._idleTimestamp + (long)this._timeout) {
                this.idleExpired();
            }
        }

        protected void idleExpired() {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }

        void dispatch() throws IOException {
            if (!BlockingChannelConnector.this.getThreadPool().dispatch((Runnable)this)) {
                LOG.warn("dispatch failed for  {}", new Object[]{this._connection});
                this.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            this._idleTimestamp = System.currentTimeMillis();
            return super.fill(buffer);
        }

        public int flush(Buffer buffer) throws IOException {
            this._idleTimestamp = System.currentTimeMillis();
            return super.flush(buffer);
        }

        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            this._idleTimestamp = System.currentTimeMillis();
            return super.flush(header, buffer, trailer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block38: {
                this._timeout = this.getMaxIdleTime();
                BlockingChannelConnector.this.connectionOpened(this._connection);
                BlockingChannelConnector.this._endpoints.add(this);
                while (this.isOpen()) {
                    this._idleTimestamp = System.currentTimeMillis();
                    if (this._connection.isIdle()) {
                        int lrmit;
                        if (BlockingChannelConnector.this.getServer().getThreadPool().isLowOnThreads() && (lrmit = BlockingChannelConnector.this.getLowResourcesMaxIdleTime()) >= 0 && this._timeout != lrmit) {
                            this._timeout = lrmit;
                        }
                    } else if (this._timeout != this.getMaxIdleTime()) {
                        this._timeout = this.getMaxIdleTime();
                    }
                    this._connection = this._connection.handle();
                }
                Object var4_5 = null;
                BlockingChannelConnector.this.connectionClosed(this._connection);
                BlockingChannelConnector.this._endpoints.remove(this);
                try {
                    if (!this._socket.isClosed()) {
                        long timestamp = System.currentTimeMillis();
                        int max_idle = this.getMaxIdleTime();
                        this._socket.setSoTimeout(this.getMaxIdleTime());
                        int c = 0;
                        while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                        }
                        if (!this._socket.isClosed()) {
                            this._socket.close();
                        }
                    }
                    break block38;
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
                break block38;
                {
                    catch (EofException e) {
                        LOG.debug("EOF", (Throwable)e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            LOG.ignore((Throwable)e2);
                        }
                        Object var4_6 = null;
                        BlockingChannelConnector.this.connectionClosed(this._connection);
                        BlockingChannelConnector.this._endpoints.remove(this);
                        try {
                            if (!this._socket.isClosed()) {
                                long timestamp = System.currentTimeMillis();
                                int max_idle = this.getMaxIdleTime();
                                this._socket.setSoTimeout(this.getMaxIdleTime());
                                int c = 0;
                                while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                                }
                                if (!this._socket.isClosed()) {
                                    this._socket.close();
                                }
                            }
                            break block38;
                        }
                        catch (IOException e2) {
                            LOG.ignore((Throwable)e2);
                        }
                        break block38;
                    }
                    catch (HttpException e) {
                        LOG.debug("BAD", (Throwable)e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            LOG.ignore((Throwable)e2);
                        }
                        Object var4_7 = null;
                        BlockingChannelConnector.this.connectionClosed(this._connection);
                        BlockingChannelConnector.this._endpoints.remove(this);
                        try {
                            if (!this._socket.isClosed()) {
                                long timestamp = System.currentTimeMillis();
                                int max_idle = this.getMaxIdleTime();
                                this._socket.setSoTimeout(this.getMaxIdleTime());
                                int c = 0;
                                while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                                }
                                if (!this._socket.isClosed()) {
                                    this._socket.close();
                                }
                            }
                            break block38;
                        }
                        catch (IOException e2) {
                            LOG.ignore((Throwable)e2);
                        }
                        break block38;
                    }
                    catch (Throwable e) {
                        LOG.warn("handle failed", e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            LOG.ignore((Throwable)e2);
                        }
                        Object var4_8 = null;
                        BlockingChannelConnector.this.connectionClosed(this._connection);
                        BlockingChannelConnector.this._endpoints.remove(this);
                        try {
                            if (!this._socket.isClosed()) {
                                long timestamp = System.currentTimeMillis();
                                int max_idle = this.getMaxIdleTime();
                                this._socket.setSoTimeout(this.getMaxIdleTime());
                                int c = 0;
                                while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                                }
                                if (!this._socket.isClosed()) {
                                    this._socket.close();
                                }
                            }
                            break block38;
                        }
                        catch (IOException e2) {
                            LOG.ignore((Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    BlockingChannelConnector.this.connectionClosed(this._connection);
                    BlockingChannelConnector.this._endpoints.remove(this);
                    try {
                        if (!this._socket.isClosed()) {
                            long timestamp = System.currentTimeMillis();
                            int max_idle = this.getMaxIdleTime();
                            this._socket.setSoTimeout(this.getMaxIdleTime());
                            int c = 0;
                            while ((c = this._socket.getInputStream().read()) >= 0 && System.currentTimeMillis() - timestamp < (long)max_idle) {
                            }
                            if (!this._socket.isClosed()) {
                                this._socket.close();
                            }
                        }
                    }
                    catch (IOException e2) {
                        LOG.ignore((Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

