/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.util.HashMap;
import java.util.Map;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.springframework.context.ApplicationContext;

public final class KieSpringUtils {
    private static ReleaseId defaultReleaseId;
    static Map<ReleaseId, ApplicationContext> applicationContextMap;
    static KieServices ks;

    public static ApplicationContext getSpringContext(ReleaseId releaseId) {
        return applicationContextMap.get(releaseId == null ? defaultReleaseId : releaseId);
    }

    public static ApplicationContext getDefaultSpringContext() {
        return KieSpringUtils.getSpringContext(null);
    }

    static void setReleaseIdForContext(ReleaseId releaseId, ApplicationContext applicationContext) {
        applicationContextMap.put(releaseId, applicationContext);
    }

    static void setDefaultReleaseId(ReleaseId releaseId) {
        defaultReleaseId = releaseId;
    }

    static {
        applicationContextMap = new HashMap<ReleaseId, ApplicationContext>();
        ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.getKieClasspathContainer();
    }
}

