/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectCommand
implements GenericCommand<Object>,
IdentifiableResult {
    private FactHandle factHandle;
    private String outIdentifier;

    public GetObjectCommand() {
    }

    public GetObjectCommand(FactHandle factHandle) {
        this.factHandle = factHandle;
    }

    public GetObjectCommand(FactHandle factHandle, String outIdentifier) {
        this.factHandle = factHandle;
        this.outIdentifier = outIdentifier;
    }

    @Override
    @XmlAttribute(name="out-identifier", required=true)
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @XmlAttribute(name="fact-handle", required=true)
    public void setFactHandleFromString(String factHandleId) {
        this.factHandle = new DefaultFactHandle(factHandleId);
    }

    public String getFactHandleFromString() {
        return this.factHandle.toExternalForm();
    }

    @Override
    public Object execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        Object object = ksession.getObject(this.factHandle);
        if (this.outIdentifier != null) {
            ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult().getResults().put(this.outIdentifier, object);
        }
        return object;
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    public String toString() {
        return "session.getObject( " + this.factHandle + " );";
    }
}

