/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthorizingInterceptor
extends AbstractAuthorizingInInterceptor {
    protected Map<String, List<String>> methodRolesMap = new HashMap<String, List<String>>();
    protected Map<String, List<String>> userRolesMap = Collections.emptyMap();
    protected List<String> globalRoles = Collections.emptyList();
    private boolean checkConfiguredRolesOnly;

    @Override
    protected boolean isUserInRole(SecurityContext sc, List<String> roles, boolean deny) {
        if (!this.checkConfiguredRolesOnly && !super.isUserInRole(sc, roles, deny)) {
            return false;
        }
        if (!this.userRolesMap.isEmpty()) {
            List<String> userRoles = this.userRolesMap.get(sc.getUserPrincipal().getName());
            if (userRoles == null) {
                return false;
            }
            for (String role : roles) {
                if (!userRoles.contains(role)) continue;
                return true;
            }
            return false;
        }
        return !this.checkConfiguredRolesOnly;
    }

    protected String createMethodSig(Method method) {
        StringBuilder b = new StringBuilder(method.getReturnType().getName());
        b.append(' ').append(method.getName()).append('(');
        boolean first = true;
        for (Class<?> cls : method.getParameterTypes()) {
            if (!first) {
                b.append(", ");
                first = false;
            }
            b.append(cls.getName());
        }
        b.append(')');
        return b.toString();
    }

    @Override
    protected List<String> getExpectedRoles(Method method) {
        List<String> roles = this.methodRolesMap.get(this.createMethodSig(method));
        if (roles == null) {
            roles = this.methodRolesMap.get(method.getName());
        }
        if (roles != null) {
            return roles;
        }
        return this.globalRoles;
    }

    public void setMethodRolesMap(Map<String, String> rolesMap) {
        this.methodRolesMap.putAll(SimpleAuthorizingInterceptor.parseRolesMap(rolesMap));
    }

    public void setUserRolesMap(Map<String, String> rolesMap) {
        this.userRolesMap = SimpleAuthorizingInterceptor.parseRolesMap(rolesMap);
    }

    public void setGlobalRoles(String roles) {
        this.globalRoles = Arrays.asList(StringUtils.split((String)roles, (String)" "));
    }

    public void setCheckConfiguredRolesOnly(boolean checkConfiguredRolesOnly) {
        this.checkConfiguredRolesOnly = checkConfiguredRolesOnly;
    }

    private static Map<String, List<String>> parseRolesMap(Map<String, String> rolesMap) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : rolesMap.entrySet()) {
            map.put(entry.getKey(), Arrays.asList(StringUtils.split((String)entry.getValue(), (String)" ")));
        }
        return map;
    }
}

