/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.xml;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.drools.compiler.kproject.xml.MinimalPomParser;
import org.drools.compiler.kproject.xml.PomModelGenerator;
import org.kie.api.builder.ReleaseId;

public class PomModel {
    private ReleaseId releaseId;
    private ReleaseId parentReleaseId;
    private Set<ReleaseId> dependencies = new HashSet<ReleaseId>();

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public ReleaseId getParentReleaseId() {
        return this.parentReleaseId;
    }

    public void setParentReleaseId(ReleaseId parentReleaseId) {
        this.parentReleaseId = parentReleaseId;
    }

    public Collection<ReleaseId> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(ReleaseId dependency) {
        this.dependencies.add(dependency);
    }

    private static class DefaultPomModelGenerator
    implements PomModelGenerator {
        private DefaultPomModelGenerator() {
        }

        @Override
        public PomModel parse(String path, InputStream is) {
            return MinimalPomParser.parse(path, is);
        }
    }

    public static class Parser {
        public static PomModel parse(String path, InputStream is) {
            return PomModelGeneratorHolder.pomModelGenerator.parse(path, is);
        }

        private static class PomModelGeneratorHolder {
            private static PomModelGenerator pomModelGenerator;

            private PomModelGeneratorHolder() {
            }

            static {
                try {
                    pomModelGenerator = (PomModelGenerator)Class.forName("org.kie.scanner.MavenPomModelGenerator").newInstance();
                }
                catch (Exception e) {
                    pomModelGenerator = new DefaultPomModelGenerator();
                }
            }
        }
    }
}

