/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.BusState;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.buslifecycle.BusCreationListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class CXFBusImpl
extends AbstractBasicInterceptorProvider
implements Bus {
    static final boolean FORCE_LOGGING;
    protected final Map<Class<?>, Object> extensions;
    protected final Set<Class<?>> missingExtensions;
    protected String id;
    private BusState state;
    private final Collection<AbstractFeature> features = new CopyOnWriteArrayList<AbstractFeature>();
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>(16, 0.75f, 4);

    public CXFBusImpl() {
        this(null);
    }

    public CXFBusImpl(Map<Class<?>, Object> extensions) {
        extensions = extensions == null ? new ConcurrentHashMap(16, 0.75f, 4) : new ConcurrentHashMap(extensions);
        this.extensions = extensions;
        this.missingExtensions = new CopyOnWriteArraySet();
        this.state = BusState.INITIAL;
        CXFBusFactory.possiblySetDefaultBus(this);
        if (FORCE_LOGGING) {
            this.features.add(new LoggingFeature());
        }
    }

    protected void setState(BusState state) {
        this.state = state;
    }

    public void setId(String i) {
        this.id = i;
    }

    @Override
    public final <T> T getExtension(Class<T> extensionType) {
        Object obj = this.extensions.get(extensionType);
        if (obj == null) {
            if (this.missingExtensions.contains(extensionType)) {
                return null;
            }
            ConfiguredBeanLocator loc = (ConfiguredBeanLocator)this.extensions.get(ConfiguredBeanLocator.class);
            if (loc == null) {
                loc = this.createConfiguredBeanLocator();
            }
            if (loc != null) {
                Collection<T> objs = loc.getBeansOfType(extensionType);
                if (objs != null) {
                    for (T o : objs) {
                        this.extensions.put(extensionType, o);
                    }
                }
                obj = this.extensions.get(extensionType);
            }
        }
        if (null != obj) {
            return extensionType.cast(obj);
        }
        this.missingExtensions.add(extensionType);
        return null;
    }

    @Override
    public boolean hasExtensionByName(String name) {
        for (Class<?> c : this.extensions.keySet()) {
            if (!name.equals(c.getName())) continue;
            return true;
        }
        ConfiguredBeanLocator loc = (ConfiguredBeanLocator)this.extensions.get(ConfiguredBeanLocator.class);
        if (loc == null) {
            loc = this.createConfiguredBeanLocator();
        }
        if (loc != null) {
            return loc.hasBeanOfName(name);
        }
        return false;
    }

    protected synchronized ConfiguredBeanLocator createConfiguredBeanLocator() {
        ConfiguredBeanLocator loc = (ConfiguredBeanLocator)this.extensions.get(ConfiguredBeanLocator.class);
        if (loc == null) {
            loc = new ConfiguredBeanLocator(){

                @Override
                public List<String> getBeanNamesOfType(Class<?> type) {
                    return null;
                }

                @Override
                public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
                    return null;
                }

                @Override
                public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
                    return false;
                }

                @Override
                public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value) {
                    return false;
                }

                @Override
                public <T> T getBeanOfType(String name, Class<T> type) {
                    return null;
                }

                @Override
                public boolean hasBeanOfName(String name) {
                    return false;
                }
            };
            this.setExtension(loc, ConfiguredBeanLocator.class);
        }
        return loc;
    }

    @Override
    public <T> void setExtension(T extension, Class<T> extensionType) {
        this.extensions.put(extensionType, extension);
        this.missingExtensions.remove(extensionType);
    }

    @Override
    public String getId() {
        return null == this.id ? "cxf" + Integer.toString(Math.abs(this.hashCode())) : this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            this.state = BusState.RUNNING;
            while (this.state == BusState.RUNNING) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void initialize() {
        this.setState(BusState.INITIALIZING);
        Collection<BusCreationListener> ls = this.getExtension(ConfiguredBeanLocator.class).getBeansOfType(BusCreationListener.class);
        for (BusCreationListener l : ls) {
            l.busCreated(this);
        }
        this.doInitializeInternal();
        BusLifeCycleManager lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != lifeCycleManager) {
            lifeCycleManager.initComplete();
        }
        this.setState(BusState.RUNNING);
    }

    protected void doInitializeInternal() {
        this.initializeFeatures();
    }

    protected void loadAdditionalFeatures() {
    }

    protected void initializeFeatures() {
        this.loadAdditionalFeatures();
        if (this.features != null) {
            for (AbstractFeature f : this.features) {
                f.initialize(this);
            }
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    protected void destroyBeans() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean wait) {
        if (this.state == BusState.SHUTTING_DOWN) {
            return;
        }
        BusLifeCycleManager lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != lifeCycleManager) {
            lifeCycleManager.preShutdown();
        }
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            this.state = BusState.SHUTTING_DOWN;
        }
        this.destroyBeans();
        cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            this.state = BusState.SHUTDOWN;
            this.notifyAll();
        }
        if (null != lifeCycleManager) {
            lifeCycleManager.postShutdown();
        }
        if (BusFactory.getDefaultBus(false) == this) {
            BusFactory.setDefaultBus(null);
        }
        BusFactory.clearDefaultBusForAnyThread(this);
    }

    public BusState getState() {
        return this.state;
    }

    @Override
    public Collection<AbstractFeature> getFeatures() {
        return this.features;
    }

    public synchronized void setFeatures(Collection<AbstractFeature> features) {
        this.features.clear();
        this.features.addAll(features);
        if (FORCE_LOGGING) {
            this.features.add(new LoggingFeature());
        }
        if (this.state == BusState.RUNNING) {
            this.initializeFeatures();
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> map) {
        this.properties.clear();
        this.properties.putAll(map);
    }

    @Override
    public Object getProperty(String s) {
        return this.properties.get(s);
    }

    @Override
    public void setProperty(String s, Object o) {
        if (o == null) {
            this.properties.remove(s);
        } else {
            this.properties.put(s, o);
        }
    }

    static {
        boolean b = false;
        try {
            b = Boolean.getBoolean("org.apache.cxf.logging.enabled");
            b |= Boolean.getBoolean("com.sun.xml.ws.transport.local.LocalTransportPipe.dump");
            b |= Boolean.getBoolean("com.sun.xml.ws.util.pipe.StandaloneTubeAssembler.dump");
            b |= Boolean.getBoolean("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump");
            b |= Boolean.getBoolean("com.sun.xml.ws.transport.http.HttpAdapter.dump");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FORCE_LOGGING = b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExtensionFinder {
        public <T> T findExtension(Class<T> var1);
    }
}

