/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.Map;
import org.drools.core.StatefulSession;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.Row;

public class BooleanCell
implements Cell {
    Row row;
    Boolean value;
    Column column;
    private int index;

    public BooleanCell() {
    }

    BooleanCell(Row r, Column c) {
        this.row = r;
        this.column = c;
    }

    public String toString() {
        return "Cell[" + this.column + ": " + this.value + "]";
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void addValue(Map<String, Object> vars) {
        vars.put(this.column.getName(), this.value);
    }

    @Override
    public void insert(StatefulSession session) {
        session.insert((Object)this);
    }

    @Override
    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setValue(String v) {
        this.value = new Boolean(v);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }
}

