/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class BeanHelper {
    private BeanHelper() {
    }

    public static Class<?> getValidParameterType(String value) {
        if (ObjectHelper.isEmpty(value)) {
            return null;
        }
        if ((value = value.trim()).startsWith("'") && value.endsWith("'")) {
            return String.class;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return String.class;
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.class;
        }
        if (value.equals("null")) {
            return Object.class;
        }
        if (StringHelper.hasStartToken(value, "simple")) {
            return Object.class;
        }
        boolean numeric = true;
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            numeric = false;
            break;
        }
        if (numeric) {
            return Number.class;
        }
        return null;
    }

    public static boolean isValidParameterValue(String value) {
        if (ObjectHelper.isEmpty(value)) {
            return true;
        }
        return BeanHelper.getValidParameterType(value) != null;
    }

    public static Boolean isAssignableToExpectedType(ClassResolver resolver, String parameterType, Class<?> expectedType) {
        Class<?> parameterClass = resolver.resolveClass(parameterType);
        if (parameterClass == null && parameterType.equals(expectedType.getSimpleName())) {
            return true;
        }
        if (parameterClass == null) {
            return null;
        }
        return parameterClass.isAssignableFrom(expectedType);
    }
}

