/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class DefaultExchangeFormatter
implements ExchangeFormatter {
    protected static final String LS = System.getProperty("line.separator");
    private static final String SEPARATOR = "###REPLACE_ME###";
    private boolean showExchangeId;
    private boolean showExchangePattern = true;
    private boolean showProperties;
    private boolean showHeaders;
    private boolean skipBodyLineSeparator = true;
    private boolean showBodyType = true;
    private boolean showBody = true;
    private boolean showOut;
    private boolean showException;
    private boolean showCaughtException;
    private boolean showStackTrace;
    private boolean showAll;
    private boolean multiline;
    private boolean showFuture;
    private boolean showStreams;
    private boolean showFiles;
    private int maxChars = 10000;
    private OutputStyle style = OutputStyle.Default;

    private String style(String label) {
        if (this.style == OutputStyle.Default) {
            return String.format(", %s: ", label);
        }
        if (this.style == OutputStyle.Tab) {
            return String.format("\t%s: ", label);
        }
        return String.format("\t%-20s", label);
    }

    @Override
    public String format(Exchange exchange) {
        Message in = exchange.getIn();
        StringBuilder sb = new StringBuilder();
        if (this.showAll || this.showExchangeId) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            sb.append(this.style("Id")).append(exchange.getExchangeId());
        }
        if (this.showAll || this.showExchangePattern) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            sb.append(this.style("ExchangePattern")).append((Object)exchange.getPattern());
        }
        if (this.showAll || this.showProperties) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            sb.append(this.style("Properties")).append(DefaultExchangeFormatter.sortMap(exchange.getProperties()));
        }
        if (this.showAll || this.showHeaders) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            sb.append(this.style("Headers")).append(DefaultExchangeFormatter.sortMap(in.getHeaders()));
        }
        if (this.showAll || this.showBodyType) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            sb.append(this.style("BodyType")).append(this.getBodyTypeAsString(in));
        }
        if (this.showAll || this.showBody) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            String body = this.getBodyAsString(in);
            if (this.skipBodyLineSeparator) {
                body = StringHelper.replaceAll(body, LS, "");
            }
            sb.append(this.style("Body")).append(body);
        }
        if (this.showAll || this.showException || this.showCaughtException) {
            Exception exception = exchange.getException();
            boolean caught = false;
            if ((this.showAll || this.showCaughtException) && exception == null) {
                exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                caught = true;
            }
            if (exception != null) {
                if (this.multiline) {
                    sb.append(SEPARATOR);
                }
                if (caught) {
                    sb.append(this.style("CaughtExceptionType")).append(exception.getClass().getCanonicalName());
                    sb.append(this.style("CaughtExceptionMessage")).append(exception.getMessage());
                } else {
                    sb.append(this.style("ExceptionType")).append(exception.getClass().getCanonicalName());
                    sb.append(this.style("ExceptionMessage")).append(exception.getMessage());
                }
                if (this.showAll || this.showStackTrace) {
                    StringWriter sw = new StringWriter();
                    exception.printStackTrace(new PrintWriter(sw));
                    sb.append(this.style("StackTrace")).append(sw.toString());
                }
            }
        }
        if (this.showAll || this.showOut) {
            if (exchange.hasOut()) {
                Message out = exchange.getOut();
                if (this.showAll || this.showHeaders) {
                    if (this.multiline) {
                        sb.append(SEPARATOR);
                    }
                    sb.append(this.style("OutHeaders")).append(DefaultExchangeFormatter.sortMap(out.getHeaders()));
                }
                if (this.showAll || this.showBodyType) {
                    if (this.multiline) {
                        sb.append(SEPARATOR);
                    }
                    sb.append(this.style("OutBodyType")).append(this.getBodyTypeAsString(out));
                }
                if (this.showAll || this.showBody) {
                    if (this.multiline) {
                        sb.append(SEPARATOR);
                    }
                    String body = this.getBodyAsString(out);
                    if (this.skipBodyLineSeparator) {
                        body = StringHelper.replaceAll(body, LS, "");
                    }
                    sb.append(this.style("OutBody")).append(body);
                }
            } else {
                if (this.multiline) {
                    sb.append(SEPARATOR);
                }
                sb.append(this.style("Out: null"));
            }
        }
        if (this.maxChars > 0) {
            StringBuilder answer = new StringBuilder();
            for (String s : sb.toString().split(SEPARATOR)) {
                if (s == null) continue;
                if (s.length() > this.maxChars) {
                    s = s.substring(0, this.maxChars);
                    answer.append(s).append("...");
                } else {
                    answer.append(s);
                }
                if (!this.multiline) continue;
                answer.append(LS);
            }
            sb = answer;
        }
        if (this.multiline) {
            sb.insert(0, "Exchange[");
            sb.append("]");
            return sb.toString();
        }
        if (sb.length() > 0 && sb.charAt(0) == ',' && sb.charAt(1) == ' ') {
            sb.replace(0, 2, "");
        }
        sb.insert(0, "Exchange[");
        sb.append("]");
        return sb.toString();
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isSkipBodyLineSeparator() {
        return this.skipBodyLineSeparator;
    }

    public void setSkipBodyLineSeparator(boolean skipBodyLineSeparator) {
        this.skipBodyLineSeparator = skipBodyLineSeparator;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowOut() {
        return this.showOut;
    }

    public void setShowOut(boolean showOut) {
        this.showOut = showOut;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public boolean isShowCaughtException() {
        return this.showCaughtException;
    }

    public void setShowCaughtException(boolean showCaughtException) {
        this.showCaughtException = showCaughtException;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isShowFuture() {
        return this.showFuture;
    }

    public void setShowFuture(boolean showFuture) {
        this.showFuture = showFuture;
    }

    public boolean isShowExchangePattern() {
        return this.showExchangePattern;
    }

    public void setShowExchangePattern(boolean showExchangePattern) {
        this.showExchangePattern = showExchangePattern;
    }

    public boolean isShowStreams() {
        return this.showStreams;
    }

    public void setShowStreams(boolean showStreams) {
        this.showStreams = showStreams;
    }

    public boolean isShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public OutputStyle getStyle() {
        return this.style;
    }

    public void setStyle(OutputStyle style) {
        this.style = style;
    }

    protected String getBodyAsString(Message message) {
        if (message.getBody() instanceof Future && !this.isShowFuture()) {
            return message.getBody().toString();
        }
        return MessageHelper.extractBodyForLogging(message, "", this.isShowStreams(), this.isShowFiles(), this.getMaxChars());
    }

    protected String getBodyTypeAsString(Message message) {
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    private static Map<String, Object> sortMap(Map<String, Object> map) {
        TreeMap<String, Object> answer = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        answer.putAll(map);
        return answer;
    }

    public static enum OutputStyle {
        Default,
        Tab,
        Fixed;

    }
}

