/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayProcessorSupport
extends DelegateAsyncProcessor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CamelContext camelContext;
    private final ScheduledExecutorService executorService;
    private final boolean shutdownExecutorService;
    private boolean asyncDelayed;
    private boolean callerRunsWhenRejected = true;
    private final AtomicInteger delayedCount = new AtomicInteger(0);

    public DelayProcessorSupport(CamelContext camelContext, Processor processor) {
        this(camelContext, processor, null, false);
    }

    public DelayProcessorSupport(CamelContext camelContext, Processor processor, ScheduledExecutorService executorService, boolean shutdownExecutorService) {
        super(processor);
        this.camelContext = camelContext;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        long delay;
        if (!this.isRunAllowed()) {
            exchange.setException(new RejectedExecutionException("Run is not allowed"));
            callback.done(true);
            return true;
        }
        try {
            delay = this.calculateDelay(exchange);
            if (delay <= 0L) {
                this.log.trace("No delay for exchangeId: {}", (Object)exchange.getExchangeId());
                return this.processor.process(exchange, callback);
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        if (!this.isAsyncDelayed() || exchange.isTransacted()) {
            try {
                this.delay(delay, exchange);
                return this.processor.process(exchange, callback);
            }
            catch (Exception e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        this.delayedCount.incrementAndGet();
        ProcessCall call = new ProcessCall(exchange, callback);
        try {
            this.log.trace("Scheduling delayed task to run in {} millis for exchangeId: {}", (Object)delay, (Object)exchange.getExchangeId());
            this.executorService.schedule(call, delay, TimeUnit.MILLISECONDS);
            return false;
        }
        catch (RejectedExecutionException e) {
            block14: {
                this.delayedCount.decrementAndGet();
                if (this.isCallerRunsWhenRejected()) {
                    if (!this.isRunAllowed()) {
                        exchange.setException(new RejectedExecutionException());
                        break block14;
                    } else {
                        this.log.debug("Scheduling rejected task, so letting caller run, delaying at first for {} millis for exchangeId: {}", (Object)delay, (Object)exchange.getExchangeId());
                        try {
                            this.delay(delay, exchange);
                            return this.processor.process(exchange, callback);
                        }
                        catch (InterruptedException ie) {
                            exchange.setException(ie);
                        }
                        return this.processor.process(exchange, callback);
                    }
                }
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }

    public boolean isAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(boolean asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    protected abstract long calculateDelay(Exchange var1);

    public int getDelayedCount() {
        return this.delayedCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(long delay, Exchange exchange) throws InterruptedException {
        if (!this.isRunAllowed()) {
            return;
        }
        if (delay < 0L) {
            return;
        }
        try {
            this.delayedCount.incrementAndGet();
            this.sleep(delay);
        }
        catch (InterruptedException e) {
            this.handleSleepInterruptedException(e, exchange);
        }
        finally {
            this.delayedCount.decrementAndGet();
        }
    }

    protected void handleSleepInterruptedException(InterruptedException e, Exchange exchange) throws InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
        }
        Thread.currentThread().interrupt();
        throw e;
    }

    protected long currentSystemTime() {
        return System.currentTimeMillis();
    }

    private void sleep(long delay) throws InterruptedException {
        if (delay <= 0L) {
            return;
        }
        this.log.trace("Sleeping for: {} millis", (Object)delay);
        Thread.sleep(delay);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isAsyncDelayed()) {
            ObjectHelper.notNull(this.executorService, "executorService", this);
        }
        super.doStart();
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.shutdownExecutorService && this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        super.doShutdown();
    }

    private final class ProcessCall
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        public ProcessCall(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        @Override
        public void run() {
            DelayProcessorSupport.this.delayedCount.decrementAndGet();
            DelayProcessorSupport.this.log.trace("Delayed task woke up and continues routing for exchangeId: {}", (Object)this.exchange.getExchangeId());
            if (!DelayProcessorSupport.this.isRunAllowed()) {
                this.exchange.setException(new RejectedExecutionException("Run is not allowed"));
            }
            DelayProcessorSupport.this.processor.process(this.exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    DelayProcessorSupport.this.log.trace("Delayed task done for exchangeId: {}", (Object)ProcessCall.this.exchange.getExchangeId());
                    ProcessCall.this.callback.done(false);
                }
            });
        }
    }
}

