/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollEnricher
extends ServiceSupport
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PollEnricher.class);
    private AggregationStrategy aggregationStrategy;
    private PollingConsumer consumer;
    private long timeout;

    public PollEnricher(PollingConsumer consumer) {
        this(PollEnricher.defaultAggregationStrategy(), consumer, 0L);
    }

    public PollEnricher(AggregationStrategy aggregationStrategy, PollingConsumer consumer, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.consumer = consumer;
        this.timeout = timeout;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = PollEnricher.defaultAggregationStrategy();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange resourceExchange;
        try {
            this.preCheckPoll(exchange);
        }
        catch (Exception e) {
            exchange.setException(new CamelExchangeException("Error during pre poll check", exchange, e));
            callback.done(true);
            return true;
        }
        if (this.timeout < 0L) {
            LOG.debug("Consumer receive: {}", (Object)this.consumer);
            resourceExchange = this.consumer.receive();
        } else if (this.timeout == 0L) {
            LOG.debug("Consumer receiveNoWait: {}", (Object)this.consumer);
            resourceExchange = this.consumer.receiveNoWait();
        } else {
            LOG.debug("Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)this.consumer);
            resourceExchange = this.consumer.receive(this.timeout);
        }
        if (resourceExchange == null) {
            LOG.debug("Consumer received no exchange");
        } else {
            LOG.debug("Consumer received: {}", (Object)resourceExchange);
        }
        if (resourceExchange != null && resourceExchange.isFailed()) {
            ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
        } else {
            PollEnricher.prepareResult(exchange);
            try {
                ExchangeHelper.prepareAggregation(exchange, resourceExchange);
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                    if (resourceExchange != null) {
                        resourceExchange.handoverCompletions(exchange);
                    }
                }
            }
            catch (Throwable e) {
                exchange.setException(new CamelExchangeException("Error occurred during aggregation", exchange, e));
                callback.done(true);
                return true;
            }
        }
        if (exchange.hasOut()) {
            exchange.getOut().setHeader("CamelToEndpoint", this.consumer.getEndpoint().getEndpointUri());
        } else {
            exchange.getIn().setHeader("CamelToEndpoint", this.consumer.getEndpoint().getEndpointUri());
        }
        callback.done(true);
        return true;
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "PollEnrich[" + this.consumer + "]";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.aggregationStrategy, this.consumer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.consumer, this.aggregationStrategy);
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            } else {
                oldExchange.getIn().setBody(null);
                oldExchange.setOut(null);
            }
            return oldExchange;
        }
    }
}

