/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.WrappedFile;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHelper.class);
    private static final String DEFAULT_DELIMITER = ",";
    private static final List<?> PRIMITIVE_ARRAY_TYPES = Arrays.asList(byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, char[].class, boolean[].class);

    private ObjectHelper() {
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        boolean answer = ObjectHelper.equal(leftValue, rightValue);
        if (answer) {
            return true;
        }
        if (leftValue.getClass().isInstance(rightValue)) {
            return false;
        }
        Object value = converter.tryConvertTo(rightValue.getClass(), leftValue);
        answer = ObjectHelper.equal(value, rightValue);
        if (answer) {
            return true;
        }
        value = converter.tryConvertTo(leftValue.getClass(), rightValue);
        answer = ObjectHelper.equal(leftValue, value);
        return answer;
    }

    public static boolean typeCoerceNotEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return !ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue);
    }

    public static int typeCoerceCompare(TypeConverter converter, Object leftValue, Object rightValue) {
        Object value;
        Long leftNum = converter.tryConvertTo(Long.class, leftValue);
        Long rightNum = converter.tryConvertTo(Long.class, rightValue);
        if (leftNum != null && rightNum != null) {
            return leftNum.compareTo(rightNum);
        }
        Double leftDouble = converter.tryConvertTo(Double.class, leftValue);
        Double rightDouble = converter.tryConvertTo(Double.class, rightValue);
        if (leftDouble != null && rightDouble != null) {
            return leftDouble.compareTo(rightDouble);
        }
        if (rightValue instanceof String && !(leftValue instanceof String)) {
            return ObjectHelper.typeCoerceCompare(converter, rightValue, leftValue) * -1;
        }
        if (rightValue instanceof Comparable && (value = converter.tryConvertTo(rightValue.getClass(), leftValue)) != null) {
            return ((Comparable)rightValue).compareTo(value) * -1;
        }
        if (leftValue instanceof Comparable && (value = converter.tryConvertTo(leftValue.getClass(), rightValue)) != null) {
            return ((Comparable)leftValue).compareTo(value);
        }
        return ObjectHelper.compare(leftValue, rightValue);
    }

    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return ObjectHelper.equalByteArray((byte[])a, (byte[])b);
        }
        return a != null && b != null && a.equals(b);
    }

    public static boolean equalByteArray(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null && a.length == b.length) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEqualToAny(Object object, Object ... values) {
        for (Object value : values) {
            if (!ObjectHelper.equal(object, value)) continue;
            return true;
        }
        return false;
    }

    public static int compare(Object a, Object b) {
        return ObjectHelper.compare(a, b, false);
    }

    public static int compare(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Ordered && b instanceof Ordered) {
            return ((Ordered)a).getOrder() - ((Ordered)b).getOrder();
        }
        if (ignoreCase && a instanceof String && b instanceof String) {
            return ((String)a).compareToIgnoreCase((String)b);
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static <T> T notNull(T value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " must be specified");
        }
        return value;
    }

    public static <T> T notNull(T value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (value == null) {
            throw new IllegalArgumentException(name + " must be specified on: " + on);
        }
        return value;
    }

    public static String notEmpty(String value, String name) {
        if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty");
        }
        return value;
    }

    public static String notEmpty(String value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty on: " + on);
        }
        return value;
    }

    public static boolean isEmpty(Object value) {
        return !ObjectHelper.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        return true;
    }

    public static String[] splitOnCharacter(String value, String needle, int count) {
        String[] rc = new String[count];
        rc[0] = value;
        for (int i = 1; i < count; ++i) {
            String v = rc[i - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i - 1] = v.substring(0, p);
            rc[i] = v.substring(p + 1);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    public static String capitalize(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        String answer = text.substring(0, 1).toUpperCase(Locale.ENGLISH);
        if (length > 1) {
            answer = answer + text.substring(1, length);
        }
        return answer;
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String before(String text, String before) {
        if (!text.contains(before)) {
            return null;
        }
        return text.substring(0, text.indexOf(before));
    }

    public static String between(String text, String after, String before) {
        if ((text = ObjectHelper.after(text, after)) == null) {
            return null;
        }
        return ObjectHelper.before(text, before);
    }

    public static boolean contains(Object collectionOrArray, Object value) {
        if (collectionOrArray != null && (collectionOrArray instanceof StringBuffer || collectionOrArray instanceof StringBuilder)) {
            collectionOrArray = collectionOrArray.toString();
        }
        if (value != null && (value instanceof StringBuffer || value instanceof StringBuilder)) {
            value = value.toString();
        }
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String && value instanceof String) {
            String str = (String)collectionOrArray;
            String subStr = (String)value;
            return str.contains(subStr);
        }
        Iterator<Object> iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!ObjectHelper.equal(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    public static Iterator<Object> createIterator(Object value) {
        return ObjectHelper.createIterator(value, DEFAULT_DELIMITER);
    }

    public static Iterator<Object> createIterator(Object value, String delimiter) {
        return ObjectHelper.createIterator(value, delimiter, false);
    }

    public static Iterator<Object> createIterator(Object value, String delimiter, final boolean allowEmptyValues) {
        if (value instanceof Message) {
            value = ((Message)value).getBody();
        }
        if (value == null) {
            return Collections.emptyList().iterator();
        }
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value.getClass().isArray()) {
            if (ObjectHelper.isPrimitiveArrayType(value.getClass())) {
                final Object array = value;
                return new Iterator<Object>(){
                    int idx = -1;

                    @Override
                    public boolean hasNext() {
                        return this.idx + 1 < Array.getLength(array);
                    }

                    @Override
                    public Object next() {
                        ++this.idx;
                        return Array.get(array, this.idx);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            List<Object> list = Arrays.asList((Object[])value);
            return list.iterator();
        }
        if (value instanceof NodeList) {
            final NodeList nodeList = (NodeList)value;
            return new Iterator<Object>(){
                int idx = -1;

                @Override
                public boolean hasNext() {
                    return this.idx + 1 < nodeList.getLength();
                }

                @Override
                public Object next() {
                    ++this.idx;
                    return nodeList.item(this.idx);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (value instanceof String) {
            final String s = (String)value;
            if (delimiter != null && s.contains(delimiter)) {
                Scanner scanner = new Scanner((String)value);
                if (DEFAULT_DELIMITER.equals(delimiter)) {
                    delimiter = ",(?!(?:[^\\(,]|[^\\)],[^\\)])+\\))";
                }
                scanner.useDelimiter(delimiter);
                return CastUtils.cast(scanner);
            }
            return new Iterator<Object>(){
                int idx = -1;

                @Override
                public boolean hasNext() {
                    return this.idx + 1 == 0 && (allowEmptyValues || ObjectHelper.isNotEmpty(s));
                }

                @Override
                public Object next() {
                    ++this.idx;
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.singletonList(value).iterator();
    }

    public static boolean matches(List<?> list) {
        if (!list.isEmpty()) {
            Object value = list.get(0);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return true;
        }
        return false;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caught security exception accessing system property: " + name + ". Will use default value: " + defaultValue, (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static boolean getSystemProperty(String name, Boolean defaultValue) {
        String result = ObjectHelper.getSystemProperty(name, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static Properties getCamelPropertiesWithPrefix(String prefix, CamelContext camelContext) {
        Properties answer = new Properties();
        Map<String, String> camelProperties = camelContext.getProperties();
        if (camelProperties != null) {
            for (Map.Entry<String, String> entry : camelProperties.entrySet()) {
                String key = entry.getKey();
                if (key == null || !key.startsWith(prefix)) continue;
                answer.put(key.substring(prefix.length()), entry.getValue());
            }
        }
        return answer;
    }

    public static String name(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    public static String className(Object value) {
        return ObjectHelper.name(value != null ? value.getClass() : null);
    }

    public static String classCanonicalName(Object value) {
        if (value != null) {
            return value.getClass().getCanonicalName();
        }
        return null;
    }

    public static Class<?> loadClass(String name) {
        return ObjectHelper.loadClass(name, ObjectHelper.class.getClassLoader());
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        return ObjectHelper.loadClass(name, loader, false);
    }

    public static Class<?> loadClass(String name, ClassLoader loader, boolean needToWarn) {
        if (ObjectHelper.isEmpty(name = ObjectHelper.normalizeClassName(name))) {
            return null;
        }
        Class<?> clazz = ObjectHelper.loadSimpleType(name);
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, Thread.currentThread().getContextClassLoader());
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, loader);
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, ObjectHelper.class.getClassLoader());
        }
        if (clazz == null) {
            if (needToWarn) {
                LOG.warn("Cannot find class: " + name);
            } else {
                LOG.debug("Cannot find class: " + name);
            }
        }
        return clazz;
    }

    public static Class<?> loadSimpleType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        return null;
    }

    private static Class<?> doLoadClass(String name, ClassLoader loader) {
        ObjectHelper.notEmpty(name, "name");
        if (loader == null) {
            return null;
        }
        try {
            LOG.trace("Loading class: {} using classloader: {}", (Object)name, (Object)loader);
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cannot load class: " + name + " using classloader: " + loader, (Throwable)e);
            }
            return null;
        }
    }

    public static InputStream loadResourceAsStream(String name) {
        InputStream in = null;
        String resolvedName = ObjectHelper.resolveUriPath(name);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            in = contextClassLoader.getResourceAsStream(resolvedName);
        }
        if (in == null) {
            in = ObjectHelper.class.getClassLoader().getResourceAsStream(resolvedName);
        }
        if (in == null) {
            in = ObjectHelper.class.getResourceAsStream(resolvedName);
        }
        return in;
    }

    public static URL loadResourceAsURL(String name) {
        URL url = null;
        String resolvedName = ObjectHelper.resolveUriPath(name);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(resolvedName);
        }
        if (url == null) {
            url = ObjectHelper.class.getClassLoader().getResource(resolvedName);
        }
        if (url == null) {
            url = ObjectHelper.class.getResource(resolvedName);
        }
        return url;
    }

    public static Enumeration<URL> loadResourcesAsURL(String packageName) {
        Enumeration<URL> url = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                url = contextClassLoader.getResources(packageName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (url == null) {
            try {
                url = ObjectHelper.class.getClassLoader().getResources(packageName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath(name, '/');
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InvocationTargetException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e.getCause());
        }
    }

    public static boolean isOverridingMethod(Method source, Method target) {
        if (source.getName().equals(target.getName()) && source.getReturnType().equals(target.getReturnType()) && source.getParameterTypes().length == target.getParameterTypes().length) {
            for (int i = 0; i < source.getParameterTypes().length; ++i) {
                if (source.getParameterTypes()[i].equals(target.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return ObjectHelper.findMethodsWithAnnotation(type, annotationType, false);
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!ObjectHelper.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String asString(Object[] objects) {
        if (objects == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder("{");
        int counter = 0;
        for (Object object : objects) {
            if (counter++ > 0) {
                buffer.append(", ");
            }
            String text = object == null ? "null" : object.toString();
            buffer.append(text);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
        a = ObjectHelper.convertPrimitiveTypeToWrapperType(a);
        b = ObjectHelper.convertPrimitiveTypeToWrapperType(b);
        return a.isAssignableFrom(b);
    }

    public static boolean isPrimitiveArrayType(Class<?> clazz) {
        return PRIMITIVE_ARRAY_TYPES.contains(clazz);
    }

    public static int arrayLength(Object[] pojo) {
        return pojo.length;
    }

    public static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type) {
        Class<Object> rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            } else if (type == Boolean.TYPE) {
                rc = Boolean.class;
            }
        }
        return rc;
    }

    public static String getDefaultCharacterSet() {
        return Charset.defaultCharset().name();
    }

    public static String getPropertyName(Method method) {
        String propertyName = method.getName();
        if (propertyName.startsWith("set") && method.getParameterTypes().length == 1) {
            propertyName = propertyName.substring(3, 4).toLowerCase(Locale.ENGLISH) + propertyName.substring(4);
        }
        return propertyName;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<?> type) {
        for (Annotation annotation : annotations) {
            if (!type.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> A getAnnotation(Object instance, Class<A> type) {
        return instance.getClass().getAnnotation(type);
    }

    @Deprecated
    public static void close(Closeable closeable, String name, Logger log) {
        IOHelper.close(closeable, name, log);
    }

    public static <T> T cast(Class<T> toType, Object value) {
        Class<?> newType;
        if (toType == Boolean.TYPE) {
            return (T)ObjectHelper.cast(Boolean.class, value);
        }
        if (toType.isPrimitive() && (newType = ObjectHelper.convertPrimitiveTypeToWrapperType(toType)) != toType) {
            return (T)ObjectHelper.cast(newType, value);
        }
        try {
            return toType.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to convert: " + value + " to type: " + toType.getName() + " due to: " + e, e);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static <T> T newInstance(Class<?> actualType, Class<T> expectedType) {
        try {
            Object value = actualType.newInstance();
            return ObjectHelper.cast(expectedType, value);
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static boolean hasDefaultPublicNoArgConstructor(Class<?> type) {
        for (Constructor<?> ctr : type.getConstructors()) {
            if (ctr.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < size; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object type(Object bean) {
        return bean != null ? bean.getClass() : null;
    }

    public static boolean evaluateValuePredicate(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equalsIgnoreCase((String)value)) {
                return true;
            }
            if ("false".equalsIgnoreCase((String)value)) {
                return false;
            }
        } else {
            if (value instanceof NodeList) {
                if (value instanceof Node && ((Node)value).hasAttributes()) {
                    return true;
                }
                NodeList list = (NodeList)value;
                return list.getLength() > 0;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.size() > 0;
            }
        }
        return value != null;
    }

    public static RuntimeCamelException wrapRuntimeCamelException(Throwable e) {
        if (e instanceof RuntimeCamelException) {
            return (RuntimeCamelException)e;
        }
        return new RuntimeCamelException(e);
    }

    public static CamelExecutionException wrapCamelExecutionException(Exchange exchange, Throwable e) {
        if (e instanceof CamelExecutionException) {
            return (CamelExecutionException)e;
        }
        return new CamelExecutionException("Exception occurred during execution", exchange, e);
    }

    public static String normalizeClassName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (char ch : name.toCharArray()) {
            if (ch != '.' && ch != '[' && ch != ']' && ch != '-' && !Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return new ExceptionIterator(exception);
    }

    public static <T> T getException(Class<T> type, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Iterator<Throwable> it = ObjectHelper.createExceptionIterator(exception);
        while (it.hasNext()) {
            Throwable e = it.next();
            if (!type.isInstance(e)) continue;
            return type.cast(e);
        }
        return null;
    }

    public static Scanner getScanner(Exchange exchange, Object value) {
        String text;
        if (value instanceof WrappedFile) {
            WrappedFile gf = (WrappedFile)value;
            return ObjectHelper.getScanner(exchange, gf.getFile());
        }
        String charset = exchange.getProperty("CamelCharsetName", String.class);
        Scanner scanner = null;
        if (value instanceof Readable) {
            scanner = new Scanner((Readable)value);
        } else if (value instanceof InputStream) {
            scanner = charset == null ? new Scanner((InputStream)value) : new Scanner((InputStream)value, charset);
        } else if (value instanceof File) {
            try {
                scanner = charset == null ? new Scanner((File)value) : new Scanner((File)value, charset);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeCamelException(e);
            }
        } else if (value instanceof String) {
            scanner = new Scanner((String)value);
        } else if (value instanceof ReadableByteChannel) {
            Scanner scanner2 = scanner = charset == null ? new Scanner((ReadableByteChannel)value) : new Scanner((ReadableByteChannel)value, charset);
        }
        if (scanner == null && (text = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value)) != null) {
            scanner = new Scanner(text);
        }
        if (scanner == null) {
            scanner = new Scanner("");
        }
        return scanner;
    }

    public static String getIdentityHashCode(Object object) {
        return "0x" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String lookupConstantFieldValue(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        if (name.startsWith(DEFAULT_DELIMITER)) {
            name = name.substring(1);
        }
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            try {
                Object v = field.get(null);
                return v.toString();
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isNaN(Object value) {
        if (value == null || !(value instanceof Number)) {
            return false;
        }
        return value.equals(Float.valueOf(Float.NaN)) || value.equals(Double.NaN);
    }

    private static final class ExceptionIterator
    implements Iterator<Throwable> {
        private List<Throwable> tree = new ArrayList<Throwable>();
        private Iterator<Throwable> it;

        public ExceptionIterator(Throwable exception) {
            for (Throwable current = exception; current != null; current = current.getCause()) {
                this.tree.add(current);
            }
            Collections.reverse(this.tree);
            this.it = this.tree.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Throwable next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

