/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.pmml;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.dmg.pmml.pmml_4_2.descr.Array;
import org.dmg.pmml.pmml_4_2.descr.Attribute;
import org.dmg.pmml.pmml_4_2.descr.Characteristic;
import org.dmg.pmml.pmml_4_2.descr.Characteristics;
import org.dmg.pmml.pmml_4_2.descr.CompoundPredicate;
import org.dmg.pmml.pmml_4_2.descr.DATATYPE;
import org.dmg.pmml.pmml_4_2.descr.DataDictionary;
import org.dmg.pmml.pmml_4_2.descr.DataField;
import org.dmg.pmml.pmml_4_2.descr.Extension;
import org.dmg.pmml.pmml_4_2.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_2.descr.Header;
import org.dmg.pmml.pmml_4_2.descr.MiningField;
import org.dmg.pmml.pmml_4_2.descr.MiningSchema;
import org.dmg.pmml.pmml_4_2.descr.OPTYPE;
import org.dmg.pmml.pmml_4_2.descr.Output;
import org.dmg.pmml.pmml_4_2.descr.OutputField;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.dmg.pmml.pmml_4_2.descr.RESULTFEATURE;
import org.dmg.pmml.pmml_4_2.descr.Scorecard;
import org.dmg.pmml.pmml_4_2.descr.SimplePredicate;
import org.dmg.pmml.pmml_4_2.descr.SimpleSetPredicate;
import org.dmg.pmml.pmml_4_2.descr.Timestamp;
import org.drools.core.util.StringUtils;
import org.drools.pmml.pmml_4_2.extensions.PMMLIOAdapterMode;
import org.drools.scorecards.StringUtil;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;

public class ScorecardPMMLGenerator {
    public PMML generateDocument(Scorecard pmmlScorecard) {
        Extension importsExt;
        this.removeEmptyExtensions(pmmlScorecard);
        this.createAndSetPredicates(pmmlScorecard);
        this.createAndSetOutput(pmmlScorecard);
        this.repositionExternalClassExtensions(pmmlScorecard);
        Extension scorecardPackage = ScorecardPMMLUtils.getExtension(pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas(), "modelPackage");
        if (scorecardPackage != null) {
            pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().remove(scorecardPackage);
        }
        if ((importsExt = ScorecardPMMLUtils.getExtension(pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas(), "importsFromDelimitedString")) != null) {
            pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().remove(importsExt);
        }
        PMML pmml = new PMML();
        Header header = new Header();
        Timestamp timestamp = new Timestamp();
        timestamp.getContent().add(new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z", Locale.ENGLISH).format(new Date()));
        header.setTimestamp(timestamp);
        header.setDescription("generated by the drools-scorecards module");
        header.getExtensions().add(scorecardPackage);
        header.getExtensions().add(importsExt);
        pmml.setHeader(header);
        this.createAndSetDataDictionary(pmml, pmmlScorecard);
        pmml.getAssociationModelsAndBaselineModelsAndClusteringModels().add(pmmlScorecard);
        this.removeAttributeFieldExtension(pmmlScorecard);
        return pmml;
    }

    private void repositionExternalClassExtensions(Scorecard pmmlScorecard) {
        Characteristics characteristics = null;
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            characteristics = (Characteristics)obj;
            break;
        }
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (obj instanceof MiningSchema) {
                MiningSchema schema = (MiningSchema)obj;
                Extension adapter = new Extension();
                adapter.setName("adapter");
                adapter.setValue(PMMLIOAdapterMode.BEAN.name());
                schema.getExtensions().add(adapter);
                for (MiningField miningField : schema.getMiningFields()) {
                    String fieldName = miningField.getName();
                    for (Characteristic characteristic : characteristics.getCharacteristics()) {
                        Extension extension;
                        String characteristicName = ScorecardPMMLUtils.extractFieldNameFromCharacteristic(characteristic);
                        if (!fieldName.equalsIgnoreCase(characteristicName) || (extension = ScorecardPMMLUtils.getExtension(characteristic.getExtensions(), "externalClass")) == null) continue;
                        characteristic.getExtensions().remove(extension);
                        if (ScorecardPMMLUtils.getExtension(miningField.getExtensions(), "externalClass") != null) continue;
                        miningField.getExtensions().add(extension);
                    }
                }
                MiningField targetField = new MiningField();
                targetField.setName("scorecard__calculatedScore");
                targetField.setUsageType(FIELDUSAGETYPE.PREDICTED);
                schema.getMiningFields().add(targetField);
                continue;
            }
            if (!(obj instanceof Output)) continue;
            Extension adapter = new Extension();
            adapter.setName("adapter");
            adapter.setValue(PMMLIOAdapterMode.BEAN.name());
            ((Output)obj).getExtensions().add(adapter);
        }
    }

    private void removeAttributeFieldExtension(Scorecard pmmlScorecard) {
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                for (Attribute attribute : characteristic.getAttributes()) {
                    Extension fieldExtension = ScorecardPMMLUtils.getExtension(attribute.getExtensions(), "field");
                    if (fieldExtension == null) continue;
                    attribute.getExtensions().remove(fieldExtension);
                }
            }
        }
    }

    private void createAndSetDataDictionary(PMML pmml, Scorecard pmmlScorecard) {
        DataDictionary dataDictionary = new DataDictionary();
        pmml.setDataDictionary(dataDictionary);
        int ctr = 0;
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                DataField dataField = new DataField();
                Extension dataTypeExtension = ScorecardPMMLUtils.getExtension(characteristic.getExtensions(), "dataType");
                String dataType = dataTypeExtension.getValue();
                String factType = ScorecardPMMLUtils.getExtensionValue(characteristic.getExtensions(), "factType");
                if (factType != null) {
                    Extension extension = new Extension();
                    extension.setName("FactType");
                    extension.setValue(factType);
                    dataField.getExtensions().add(extension);
                }
                if ("Number".equalsIgnoreCase(dataType)) {
                    dataField.setDataType(DATATYPE.DOUBLE);
                    dataField.setOptype(OPTYPE.CONTINUOUS);
                } else if ("Text".equalsIgnoreCase(dataType)) {
                    dataField.setDataType(DATATYPE.STRING);
                    dataField.setOptype(OPTYPE.CATEGORICAL);
                } else if ("Boolean".equalsIgnoreCase(dataType)) {
                    dataField.setDataType(DATATYPE.BOOLEAN);
                    dataField.setOptype(OPTYPE.CATEGORICAL);
                }
                String field = "";
                block2: for (Attribute attribute : characteristic.getAttributes()) {
                    for (Extension extension : attribute.getExtensions()) {
                        if (!"field".equalsIgnoreCase(extension.getName())) continue;
                        field = extension.getValue();
                        continue block2;
                    }
                }
                dataField.setName(field);
                dataDictionary.getDataFields().add(dataField);
                characteristic.getExtensions().remove(dataTypeExtension);
                ++ctr;
            }
        }
        DataField targetField = new DataField();
        targetField.setName("scorecard__calculatedScore");
        targetField.setDataType(DATATYPE.DOUBLE);
        targetField.setOptype(OPTYPE.CONTINUOUS);
        dataDictionary.getDataFields().add(targetField);
        dataDictionary.setNumberOfFields(BigInteger.valueOf(ctr + 1));
    }

    private void createAndSetOutput(Scorecard pmmlScorecard) {
        Extension classExtension = ScorecardPMMLUtils.getExtension(pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas(), "externalClass");
        Extension fieldExtension = ScorecardPMMLUtils.getExtension(pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas(), "final");
        Extension reasonCodeExtension = ScorecardPMMLUtils.getExtension(pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas(), "reasonCodeField");
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Output)) continue;
            Output output = (Output)obj;
            OutputField outputField = new OutputField();
            outputField.setDataType(DATATYPE.DOUBLE);
            outputField.setFeature(RESULTFEATURE.PREDICTED_VALUE);
            outputField.setDisplayName("Final Score");
            if (fieldExtension != null) {
                pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().remove(fieldExtension);
                outputField.setName(fieldExtension.getValue());
            } else {
                outputField.setName("calculatedScore");
            }
            if (classExtension != null) {
                pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().remove(classExtension);
                outputField.getExtensions().add(classExtension);
            }
            output.getOutputFields().add(outputField);
            if (!pmmlScorecard.isUseReasonCodes()) break;
            OutputField reasonCodeField = new OutputField();
            reasonCodeField.setDataType(DATATYPE.STRING);
            reasonCodeField.setFeature(RESULTFEATURE.REASON_CODE);
            reasonCodeField.setDisplayName("Principal Reason Code");
            if (reasonCodeExtension != null) {
                pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().remove(reasonCodeExtension);
                reasonCodeField.getExtensions().add(classExtension);
                reasonCodeField.setName(reasonCodeExtension.getValue());
            } else {
                reasonCodeField.setName("reasonCode");
            }
            output.getOutputFields().add(reasonCodeField);
            break;
        }
    }

    private void createAndSetPredicates(Scorecard pmmlScorecard) {
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                String dataType = ScorecardPMMLUtils.getExtensionValue(characteristic.getExtensions(), "dataType");
                Extension predicateExtension = null;
                for (Attribute attribute : characteristic.getAttributes()) {
                    String predicateAsString = "";
                    String field = ScorecardPMMLUtils.getExtensionValue(attribute.getExtensions(), "field");
                    for (Extension extension : attribute.getExtensions()) {
                        if (!"predicateResolver".equalsIgnoreCase(extension.getName())) continue;
                        predicateAsString = extension.getValue();
                        predicateExtension = extension;
                        break;
                    }
                    this.setPredicatesForAttribute(attribute, dataType, field, predicateAsString);
                    attribute.getExtensions().remove(predicateExtension);
                }
            }
        }
    }

    private void setPredicatesForAttribute(Attribute pmmlAttribute, String dataType, String field, String predicateAsString) {
        predicateAsString = StringUtil.unescapeXML(predicateAsString);
        if ("Number".equalsIgnoreCase(dataType)) {
            this.setNumericPredicate(pmmlAttribute, field, predicateAsString);
        } else if ("Text".equalsIgnoreCase(dataType)) {
            this.setTextPredicate(pmmlAttribute, field, predicateAsString);
        } else if ("Boolean".equalsIgnoreCase(dataType)) {
            this.setBooleanPredicate(pmmlAttribute, field, predicateAsString);
        }
    }

    private void setBooleanPredicate(Attribute pmmlAttribute, String field, String predicateAsString) {
        SimplePredicate simplePredicate = new SimplePredicate();
        simplePredicate.setField(field);
        simplePredicate.setOperator("equal");
        if ("TRUE".equalsIgnoreCase(predicateAsString)) {
            simplePredicate.setValue("TRUE");
        } else if ("FALSE".equalsIgnoreCase(predicateAsString)) {
            simplePredicate.setValue("FALSE");
        }
        pmmlAttribute.setSimplePredicate(simplePredicate);
    }

    private void setTextPredicate(Attribute pmmlAttribute, String field, String predicateAsString) {
        String operator = "";
        if (predicateAsString.startsWith("=")) {
            operator = "=";
            predicateAsString = predicateAsString.substring(1);
        } else if (predicateAsString.startsWith("!=")) {
            operator = "!=";
            predicateAsString = predicateAsString.substring(2);
        }
        if (predicateAsString.contains(",")) {
            SimpleSetPredicate simpleSetPredicate = new SimpleSetPredicate();
            if ("!=".equalsIgnoreCase(operator)) {
                simpleSetPredicate.setBooleanOperator("isNotIn");
            } else {
                simpleSetPredicate.setBooleanOperator("isIn");
            }
            simpleSetPredicate.setField(field);
            predicateAsString = predicateAsString.trim();
            if (predicateAsString.endsWith(",")) {
                predicateAsString = predicateAsString.substring(0, predicateAsString.length() - 1);
            }
            Array array = new Array();
            array.setContent(predicateAsString.replace(",", " "));
            array.setType("string");
            array.setN(BigInteger.valueOf(predicateAsString.split(",").length));
            simpleSetPredicate.setArray(array);
            pmmlAttribute.setSimpleSetPredicate(simpleSetPredicate);
        } else {
            SimplePredicate simplePredicate = new SimplePredicate();
            simplePredicate.setField(field);
            if ("!=".equalsIgnoreCase(operator)) {
                simplePredicate.setOperator("notEqual");
            } else {
                simplePredicate.setOperator("equal");
            }
            simplePredicate.setValue(predicateAsString);
            pmmlAttribute.setSimplePredicate(simplePredicate);
        }
    }

    private void setNumericPredicate(Attribute pmmlAttribute, String field, String predicateAsString) {
        if (predicateAsString.indexOf("-") > 0) {
            CompoundPredicate compoundPredicate = new CompoundPredicate();
            compoundPredicate.setBooleanOperator("and");
            String left = predicateAsString.substring(0, predicateAsString.indexOf("-")).trim();
            String right = predicateAsString.substring(predicateAsString.indexOf("-") + 1).trim();
            SimplePredicate simplePredicate = new SimplePredicate();
            simplePredicate.setField(field);
            simplePredicate.setOperator("greaterOrEqual");
            simplePredicate.setValue(left);
            compoundPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(simplePredicate);
            simplePredicate = new SimplePredicate();
            simplePredicate.setField(field);
            simplePredicate.setOperator("lessThan");
            simplePredicate.setValue(right);
            compoundPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(simplePredicate);
            pmmlAttribute.setCompoundPredicate(compoundPredicate);
        } else {
            SimplePredicate simplePredicate = new SimplePredicate();
            simplePredicate.setField(field);
            if (predicateAsString.startsWith("<=")) {
                simplePredicate.setOperator("lessOrEqual");
                simplePredicate.setValue(predicateAsString.substring(3).trim());
            } else if (predicateAsString.startsWith(">=")) {
                simplePredicate.setOperator("greaterOrEqual");
                simplePredicate.setValue(predicateAsString.substring(3).trim());
            } else if (predicateAsString.startsWith("=")) {
                simplePredicate.setOperator("equal");
                simplePredicate.setValue(predicateAsString.substring(2).trim());
            } else if (predicateAsString.startsWith("!=")) {
                simplePredicate.setOperator("notEqual");
                simplePredicate.setValue(predicateAsString.substring(3).trim());
            } else if (predicateAsString.startsWith("<")) {
                simplePredicate.setOperator("lessThan");
                simplePredicate.setValue(predicateAsString.substring(2).trim());
            } else if (predicateAsString.startsWith(">")) {
                simplePredicate.setOperator("greaterThan");
                simplePredicate.setValue(predicateAsString.substring(2).trim());
            }
            pmmlAttribute.setSimplePredicate(simplePredicate);
        }
    }

    private void removeEmptyExtensions(Scorecard pmmlScorecard) {
        for (Serializable obj : pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            Characteristics characteristics = (Characteristics)obj;
            for (Characteristic characteristic : characteristics.getCharacteristics()) {
                ArrayList<Extension> toRemoveExtensionsList = new ArrayList<Extension>();
                for (Extension extension : characteristic.getExtensions()) {
                    if (!StringUtils.isEmpty((CharSequence)extension.getValue())) continue;
                    toRemoveExtensionsList.add(extension);
                }
                for (Extension extension : toRemoveExtensionsList) {
                    characteristic.getExtensions().remove(extension);
                }
                for (Attribute attribute : characteristic.getAttributes()) {
                    ArrayList<Extension> toRemoveExtensionsList2 = new ArrayList<Extension>();
                    for (Extension extension : attribute.getExtensions()) {
                        if (!StringUtils.isEmpty((CharSequence)extension.getValue())) continue;
                        toRemoveExtensionsList2.add(extension);
                    }
                    for (Extension extension : toRemoveExtensionsList2) {
                        attribute.getExtensions().remove(extension);
                    }
                }
            }
        }
    }
}

