/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.beliefsystem.jtms;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.core.beliefsystem.simple.BeliefSystemLogicalCallback;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;
import org.kie.api.runtime.rule.FactHandle;

public class ReteJTMSBeliefSystem
implements BeliefSystem {
    public static boolean STRICT = false;
    private TruthMaintenanceSystem tms;
    private NamedEntryPoint defEP;
    private NamedEntryPoint negEP;

    public ReteJTMSBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.defEP = ep;
        this.tms = tms;
        this.initMainEntryPoints();
    }

    private void initMainEntryPoints() {
        this.negEP = (NamedEntryPoint)this.defEP.getWorkingMemoryEntryPoint(JTMSBeliefSetImpl.MODE.NEGATIVE.getId());
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        JTMSBeliefSetImpl jtmsBeliefSet = (JTMSBeliefSetImpl)beliefSet;
        boolean wasEmpty = jtmsBeliefSet.isEmpty();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean wasConflicting = jtmsBeliefSet.isUndecided();
        jtmsBeliefSet.add((LinkedListNode)node.getJustifierEntry());
        if (wasEmpty) {
            this.insertBelief(node, typeConf, jtmsBeliefSet, wasNegated, wasConflicting);
        } else if (!wasConflicting && jtmsBeliefSet.isUndecided()) {
            boolean fullyRetract;
            InternalFactHandle fh;
            if (STRICT) {
                throw new IllegalStateException("FATAL : A fact and its negation have been asserted " + jtmsBeliefSet.getFactHandle().getObject());
            }
            if (wasNegated) {
                fh = jtmsBeliefSet.getNegativeFactHandle();
                jtmsBeliefSet.setNegativeFactHandle(null);
                fullyRetract = true;
            } else {
                fh = jtmsBeliefSet.getPositiveFactHandle();
                jtmsBeliefSet.setPositiveFactHandle(null);
                fullyRetract = false;
            }
            this.retractOrUpdateBelief(node, context, fh, false, fullyRetract);
        }
    }

    private void insertBelief(LogicalDependency node, ObjectTypeConf typeConf, JTMSBeliefSetImpl jtmsBeliefSet, boolean wasNegated, boolean wasConflicting) {
        if (jtmsBeliefSet.isNegated()) {
            jtmsBeliefSet.setNegativeFactHandle((InternalFactHandle)this.negEP.insert(node.getObject()));
            jtmsBeliefSet.getNegativeFactHandle().setEqualityKey(jtmsBeliefSet.getFactHandle().getEqualityKey());
            jtmsBeliefSet.setPositiveFactHandle(null);
            if (!wasNegated && !wasConflicting) {
                this.defEP.getObjectStore().removeHandle((FactHandle)jtmsBeliefSet.getFactHandle());
            }
        } else {
            jtmsBeliefSet.setPositiveFactHandle(jtmsBeliefSet.getFactHandle());
            jtmsBeliefSet.setNegativeFactHandle(null);
            if (wasNegated || wasConflicting) {
                jtmsBeliefSet.getFactHandle().setObject(node.getObject());
                this.defEP.getObjectStore().addHandle(jtmsBeliefSet.getPositiveFactHandle(), jtmsBeliefSet.getPositiveFactHandle().getObject());
            }
            this.defEP.insert(jtmsBeliefSet.getPositiveFactHandle(), node.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf, null);
        }
    }

    private void retractOrUpdateBelief(LogicalDependency node, PropagationContext context, InternalFactHandle fh, boolean update, boolean fullyRetract) {
        JTMSBeliefSetImpl jtmsBeliefSet = (JTMSBeliefSetImpl)fh.getEqualityKey().getBeliefSet();
        if (jtmsBeliefSet.getWorkingMemoryAction() == null) {
            BeliefSystemLogicalCallback action = new BeliefSystemLogicalCallback(fh, context, node.getJustifier(), update, fullyRetract);
            ((NamedEntryPoint)fh.getEntryPoint()).enQueueWorkingMemoryAction((WorkingMemoryAction)action);
        } else {
            BeliefSystemLogicalCallback callback = (BeliefSystemLogicalCallback)jtmsBeliefSet.getWorkingMemoryAction();
            callback.setFullyRetract(fullyRetract);
            callback.setUpdate(update);
        }
    }

    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        throw new UnsupportedOperationException("This is not serializable yet");
    }

    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        JTMSBeliefSetImpl jtmsBeliefSet = (JTMSBeliefSetImpl)beliefSet;
        boolean wasConflicting = jtmsBeliefSet.isUndecided();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean primeChanged = false;
        if (jtmsBeliefSet.getPositiveFactHandle() != null && jtmsBeliefSet.getPositiveFactHandle().getObject() == node.getObject() || jtmsBeliefSet.getNegativeFactHandle() != null && jtmsBeliefSet.getNegativeFactHandle().getObject() == node.getObject()) {
            primeChanged = true;
        }
        beliefSet.remove((LinkedListNode)node.getJustifierEntry());
        if (beliefSet.isEmpty()) {
            if (wasNegated) {
                this.defEP.getObjectStore().addHandle(beliefSet.getFactHandle(), beliefSet.getFactHandle().getObject());
                this.retractOrUpdateBelief(node, context, jtmsBeliefSet.getNegativeFactHandle(), false, true);
            }
            if (context.getType() != 1 || context.getFactHandle() != beliefSet.getFactHandle()) {
                this.retractOrUpdateBelief(node, context, jtmsBeliefSet.getFactHandle(), false, true);
            }
        } else if (wasConflicting && !jtmsBeliefSet.isUndecided()) {
            this.insertBelief(node, this.defEP.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.defEP.getEntryPoint(), node.getObject()), jtmsBeliefSet, wasNegated, wasConflicting);
        } else if (primeChanged) {
            InternalFactHandle handle;
            Object object = null;
            if (jtmsBeliefSet.isNegated()) {
                String value = JTMSBeliefSetImpl.MODE.NEGATIVE.getId();
                handle = jtmsBeliefSet.getNegativeFactHandle();
                for (LinkedListEntry entry = (LinkedListEntry)jtmsBeliefSet.getLast(); entry != null; entry = (LinkedListEntry)entry.getPrevious()) {
                    if (!((LogicalDependency)entry.getObject()).getValue().equals(value)) continue;
                    object = ((LogicalDependency)entry.getObject()).getObject();
                    break;
                }
            } else {
                String value = JTMSBeliefSetImpl.MODE.POSITIVE.getId();
                handle = jtmsBeliefSet.getPositiveFactHandle();
                for (LinkedListEntry entry = (LinkedListEntry)jtmsBeliefSet.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                    if (!((LogicalDependency)entry.getObject()).getValue().equals(value)) continue;
                    object = ((LogicalDependency)entry.getObject()).getObject();
                    break;
                }
            }
            ((NamedEntryPoint)handle.getEntryPoint()).getObjectStore().updateHandle(handle, object);
            this.retractOrUpdateBelief(node, context, handle, true, false);
        }
    }

    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new JTMSBeliefSetImpl((BeliefSystem)this, fh);
    }

    public LogicalDependency newLogicalDependency(Activation activation, BeliefSet beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, (Object)beliefSet, object, value);
    }
}

