/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.InputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.compiler.kproject.xml.PomModelGenerator;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.embedder.MavenProjectLoader;

public class MavenPomModelGenerator
implements PomModelGenerator {
    public PomModel parse(String path, InputStream pomStream) {
        PomModel pomModel = new PomModel();
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom(pomStream);
        pomModel.setReleaseId((ReleaseId)new ReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()));
        try {
            MavenProject parentProject = mavenProject.getParent();
            if (parentProject != null) {
                pomModel.setParentReleaseId((ReleaseId)new ReleaseIdImpl(parentProject.getGroupId(), parentProject.getArtifactId(), parentProject.getVersion()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Artifact dep : mavenProject.getArtifacts()) {
            String scope = dep.getScope();
            if ("provided".equals(scope) || "test".equals(scope)) continue;
            pomModel.addDependency((ReleaseId)new ReleaseIdImpl(dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
        }
        return pomModel;
    }
}

