/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsInvoker
extends JAXRSInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsInvoker.class);
    private static final String SUSPENED = "org.apache.camel.component.cxf.jaxrs.suspend";
    private CxfRsConsumer cxfRsConsumer;
    private CxfRsEndpoint endpoint;

    public CxfRsInvoker(CxfRsEndpoint endpoint, CxfRsConsumer consumer) {
        this.endpoint = endpoint;
        this.cxfRsConsumer = consumer;
    }

    protected Object performInvocation(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray) throws Exception {
        Continuation continuation;
        paramArray = this.insertExchange(method, paramArray, cxfExchange);
        OperationResourceInfo ori = (OperationResourceInfo)cxfExchange.get(OperationResourceInfo.class);
        if (ori.isSubResourceLocator()) {
            return method.invoke(serviceObject, paramArray);
        }
        if (!this.endpoint.isSynchronous() && (continuation = this.getContinuation(cxfExchange)) != null) {
            LOG.trace("Calling the Camel async processors.");
            return this.asyncInvoke(cxfExchange, serviceObject, method, paramArray, continuation);
        }
        LOG.trace("Calling the Camel sync processors.");
        return this.syncInvoke(cxfExchange, serviceObject, method, paramArray);
    }

    private Continuation getContinuation(org.apache.cxf.message.Exchange cxfExchange) {
        ContinuationProvider provider = (ContinuationProvider)cxfExchange.getInMessage().get((Object)ContinuationProvider.class.getName());
        return provider == null ? null : provider.getContinuation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object asyncInvoke(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray, final Continuation continuation) throws Exception {
        Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.isNew()) {
                ExchangePattern ep = ExchangePattern.InOut;
                if (method.getReturnType() == Void.class) {
                    ep = ExchangePattern.InOnly;
                }
                final Exchange camelExchange = this.endpoint.createExchange(ep);
                CxfRsBinding binding = this.endpoint.getBinding();
                binding.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
                this.cxfRsConsumer.createUoW(camelExchange);
                LOG.trace("Suspending continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                continuation.suspend(0L);
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.TRUE);
                this.cxfRsConsumer.getAsyncProcessor().process(camelExchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(boolean doneSync) {
                        Continuation continuation2 = continuation;
                        synchronized (continuation2) {
                            LOG.trace("Resuming continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                            continuation.setObject((Object)camelExchange);
                            continuation.resume();
                        }
                    }
                });
                return null;
            }
            if (continuation.isResumed()) {
                Object object;
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.FALSE);
                Exchange camelExchange = (Exchange)continuation.getObject();
                try {
                    object = this.returnResponse(cxfExchange, camelExchange);
                }
                catch (Throwable throwable) {
                    this.cxfRsConsumer.doneUoW(camelExchange);
                    throw throwable;
                }
                this.cxfRsConsumer.doneUoW(camelExchange);
                return object;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncInvoke(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray) throws Exception {
        ExchangePattern ep = ExchangePattern.InOut;
        if (method.getReturnType() == Void.class) {
            ep = ExchangePattern.InOnly;
        }
        Exchange camelExchange = this.endpoint.createExchange(ep);
        CxfRsBinding binding = this.endpoint.getBinding();
        binding.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
        this.cxfRsConsumer.createUoW(camelExchange);
        try {
            this.cxfRsConsumer.getProcessor().process(camelExchange);
        }
        catch (Exception exception) {
            camelExchange.setException((Throwable)exception);
        }
        try {
            Object object = this.returnResponse(cxfExchange, camelExchange);
            return object;
        }
        finally {
            this.cxfRsConsumer.doneUoW(camelExchange);
        }
    }

    private Object returnResponse(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) throws Exception {
        if (camelExchange.getException() != null) {
            Throwable exception = camelExchange.getException();
            Response result = null;
            if (exception instanceof RuntimeCamelException && exception.getCause() != null) {
                exception = exception.getCause();
            }
            if (exception instanceof WebApplicationException) {
                result = ((WebApplicationException)exception).getResponse();
                if (result != null) {
                    return result;
                }
                throw (WebApplicationException)exception;
            }
            WebApplicationException webApplicationException = new WebApplicationException(exception, Response.serverError().entity((Object)exception.toString()).build());
            throw webApplicationException;
        }
        return this.endpoint.getBinding().populateCxfRsResponseFromExchange(camelExchange, cxfExchange);
    }
}

