/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.spring.KieSpringUtils;
import org.kie.spring.factorybeans.KBaseFactoryBean;
import org.kie.spring.factorybeans.KModuleFactoryBean;
import org.kie.spring.factorybeans.KSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="kiePostProcessor")
public class KModuleBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(KModuleBeanFactoryPostProcessor.class);
    private static final String WEB_INF_FOLDER = "WEB-INF" + File.separator + "classes" + File.separator;
    protected URL configFileURL;
    protected ReleaseId releaseId;
    private String configFilePath;
    private ApplicationContext context;

    public KModuleBeanFactoryPostProcessor() {
        this.initConfigFilePath();
    }

    public KModuleBeanFactoryPostProcessor(URL configFileURL, String configFilePath, ApplicationContext context) {
        this.configFileURL = configFileURL;
        this.configFilePath = configFilePath;
        this.context = context;
    }

    public KModuleBeanFactoryPostProcessor(URL configFileURL, String configFilePath) {
        this.configFileURL = configFileURL;
        this.configFilePath = configFilePath;
    }

    protected void initConfigFilePath() {
        try {
            this.configFilePath = this.getClass().getResource("/").toURI().getPath();
        }
        catch (URISyntaxException e) {
            this.configFilePath = this.getClass().getResource("/").getPath();
        }
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        log.info(":: BeanFactoryPostProcessor::postProcessBeanFactory called ::");
        if (this.releaseId == null && this.configFilePath != null) {
            this.fixConfigFilePathForVfs();
            String pomProperties = null;
            if (this.configFilePath.endsWith(WEB_INF_FOLDER)) {
                String configFilePathForWebApps = this.configFilePath.substring(0, this.configFilePath.indexOf(WEB_INF_FOLDER));
                pomProperties = ClasspathKieProject.getPomProperties((String)configFilePathForWebApps);
            }
            if (pomProperties == null) {
                pomProperties = ClasspathKieProject.getPomProperties((String)this.configFilePath);
            }
            this.releaseId = pomProperties != null ? ReleaseIdImpl.fromPropertiesString((String)pomProperties) : new ReleaseIdImpl("org.default", "artifact", "1.0.0-SNAPSHOT");
            log.info("Found project with releaseId: " + this.releaseId);
            KieSpringUtils.setDefaultReleaseId(this.releaseId);
        }
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equalsIgnoreCase(KModuleFactoryBean.class.getName())) continue;
            KieModuleModel kieModuleModel = this.fetchKieModuleModel(beanFactory);
            this.addKieModuleToRepo(kieModuleModel);
        }
    }

    private void fixConfigFilePathForVfs() {
        File mavenFolder;
        String contextPath;
        File contextFile;
        if (this.configFileURL != null && this.configFileURL.toExternalForm().startsWith("vfs:") && (contextFile = new File(contextPath = ClasspathKieProject.fixURLFromKProjectPath((URL)this.configFileURL))).exists() && (mavenFolder = this.recurseToMavenFolder(contextFile = contextFile.getParentFile().getParentFile())) != null) {
            this.configFilePath = mavenFolder.getParentFile().getParent();
        }
    }

    private File recurseToMavenFolder(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (!child.isDirectory()) continue;
                if (child.getName().endsWith("maven")) {
                    return child;
                }
                File returnedFile = this.recurseToMavenFolder(child);
                if (returnedFile == null) continue;
                return returnedFile;
            }
        }
        return null;
    }

    private void addKieModuleToRepo(KieModuleModel kieProject) {
        KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieProject);
        InternalKieModule kJar = this.createKieModule(kieProject);
        if (kJar != null) {
            KieServices ks = KieServices.Factory.get();
            log.info("adding KieModule from " + this.configFileURL.toExternalForm() + " to repository.");
            ks.getRepository().addKieModule((KieModule)kJar);
            if (this.context != null) {
                KieSpringUtils.setReleaseIdForContext(this.releaseId, this.context);
                KieSpringUtils.setDefaultReleaseId(this.releaseId);
            }
        }
    }

    protected InternalKieModule createKieModule(KieModuleModel kieProject) {
        String rootPath;
        if (this.configFileURL.toString().startsWith("bundle:")) {
            return this.createOsgiKModule(kieProject);
        }
        if (this.configFilePath == null) {
            this.configFilePath = this.getClass().getResource("/").getPath();
        }
        if ((rootPath = this.configFilePath).lastIndexOf(58) > 0) {
            rootPath = this.configFilePath.substring(rootPath.lastIndexOf(58) + 1);
        }
        return ClasspathKieProject.createInternalKieModule((URL)this.configFileURL, (String)this.configFilePath, (KieModuleModel)kieProject, (ReleaseId)this.releaseId, (String)rootPath);
    }

    private InternalKieModule createOsgiKModule(KieModuleModel kieProject) {
        Method m;
        try {
            Class<?> c = Class.forName("org.drools.osgi.compiler.OsgiKieModule", true, KieBuilderImpl.class.getClassLoader());
            m = c.getMethod("create", URL.class, ReleaseId.class, KieModuleModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException("It is necessary to have the drools-osgi-integration module on the path in order to create a KieProject from an ogsi bundle", e);
        }
        try {
            return (InternalKieModule)m.invoke(null, this.configFileURL, this.releaseId, kieProject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure creating a OsgiKieModule caused by: " + e.getMessage(), e);
        }
    }

    private KieModuleModel fetchKieModuleModel(ConfigurableListableBeanFactory beanFactory) {
        KieModuleModelImpl kieModuleModel = new KieModuleModelImpl();
        this.addKieBaseModels(beanFactory, kieModuleModel);
        return kieModuleModel;
    }

    private void addKieBaseModels(ConfigurableListableBeanFactory beanFactory, KieModuleModelImpl kieModuleModel) {
        BeanExpressionContext context = new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null);
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            String scope;
            String declarativeAgenda;
            String equalsBehavior;
            String eventMode;
            String includes;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equalsIgnoreCase(KBaseFactoryBean.class.getName())) continue;
            KieBaseModelImpl kBase = new KieBaseModelImpl();
            kBase.setKModule((KieModuleModel)kieModuleModel);
            kBase.setName(this.getPropertyValue(beanDefinition, "kBaseName"));
            kBase.setDefault("true".equals(this.getPropertyValue(beanDefinition, "def")));
            String packages = this.getPropertyValue(beanDefinition, "packages");
            if (!packages.isEmpty()) {
                packages = this.checkAndResolveSpringExpression(beanFactory, context, packages);
                for (String pkg : packages.split(",")) {
                    kBase.addPackage(pkg.trim());
                }
            }
            if (!(includes = this.getPropertyValue(beanDefinition, "includes")).isEmpty()) {
                includes = this.checkAndResolveSpringExpression(beanFactory, context, includes);
                for (String include : includes.split(",")) {
                    kBase.addInclude(include.trim());
                }
            }
            if (!(eventMode = this.getPropertyValue(beanDefinition, "eventProcessingMode")).isEmpty()) {
                eventMode = this.checkAndResolveSpringExpression(beanFactory, context, eventMode);
                kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventMode));
            }
            if (!(equalsBehavior = this.getPropertyValue(beanDefinition, "equalsBehavior")).isEmpty()) {
                equalsBehavior = this.checkAndResolveSpringExpression(beanFactory, context, equalsBehavior);
                kBase.setEqualsBehavior(EqualityBehaviorOption.determineEqualityBehavior((String)equalsBehavior));
            }
            if (!(declarativeAgenda = this.getPropertyValue(beanDefinition, "declarativeAgenda")).isEmpty()) {
                declarativeAgenda = this.checkAndResolveSpringExpression(beanFactory, context, declarativeAgenda);
                kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgenda((String)declarativeAgenda));
            }
            if (!(scope = this.getPropertyValue(beanDefinition, "scope")).isEmpty()) {
                scope = this.checkAndResolveSpringExpression(beanFactory, context, scope);
                kBase.setScope(scope.trim());
            }
            kieModuleModel.getRawKieBaseModels().put(kBase.getName(), kBase);
            beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue("releaseId", (Object)this.releaseId));
            this.addKieSessionModels(beanFactory, kBase);
        }
    }

    protected String checkAndResolveSpringExpression(ConfigurableListableBeanFactory beanFactory, BeanExpressionContext context, String expression) {
        if (expression.startsWith("#{") && expression.endsWith("}")) {
            return (String)beanFactory.getBeanExpressionResolver().evaluate(expression, context);
        }
        return expression;
    }

    private String getPropertyValue(BeanDefinition beanDefinition, String propertyName) {
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue(propertyName);
        return propertyValue != null ? (String)propertyValue.getValue() : "";
    }

    private void addKieSessionModels(ConfigurableListableBeanFactory beanFactory, KieBaseModelImpl kBase) {
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            String scope;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equalsIgnoreCase(KSessionFactoryBean.class.getName())) continue;
            String kBaseName = this.getPropertyValue(beanDefinition, "kBaseName");
            if (!kBase.getName().equalsIgnoreCase(kBaseName)) continue;
            String name = this.getPropertyValue(beanDefinition, "name");
            String type = this.getPropertyValue(beanDefinition, "type");
            KieSessionModelImpl kSession = new KieSessionModelImpl(kBase, name);
            kSession.setType(!type.isEmpty() ? KieSessionModel.KieSessionType.valueOf((String)type.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
            Map rawKieSessionModels = kBase.getRawKieSessionModels();
            rawKieSessionModels.put(kSession.getName(), kSession);
            beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue("releaseId", (Object)this.releaseId));
            kSession.setDefault("true".equals(this.getPropertyValue(beanDefinition, "def")));
            String clockType = this.getPropertyValue(beanDefinition, "clockType");
            if (!clockType.isEmpty()) {
                kSession.setClockType(ClockTypeOption.get((String)clockType));
            }
            if ((scope = this.getPropertyValue(beanDefinition, "scope")).isEmpty()) continue;
            kSession.setScope(scope.trim());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.configFileURL = applicationContext.getResource("classpath:/").getURL();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.configFileURL.toString().endsWith("service-loader-resources/")) {
            try {
                Enumeration<URL> urls = this.getClass().getClassLoader().getResources("/");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!url.toString().endsWith("WEB-INF/classes/")) continue;
                    this.configFileURL = url;
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("classpath root URL: " + this.configFileURL);
    }
}

