/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.io.Externalizable;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.PointInTimeTrigger;

public class ReteSlidingTimeWindow
extends SlidingTimeWindow
implements Externalizable,
Behavior {
    private static final ReteBehaviorJob reteJob = new ReteBehaviorJob();

    public ReteSlidingTimeWindow() {
        this(0L);
    }

    public ReteSlidingTimeWindow(long size) {
        super(size);
    }

    protected void updateNextExpiration(InternalFactHandle fact, PropagationContext pctx, InternalWorkingMemory workingMemory, Object context, int nodeId) {
        TimerService clock = workingMemory.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((EventFactHandle)fact).getStartTimestamp() + this.getSize();
            if (nextTimestamp < clock.getCurrentTime()) {
                workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new SlidingTimeWindow.BehaviorExpireWMAction(nodeId, (Behavior)this, context, pctx));
            } else {
                SlidingTimeWindow.BehaviorJobContext jobctx = new SlidingTimeWindow.BehaviorJobContext(nodeId, workingMemory, (Behavior)this, context, pctx);
                JobHandle handle = clock.scheduleJob((Job)reteJob, (JobContext)jobctx, (Trigger)new PointInTimeTrigger(nextTimestamp, null, null));
                jobctx.setJobHandle(handle);
            }
        }
    }

    public static class ReteBehaviorJob
    implements Job {
        public void execute(JobContext ctx) {
            SlidingTimeWindow.BehaviorJobContext context = (SlidingTimeWindow.BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new SlidingTimeWindow.BehaviorExpireWMAction(context.nodeId, context.behavior, context.behaviorContext, context.pctx));
        }
    }
}

