/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.spring.KieObjectsResolver;
import org.kie.spring.annotations.AnnotationsUtil;
import org.kie.spring.factorybeans.KBaseFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KieImportFactoryBean
implements FactoryBean<KieContainer>,
InitializingBean,
BeanFactoryPostProcessor,
ApplicationContextAware {
    protected ReleaseId releaseId;
    protected KieContainer kContainer;
    protected ApplicationContext applicationContext;
    protected KieObjectsResolver kieObjectsResolver;
    protected boolean scannerEnabled = false;
    protected int scannerInterval = 1000;
    protected KieScanner kieScanner;
    protected String releaseIdName;

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public boolean isScannerEnabled() {
        return this.scannerEnabled;
    }

    public void setScannerEnabled(boolean scannerEnabled) {
        this.scannerEnabled = scannerEnabled;
    }

    public int getScannerInterval() {
        return this.scannerInterval;
    }

    public String getReleaseIdName() {
        return this.releaseIdName;
    }

    public void setReleaseIdName(String releaseIdName) {
        this.releaseIdName = releaseIdName;
    }

    public void setScannerInterval(int scannerInterval) {
        this.scannerInterval = scannerInterval;
    }

    public KieContainer getObject() throws Exception {
        return this.kContainer;
    }

    public Class<? extends KieContainer> getObjectType() {
        return KieContainer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.kieObjectsResolver = new KieObjectsResolver();
        this.setKContainer();
        this.registerKieBases(beanFactory);
        AnnotationsUtil.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory, this.releaseId);
    }

    protected void setKContainer() {
        if (this.releaseId != null) {
            this.kContainer = KieServices.Factory.get().newKieContainer(this.releaseId);
            if (this.scannerEnabled) {
                this.kieScanner = KieServices.Factory.get().newKieScanner(this.kContainer);
                this.kieScanner.start((long)this.scannerInterval);
            }
        } else {
            this.kContainer = KieServices.Factory.get().getKieClasspathContainer();
        }
    }

    protected void registerKieBases(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        for (String kieBaseName : this.kContainer.getKieBaseNames()) {
            if (this.scannerEnabled) {
                this.registerKieBeanDef((BeanDefinitionRegistry)configurableListableBeanFactory, kieBaseName);
                configurableListableBeanFactory.registerSingleton(this.releaseIdName + "#scanner", (Object)this.kieScanner);
            } else {
                KieBase kieBase = this.kContainer.getKieBase(kieBaseName);
                configurableListableBeanFactory.registerSingleton(kieBaseName, (Object)kieBase);
            }
            this.registerKieSessions(kieBaseName, configurableListableBeanFactory);
        }
    }

    private void registerKieBeanDef(BeanDefinitionRegistry beanDefinitionRegistry, String kieBaseName) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(KBaseFactoryBean.class);
        factory.addPropertyValue("kBaseName", (Object)kieBaseName);
        factory.addPropertyValue("id", (Object)kieBaseName);
        factory.addPropertyValue("singleton", (Object)false);
        factory.addPropertyValue("kieContainer", (Object)this.kContainer);
        beanDefinitionRegistry.registerBeanDefinition(kieBaseName, (BeanDefinition)factory.getBeanDefinition());
    }

    protected void registerKieSessions(String kieBaseName, ConfigurableListableBeanFactory configurableListableBeanFactory) {
        for (String kieSessionName : this.kContainer.getKieSessionNamesInKieBase(kieBaseName)) {
            Object ksession = this.kieObjectsResolver.resolveKSession(this.kContainer, kieSessionName);
            configurableListableBeanFactory.registerSingleton(kieSessionName, ksession);
        }
    }
}

