/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.parser.xls;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.util.CellReference;
import org.dmg.pmml.pmml_4_2.descr.Attribute;
import org.dmg.pmml.pmml_4_2.descr.Characteristic;
import org.dmg.pmml.pmml_4_2.descr.Characteristics;
import org.dmg.pmml.pmml_4_2.descr.Extension;
import org.dmg.pmml.pmml_4_2.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_2.descr.INVALIDVALUETREATMENTMETHOD;
import org.dmg.pmml.pmml_4_2.descr.MiningField;
import org.dmg.pmml.pmml_4_2.descr.MiningSchema;
import org.dmg.pmml.pmml_4_2.descr.Output;
import org.dmg.pmml.pmml_4_2.descr.Scorecard;
import org.drools.core.util.StringUtils;
import org.drools.scorecards.ScorecardError;
import org.drools.scorecards.parser.ScorecardParseException;
import org.drools.scorecards.parser.xls.ExcelScorecardValidator;
import org.drools.scorecards.parser.xls.MergedCellRange;
import org.drools.scorecards.parser.xls.XLSScorecardParser;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;

class XLSEventDataCollector {
    private List<DataExpectation> expectations = new ArrayList<DataExpectation>();
    private List<MergedCellRange> cellRangeList;
    private Scorecard scorecard;
    private Characteristics characteristics;
    private Characteristic _characteristic;
    private Output output;
    private List<ScorecardError> parseErrors = new ArrayList<ScorecardError>();
    private MiningSchema miningSchema;
    private XLSScorecardParser xlsScorecardParser;

    public Scorecard getScorecard() {
        return this.scorecard;
    }

    private void fulfillExpectation(int currentRowCtr, int currentColCtr, Object cellValue, Class expectedClass) throws ScorecardParseException {
        List<DataExpectation> dataExpectations = this.resolveExpectations(currentRowCtr, currentColCtr);
        CellReference cellRef = new CellReference(currentRowCtr, currentColCtr);
        Method method = null;
        for (DataExpectation dataExpectation : dataExpectations) {
            try {
                if (dataExpectation == null || dataExpectation.object == null) continue;
                if ((cellValue == null || StringUtils.isEmpty((CharSequence)cellValue.toString())) && dataExpectation.errorMessage != null && !StringUtils.isEmpty((CharSequence)dataExpectation.errorMessage)) {
                    this.parseErrors.add(new ScorecardError(cellRef.formatAsString(), dataExpectation.errorMessage));
                    return;
                }
                String setter = "set" + Character.toUpperCase(dataExpectation.property.charAt(0)) + dataExpectation.property.substring(1);
                method = this.getSuitableMethod(cellValue, expectedClass, dataExpectation, setter);
                if (method == null) {
                    if (cellValue != null && !StringUtils.isEmpty((CharSequence)cellValue.toString())) {
                        this.parseErrors.add(new ScorecardError(cellRef.formatAsString(), "Unexpected Value! Wrong Datatype?"));
                    }
                    return;
                }
                if (method.getParameterTypes()[0] == Double.class) {
                    cellValue = Double.parseDouble(cellValue.toString());
                }
                if (method.getParameterTypes()[0] == Boolean.class) {
                    cellValue = Boolean.valueOf(cellValue.toString());
                }
                if (method.getParameterTypes()[0] == String.class && !(cellValue instanceof String) && cellValue != null) {
                    cellValue = cellValue.toString();
                }
                method.invoke(dataExpectation.object, cellValue);
                if (!(dataExpectation.object instanceof Extension) || !"cellRef".equals(((Extension)dataExpectation.object).getName())) continue;
                ((Extension)dataExpectation.object).setValue(cellRef.formatAsString());
            }
            catch (Exception e) {
                throw new ScorecardParseException(e);
            }
        }
    }

    private Method getSuitableMethod(Object cellValue, Class expectedClass, DataExpectation dataExpectation, String setter) {
        try {
            Method method = dataExpectation.object.getClass().getMethod(setter, expectedClass);
            return method;
        }
        catch (NoSuchMethodException e) {
            if (expectedClass == Integer.TYPE) {
                try {
                    Method method = dataExpectation.object.getClass().getMethod(setter, Double.class);
                    return method;
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
            }
            if (expectedClass != String.class) {
                try {
                    Method method = dataExpectation.object.getClass().getMethod(setter, String.class);
                    return method;
                }
                catch (NoSuchMethodException e1) {
                    return null;
                }
            }
            if ("TRUE".equalsIgnoreCase(cellValue.toString()) || "FALSE".equalsIgnoreCase(cellValue.toString())) {
                try {
                    Method method = dataExpectation.object.getClass().getMethod(setter, Boolean.class);
                    return method;
                }
                catch (NoSuchMethodException e1) {
                    return null;
                }
            }
            return null;
        }
    }

    private void setAdditionalExpectation(int currentRowCtr, int currentColCtr, String stringCellValue) {
        if ("Scorecard Name".equalsIgnoreCase(stringCellValue)) {
            this.addExpectation(currentRowCtr, currentColCtr + 1, "modelName", this.scorecard, "Model Name is missing!");
        } else if ("Scoring Strategy".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("scoringStrategy");
            this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
            this.addExpectation(currentRowCtr, currentColCtr + 1, "value", extension, null);
        } else if ("Reason Code Algorithm".equalsIgnoreCase(stringCellValue)) {
            this.addExpectation(currentRowCtr, currentColCtr + 1, "reasonCodeAlgorithm", this.scorecard, null);
        } else if ("Use Reason Codes".equalsIgnoreCase(stringCellValue)) {
            this.addExpectation(currentRowCtr, currentColCtr + 1, "useReasonCodes", this.scorecard, null);
        } else if ("Resultant Score Class".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("externalClass");
            this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
            this.addExpectation(currentRowCtr, currentColCtr + 1, "value", extension, null);
        } else if ("Resultant Score Field".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("final");
            this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
            this.addExpectation(currentRowCtr, currentColCtr + 1, "value", extension, null);
        } else if ("Resultant Reasoncodes Field".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("reasonCodeField");
            this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
            this.addExpectation(currentRowCtr, currentColCtr + 1, "value", extension, null);
        } else if ("Initial Score".equalsIgnoreCase(stringCellValue)) {
            this.addExpectation(currentRowCtr, currentColCtr + 1, "initialScore", this.scorecard, null);
        } else if ("imports".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("importsFromDelimitedString");
            this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
            this.addExpectation(currentRowCtr, currentColCtr + 1, "value", extension, null);
        } else if ("package".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("modelPackage");
            this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
            this.addExpectation(currentRowCtr, currentColCtr + 1, "value", extension, "Scorecard Package is missing");
        } else if ("Name".equalsIgnoreCase(stringCellValue)) {
            this._characteristic = new Characteristic();
            this.characteristics.getCharacteristics().add(this._characteristic);
            this.addExpectation(currentRowCtr + 1, currentColCtr, "name", this._characteristic, "Characteristic (Property) Display Name is missing.");
            Extension extension = new Extension();
            extension.setName("cellRef");
            this.addExpectation(currentRowCtr + 1, currentColCtr, "value", extension, null);
            this._characteristic.getExtensions().add(extension);
        } else if ("Full Class Name".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("externalClass");
            this.addExpectation(currentRowCtr + 1, currentColCtr, "value", extension, null);
            this._characteristic.getExtensions().add(extension);
        } else if ("Data Type".equalsIgnoreCase(stringCellValue)) {
            Extension extension = new Extension();
            extension.setName("dataType");
            this._characteristic.getExtensions().add(extension);
            this.addExpectation(currentRowCtr + 1, currentColCtr, "value", extension, "Characteristic (Property) Data Type is missing.");
        } else if ("Baseline Score".equalsIgnoreCase(stringCellValue)) {
            String value = this.xlsScorecardParser.peekValueAt(currentRowCtr, currentColCtr - 2);
            if ("Name".equalsIgnoreCase(value)) {
                this.addExpectation(currentRowCtr + 1, currentColCtr, "baselineScore", this._characteristic, null);
            } else {
                this.addExpectation(currentRowCtr, currentColCtr + 1, "baselineScore", this.scorecard, null);
            }
        } else if ("Reason Code".equalsIgnoreCase(stringCellValue)) {
            String value = this.xlsScorecardParser.peekValueAt(currentRowCtr, currentColCtr - 4);
            if ("Name".equalsIgnoreCase(value)) {
                this.addExpectation(currentRowCtr + 1, currentColCtr, "reasonCode", this._characteristic, null);
            }
        } else if ("Characteristic".equalsIgnoreCase(stringCellValue)) {
            MergedCellRange cellRange = this.getMergedRegionForCell(currentRowCtr + 1, currentColCtr);
            if (cellRange != null) {
                int indexOfPartialScore = this.indexOfColumn(cellRange, "Partial Score");
                int indexOfDescription = this.indexOfColumn(cellRange, "Description");
                int indexOfReasonCodes = this.indexOfColumn(cellRange, "Reason Code");
                int indexOfValue = this.indexOfColumn(cellRange, "Value");
                int indexOfWeight = this.indexOfColumn(cellRange, "Weight");
                for (int r = cellRange.getFirstRow(); r <= cellRange.getLastRow(); ++r) {
                    Extension extension;
                    Attribute attribute = new Attribute();
                    this._characteristic.getAttributes().add(attribute);
                    if (indexOfPartialScore != -1) {
                        this.addExpectation(r, currentColCtr + indexOfPartialScore, "partialScore", attribute, "Characteristic (Property) Partial Score is missing.");
                    }
                    if (indexOfDescription != -1) {
                        extension = new Extension();
                        extension.setName("description");
                        attribute.getExtensions().add(extension);
                        this.addExpectation(r, currentColCtr + indexOfDescription, "value", extension, null);
                    }
                    if (indexOfValue != -1) {
                        extension = new Extension();
                        extension.setName("field");
                        attribute.getExtensions().add(extension);
                        this.addExpectation(currentRowCtr + indexOfValue, currentColCtr, "value", extension, "Characteristic (Property) Name is missing.");
                        extension = new Extension();
                        extension.setName("predicateResolver");
                        attribute.getExtensions().add(extension);
                        this.addExpectation(r, currentColCtr + indexOfValue, "value", extension, "Characteristic (Property) Value is missing.");
                        extension = new Extension();
                        extension.setName("cellRef");
                        attribute.getExtensions().add(extension);
                        this.addExpectation(r, currentColCtr + indexOfValue, "value", extension, null);
                    }
                    if (indexOfReasonCodes != -1) {
                        this.addExpectation(r, currentColCtr + indexOfReasonCodes, "reasonCode", attribute, null);
                    }
                    if (indexOfWeight == -1) continue;
                    extension = new Extension();
                    extension.setName("weight");
                    attribute.getExtensions().add(extension);
                    extension.setValue("1");
                    this.addExpectation(r, currentColCtr + indexOfWeight, "value", extension, "Characteristic (Weight) Value is missing.");
                }
                MiningField miningField = new MiningField();
                miningField.setInvalidValueTreatment(INVALIDVALUETREATMENTMETHOD.AS_MISSING);
                miningField.setUsageType(FIELDUSAGETYPE.ACTIVE);
                this.miningSchema.getMiningFields().add(miningField);
                this.addExpectation(currentRowCtr + 1, currentColCtr, "name", miningField, null);
            }
        } else if ("Partial Score".equalsIgnoreCase(stringCellValue) || "Value".equalsIgnoreCase(stringCellValue) || "Description".equalsIgnoreCase(stringCellValue)) {
            // empty if block
        }
    }

    private int indexOfColumn(MergedCellRange mergedCellRange, String columnHeading) {
        int row = mergedCellRange.getFirstRow() - 1;
        for (int i = 0; i < 10; ++i) {
            try {
                String peekValue = this.xlsScorecardParser.peekValueAt(row, i);
                if (!columnHeading.equalsIgnoreCase(peekValue)) continue;
                return i - mergedCellRange.getFirstCol();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        return -1;
    }

    private void addExpectation(int row, int column, String property, Object ref, String errorMessage) {
        this.expectations.add(new DataExpectation(row, column, ref, property, errorMessage));
    }

    private List<DataExpectation> resolveExpectations(int row, int col) {
        ArrayList<DataExpectation> dataExpectations = new ArrayList<DataExpectation>();
        for (DataExpectation dataExpectation : this.expectations) {
            if (dataExpectation.row != row || dataExpectation.col != col) continue;
            dataExpectations.add(dataExpectation);
        }
        return dataExpectations;
    }

    public void newCell(int currentRowCtr, int currentColCtr, String stringCellValue) throws ScorecardParseException {
        this.setAdditionalExpectation(currentRowCtr, currentColCtr, stringCellValue);
        this.fulfillExpectation(currentRowCtr, currentColCtr, stringCellValue, String.class);
    }

    public void newCell(int currentRowCtr, int currentColCtr, double numericCellValue) throws ScorecardParseException {
        this.fulfillExpectation(currentRowCtr, currentColCtr, numericCellValue, Double.class);
    }

    public void newCell(int currentRowCtr, int currentColCtr, boolean booleanCellValue) throws ScorecardParseException {
        this.fulfillExpectation(currentRowCtr, currentColCtr, booleanCellValue, Boolean.TYPE);
    }

    public void newCell(int currentRowCtr, int currentColCtr, Date dateCellValue) throws ScorecardParseException {
        this.fulfillExpectation(currentRowCtr, currentColCtr, dateCellValue, Date.class);
    }

    public void sheetComplete() {
        ExcelScorecardValidator.runAdditionalValidations(this.scorecard, this.parseErrors);
    }

    public void newRow(int rowNum) {
    }

    public void sheetStart(String worksheetName) {
        this.expectations.clear();
        this.cellRangeList = null;
        this._characteristic = null;
        this.scorecard = ScorecardPMMLUtils.createScorecard();
        this.output = new Output();
        this.characteristics = new Characteristics();
        this.miningSchema = new MiningSchema();
        this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(this.miningSchema);
        this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(this.output);
        this.scorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(this.characteristics);
    }

    public void setMergedRegionsInSheet(List<MergedCellRange> cellRangeList) {
        this.cellRangeList = cellRangeList;
    }

    private MergedCellRange getMergedRegionForCell(int rowInd, int colInd) {
        for (MergedCellRange cellRange : this.cellRangeList) {
            if (cellRange.getFirstRow() > rowInd || rowInd > cellRange.getLastRow() || cellRange.getFirstCol() > colInd || colInd > cellRange.getLastCol()) continue;
            return cellRange;
        }
        return null;
    }

    public List<ScorecardError> getParseErrors() {
        return this.parseErrors;
    }

    public void setParser(XLSScorecardParser xlsScorecardParser) {
        this.xlsScorecardParser = xlsScorecardParser;
    }

    class DataExpectation {
        int row;
        int col;
        Object object;
        String property;
        String errorMessage;

        DataExpectation(int row, int col, Object object, String property, String errorMessage) {
            this.row = row;
            this.col = col;
            this.object = object;
            this.property = property;
            this.errorMessage = errorMessage;
        }
    }
}

