/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.LeftTupleSetsImpl;
import org.drools.core.common.Memory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.PhreakAccumulateNode;
import org.drools.core.phreak.PhreakBranchNode;
import org.drools.core.phreak.PhreakEvalNode;
import org.drools.core.phreak.PhreakExistsNode;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.PhreakQueryNode;
import org.drools.core.phreak.PhreakQueryTerminalNode;
import org.drools.core.phreak.PhreakReactiveFromNode;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SegmentPropagator;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluator.class);
    private static final PhreakJoinNode pJoinNode = new PhreakJoinNode();
    private static final PhreakEvalNode pEvalNode = new PhreakEvalNode();
    private static final PhreakFromNode pFromNode = new PhreakFromNode();
    private static final PhreakReactiveFromNode pReactiveFromNode = new PhreakReactiveFromNode();
    private static final PhreakNotNode pNotNode = new PhreakNotNode();
    private static final PhreakExistsNode pExistsNode = new PhreakExistsNode();
    private static final PhreakAccumulateNode pAccNode = new PhreakAccumulateNode();
    private static final PhreakBranchNode pBranchNode = new PhreakBranchNode();
    private static final PhreakQueryNode pQueryNode = new PhreakQueryNode();
    private static final PhreakTimerNode pTimerNode = new PhreakTimerNode();
    private static final PhreakRuleTerminalNode pRtNode = new PhreakRuleTerminalNode();
    private static int cycle = 0;
    private static PhreakQueryTerminalNode pQtNode = new PhreakQueryTerminalNode();

    public void evaluateNetwork(PathMemory pmem, LinkedList<StackEntry> outerStack, RuleExecutor executor, InternalWorkingMemory wm) {
        Memory nodeMem;
        NetworkNode node;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        int smemIndex = 0;
        SegmentMemory smem = smems[smemIndex];
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        Set<String> visitedRules = pmem.getNetworkNode().getType() == 91 ? new HashSet() : Collections.emptySet();
        LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
        long bit = 1L;
        if (liaNode == smem.getTipNode()) {
            smem = smems[++smemIndex];
            node = smem.getRootNode();
            nodeMem = smem.getNodeMemories().getFirst();
        } else {
            bit = 2L;
            node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
            nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
        }
        LeftTupleSets srcTuples = smem.getStagedLeftTuples();
        if (log.isTraceEnabled()) {
            log.trace("Rule[name={}] segments={} {}", new Object[]{((TerminalNode)pmem.getNetworkNode()).getRule().getName(), smems.length, srcTuples.toStringSizes()});
        }
        this.outerEval(liaNode, pmem, node, bit, nodeMem, smems, smemIndex, srcTuples, wm, stack, outerStack, visitedRules, true, executor);
    }

    public static String indent(int size) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sbuilder.append("  ");
        }
        return sbuilder.toString();
    }

    public static int getOffset(NetworkNode node) {
        LeftTupleSource lt;
        int offset = 1;
        if (NodeTypeEnums.isTerminalNode(node)) {
            lt = ((TerminalNode)node).getLeftTupleSource();
            ++offset;
        } else {
            lt = node.getType() == 71 ? ((RightInputAdapterNode)node).getLeftTupleSource() : (LeftTupleSource)node;
        }
        while (lt.getType() != 120) {
            ++offset;
            lt = lt.getLeftTupleSource();
        }
        return offset;
    }

    public void outerEval(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, boolean processRian, RuleExecutor executor) {
        this.innerEval(liaNode, pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, wm, stack, outerStack, visitedRules, processRian, executor);
        while (!stack.isEmpty()) {
            StackEntry entry = stack.removeLast();
            this.evalStackEntry(entry, stack, outerStack, executor, wm);
        }
    }

    public void evalStackEntry(StackEntry entry, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, RuleExecutor executor, InternalWorkingMemory wm) {
        NetworkNode node = entry.getNode();
        Memory nodeMem = entry.getNodeMem();
        LeftTupleSets trgTuples = entry.getTrgTuples();
        if (node.getType() == 165) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
            qmem.setNodeCleanWithoutNotify();
            trgTuples.addAll(qmem.getResultLeftTuples());
        }
        LeftTupleSinkNode sink = entry.getSink();
        PathMemory pmem = entry.getRmem();
        SegmentMemory[] smems = entry.getSmems();
        int smemIndex = entry.getSmemIndex();
        Set<String> visitedRules = entry.getVisitedRules();
        boolean processRian = entry.isProcessRian();
        long bit = entry.getBit();
        if (entry.isResumeFromNextNode()) {
            SegmentMemory smem = smems[smemIndex];
            if (node != smem.getTipNode()) {
                LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                node = nextSink == null ? sink : nextSink;
                nodeMem = (Memory)nodeMem.getNext();
                bit <<= 1;
            } else {
                SegmentPropagator.propagate(smem, trgTuples, wm);
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples().takeAll();
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
                bit = 1L;
            }
        }
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} Resume {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), node.toString(), trgTuples.toStringSizes()});
        }
        this.innerEval(entry.getLiaNode(), pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, wm, stack, outerStack, visitedRules, processRian, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void innerEval(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, boolean processRian, RuleExecutor executor) {
        SegmentMemory smem = smems[smemIndex];
        LeftTupleSets stagedLeftTuples = null;
        while (true) {
            boolean exitInnerEval2;
            LeftTupleSets srcTuples = trgTuples;
            if (log.isTraceEnabled()) {
                int offset = RuleNetworkEvaluator.getOffset(node);
                log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), ++cycle, node.toString(), srcTuples.toStringSizes()});
            }
            boolean emptySrcTuples = srcTuples.isEmpty();
            if (!NodeTypeEnums.isBetaNode(node) || !((BetaNode)node).isRightInputIsRiaNode()) {
                if (emptySrcTuples && smem.getDirtyNodeMask() == 0L) {
                    boolean foundDirty = false;
                    int length = smems.length;
                    for (int i = ++smemIndex; i < length; ++i) {
                        if (log.isTraceEnabled()) {
                            int offset = RuleNetworkEvaluator.getOffset(node);
                            log.trace("{} Skip Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)(i - 1));
                        }
                        if (smem.isEmpty() && !NodeTypeEnums.isTerminalNode(smem.getTipNode())) {
                            SegmentUtilities.createChildSegments(wm, smem, ((LeftTupleSource)smem.getTipNode()).getSinkPropagator());
                        }
                        smem = smems[i];
                        bit = 1L;
                        srcTuples = smem.getStagedLeftTuples().takeAll();
                        emptySrcTuples = srcTuples.isEmpty();
                        node = smem.getRootNode();
                        nodeMem = smem.getNodeMemories().getFirst();
                        if (emptySrcTuples && smem.getDirtyNodeMask() == 0L && (!NodeTypeEnums.isBetaNode(node) || !((BetaNode)node).isRightInputIsRiaNode())) continue;
                        foundDirty = true;
                        smemIndex = i;
                        break;
                    }
                    if (!foundDirty) break;
                }
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(node);
                    log.trace("{} Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)smemIndex);
                    log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), cycle, node.toString(), srcTuples.toStringSizes()});
                }
            }
            long dirtyMask = smem.getDirtyNodeMask();
            if (emptySrcTuples) {
                while (!((dirtyMask & bit) != 0L || node == smem.getTipNode() || NodeTypeEnums.isBetaNode(node) && ((BetaNode)node).isRightInputIsRiaNode())) {
                    if (log.isTraceEnabled()) {
                        int offset = RuleNetworkEvaluator.getOffset(node);
                        log.trace("{} Skip Node {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)node);
                    }
                    bit <<= 1;
                    node = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = (Memory)nodeMem.getNext();
                }
            }
            if (NodeTypeEnums.isTerminalNode(node)) {
                TerminalNode rtn = (TerminalNode)node;
                if (node.getType() == 91) {
                    pQtNode.doNode((QueryTerminalNode)rtn, wm, srcTuples, stack);
                    break;
                }
                pRtNode.doNode(rtn, wm, srcTuples, executor);
                break;
            }
            if (71 == node.getType()) {
                this.doRiaNode2(wm, srcTuples, (RightInputAdapterNode)node);
                break;
            }
            stagedLeftTuples = RuleNetworkEvaluator.getTargetStagedLeftTuples(node, wm, smem);
            LeftTupleSinkNode sink = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
            trgTuples = new LeftTupleSetsImpl();
            if (NodeTypeEnums.isBetaNode(node)) {
                exitInnerEval2 = this.evalBetaNode(liaNode, pmem, node, nodeMem, smems, smemIndex, trgTuples, wm, stack, outerStack, visitedRules, processRian, executor, srcTuples, stagedLeftTuples, sink);
                if (exitInnerEval2) {
                    break;
                }
            } else {
                exitInnerEval2 = false;
                switch (node.getType()) {
                    case 131: {
                        pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 151: {
                        pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 153: {
                        pReactiveFromNode.doNode((ReactiveFromNode)node, (ReactiveFromNode.ReactiveFromMemory)nodeMem, (LeftTupleSink)sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 165: {
                        exitInnerEval2 = this.evalQueryNode(liaNode, pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, wm, stack, visitedRules, srcTuples, sink, stagedLeftTuples);
                        break;
                    }
                    case 133: {
                        pTimerNode.doNode((TimerNode)node, (TimerNode.TimerNodeMemory)nodeMem, pmem, smem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 167: {
                        pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples, executor);
                    }
                }
                if (exitInnerEval2 && trgTuples.isEmpty()) break;
            }
            if (node != smem.getTipNode()) {
                node = sink;
                nodeMem = (Memory)nodeMem.getNext();
                bit <<= 1;
            } else {
                LeftTupleSets exitInnerEval2 = ((SegmentMemory)smem.getFirst()).getStagedLeftTuples();
                synchronized (exitInnerEval2) {
                    ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().addAll(stagedLeftTuples);
                    SegmentPropagator.propagate(smem, trgTuples, wm);
                    bit = 1L;
                    smem = smems[++smemIndex];
                    trgTuples = smem.getStagedLeftTuples().takeAll();
                }
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(node);
                    log.trace("{} Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)smemIndex);
                }
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
            }
            processRian = true;
        }
        if (stagedLeftTuples != null && !stagedLeftTuples.isEmpty()) {
            LeftTupleSets leftTupleSets = ((SegmentMemory)smem.getFirst()).getStagedLeftTuples();
            synchronized (leftTupleSets) {
                ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().addAll(stagedLeftTuples);
            }
        }
    }

    public static LeftTupleSets getTargetStagedLeftTuples(NetworkNode node, InternalWorkingMemory wm, SegmentMemory smem) {
        if (node == smem.getTipNode()) {
            if (smem.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, smem, ((LeftTupleSource)node).getSinkPropagator());
            }
            return ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().takeAll();
        }
        return null;
    }

    private boolean evalQueryNode(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, Set<String> visitedRules, LeftTupleSets srcTuples, LeftTupleSinkNode sink, LeftTupleSets stagedLeftTuples) {
        QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
        if (srcTuples.isEmpty() && qmem.getResultLeftTuples().isEmpty()) {
            return false;
        }
        QueryElementNode qnode = (QueryElementNode)node;
        if (visitedRules == Collections.emptySet()) {
            visitedRules = new HashSet<String>();
        }
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} query result tuples {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)qmem.getResultLeftTuples().toStringSizes());
        }
        visitedRules.add(qnode.getQueryElement().getQueryName());
        trgTuples.addAll(qmem.getResultLeftTuples());
        qmem.setNodeCleanWithoutNotify();
        if (!srcTuples.isEmpty()) {
            StackEntry stackEntry = new StackEntry(liaNode, node, bit, sink, pmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, true, true);
            stack.add(stackEntry);
            pQueryNode.doNode(qnode, (QueryElementNode.QueryElementNodeMemory)nodeMem, stackEntry, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
            SegmentMemory qsmem = ((QueryElementNode.QueryElementNodeMemory)nodeMem).getQuerySegmentMemory();
            List<PathMemory> qpmems = qsmem.getPathMemories();
            for (int i = 0; i < qpmems.size(); ++i) {
                PathMemory qpmem;
                pmem = qpmem = qpmems.get(i);
                smems = qpmem.getSegmentMemories();
                SegmentMemory smem = smems[smemIndex = 0];
                liaNode = (LeftInputAdapterNode)smem.getRootNode();
                if (liaNode == smem.getTipNode()) {
                    smem = smems[++smemIndex];
                    node = smem.getRootNode();
                    nodeMem = smem.getNodeMemories().getFirst();
                    bit = 1L;
                } else {
                    node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
                    bit = 2L;
                }
                trgTuples = smem.getStagedLeftTuples().takeAll();
                stackEntry = new StackEntry(liaNode, node, bit, null, pmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, false, true);
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(stackEntry.getNode());
                    log.trace("{} ORQueue branch={} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), i, stackEntry.getNode().toString(), trgTuples.toStringSizes()});
                }
                stack.add(stackEntry);
            }
            return true;
        }
        return false;
    }

    private boolean evalBetaNode(LeftInputAdapterNode liaNode, PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, boolean processRian, RuleExecutor executor, LeftTupleSets srcTuples, LeftTupleSets stagedLeftTuples, LeftTupleSinkNode sink) {
        BetaMemory bm;
        BetaNode betaNode = (BetaNode)node;
        AccumulateNode.AccumulateMemory am = null;
        if (211 == node.getType()) {
            am = (AccumulateNode.AccumulateMemory)nodeMem;
            bm = am.getBetaMemory();
        } else {
            bm = (BetaMemory)nodeMem;
        }
        if (processRian && betaNode.isRightInputIsRiaNode()) {
            this.doRiaNode(wm, liaNode, pmem, srcTuples, betaNode, sink, smems, smemIndex, nodeMem, bm, stack, outerStack, visitedRules, executor);
            return true;
        }
        this.switchOnDoBetaNode(node, trgTuples, wm, srcTuples, stagedLeftTuples, sink, bm, am);
        return false;
    }

    private void switchOnDoBetaNode(NetworkNode node, LeftTupleSets trgTuples, InternalWorkingMemory wm, LeftTupleSets srcTuples, LeftTupleSets stagedLeftTuples, LeftTupleSinkNode sink, BetaMemory bm, AccumulateNode.AccumulateMemory am) {
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} rightTuples {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)bm.getStagedRightTuples().toStringSizes());
        }
        switch (node.getType()) {
            case 181: {
                pJoinNode.doNode((JoinNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 191: {
                pNotNode.doNode((NotNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 201: {
                pExistsNode.doNode((ExistsNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 211: {
                pAccNode.doNode((AccumulateNode)node, sink, am, wm, srcTuples, trgTuples, stagedLeftTuples);
            }
        }
    }

    private void doRiaNode(InternalWorkingMemory wm, LeftInputAdapterNode liaNode, PathMemory pmem, LeftTupleSets srcTuples, BetaNode betaNode, LeftTupleSinkNode sink, SegmentMemory[] smems, int smemIndex, Memory nodeMem, BetaMemory bm, LinkedList<StackEntry> stack, LinkedList<StackEntry> outerStack, Set<String> visitedRules, RuleExecutor executor) {
        RiaPathMemory pathMem = bm.getRiaRuleMemory();
        SegmentMemory[] subnetworkSmems = pathMem.getSegmentMemories();
        SegmentMemory subSmem = null;
        int i = 0;
        while (subSmem == null) {
            subSmem = subnetworkSmems[i];
            ++i;
        }
        StackEntry stackEntry = new StackEntry(liaNode, betaNode, bm.getNodePosMaskBit(), sink, pmem, nodeMem, smems, smemIndex, srcTuples, visitedRules, false, false);
        stack.add(stackEntry);
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(betaNode);
            log.trace("{} RiaQueue {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), betaNode.toString(), srcTuples.toStringSizes()});
        }
        LeftTupleSets subLts = subSmem.getStagedLeftTuples().takeAll();
        this.innerEval(liaNode, pathMem, subSmem.getRootNode(), 1L, subSmem.getNodeMemories().getFirst(), subnetworkSmems, subSmem.getPos(), subLts, wm, stack, outerStack, visitedRules, true, executor);
    }

    private void doRiaNode2(InternalWorkingMemory wm, LeftTupleSets srcTuples, RightInputAdapterNode riaNode) {
        RightTupleSets rightTuples;
        RightTuple rightTuple;
        InternalFactHandle handle;
        int i;
        LeftTuple next;
        ObjectSink[] sinks = riaNode.getSinkPropagator().getSinks();
        BetaNode betaNode = (BetaNode)sinks[0];
        Memory nodeMem = wm.getNodeMemory(betaNode);
        BetaMemory bm = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem).getBetaMemory() : (BetaMemory)nodeMem;
        BetaNode[] bns = null;
        BetaMemory[] bms = null;
        int length = sinks.length;
        if (length > 1) {
            bns = new BetaNode[sinks.length - 1];
            bms = new BetaMemory[sinks.length - 1];
            for (int i2 = 1; i2 < length; ++i2) {
                bns[i2 - 1] = (BetaNode)sinks[i2];
                Memory nodeMem2 = wm.getNodeMemory(bns[i2 - 1]);
                bms[i2 - 1] = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem2).getBetaMemory() : (BetaMemory)nodeMem2;
            }
        }
        --length;
        LeftTuple leftTuple = srcTuples.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            PropagationContext pctx = leftTuple.getPropagationContext();
            InternalFactHandle handle2 = riaNode.createFactHandle(leftTuple, pctx, wm);
            RightTuple rightTuple2 = new RightTuple(handle2, betaNode);
            leftTuple.setObject(handle2);
            rightTuple2.setPropagationContext(pctx);
            bm.getStagedRightTuples().addInsert(rightTuple2);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    rightTuple2 = new RightTuple(handle2, bns[i]);
                    rightTuple2.setPropagationContext(pctx);
                    bms[i].getStagedRightTuples().addInsert(rightTuple2);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = srcTuples.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            handle = (InternalFactHandle)leftTuple.getObject();
            rightTuple = handle.getFirstRightTuple();
            rightTuples = bm.getStagedRightTuples();
            rightTuples.addDelete(rightTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    rightTuple = rightTuple.getHandleNext();
                    rightTuples = bms[i].getStagedRightTuples();
                    rightTuples.addDelete(rightTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = srcTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            handle = (InternalFactHandle)leftTuple.getObject();
            rightTuple = handle.getFirstRightTuple();
            rightTuples = bm.getStagedRightTuples();
            rightTuples.addUpdate(rightTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    rightTuple = rightTuple.getHandleNext();
                    rightTuples = bms[i].getStagedRightTuples();
                    rightTuples.addUpdate(rightTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        srcTuples.resetAll();
    }

    public static void findLeftTupleBlocker(BetaNode betaNode, RightTupleMemory rtm, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTuple leftTuple, FastIterator it, boolean useLeftMemory) {
        RightTuple rightTuple = betaNode.getFirstRightTuple(leftTuple, rtm, null, it);
        while (rightTuple != null) {
            RightTuple nextRight = (RightTuple)it.next(rightTuple);
            if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (useLeftMemory) {
                    rightTuple.addBlocked(leftTuple);
                    break;
                }
                if (!betaNode.isRightInputIsRiaNode()) break;
                rtm.remove(rightTuple);
            }
            rightTuple = nextRight;
        }
    }

    public static LeftTuple deleteLeftChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getLeftParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static LeftTuple deleteRightChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getRightParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static void doUpdatesReorderLeftMemory(BetaMemory bm, LeftTupleSets srcLeftTuples) {
        LeftTuple next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.remove(leftTuple);
            leftTuple = next;
        }
        leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.add(leftTuple);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                LeftTuple childNext = childLeftTuple.getLeftParentNext();
                childLeftTuple.reAddRight();
                childLeftTuple = childNext;
            }
            leftTuple = next;
        }
    }

    public static void doUpdatesExistentialReorderLeftMemory(BetaMemory bm, LeftTupleSets srcLeftTuples) {
        LeftTuple next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
            }
            leftTuple = next;
        }
        leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                ltm.add(leftTuple);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getLeftParentNext();
                    childLeftTuple.reAddRight();
                    childLeftTuple = childNext;
                }
            } else if (blocker.getStagedType() != 0) {
                blocker.removeBlocked(leftTuple);
            }
            leftTuple = next;
        }
    }

    public static void doUpdatesReorderRightMemory(BetaMemory bm, RightTupleSets srcRightTuples) {
        RightTuple next;
        RightTupleMemory rtm = bm.getRightTupleMemory();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
                rtm.remove(rightTuple);
            }
            rightTuple = next;
        }
        rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getTempRightTupleMemory() != null) {
                rtm.add(rightTuple);
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static void doUpdatesExistentialReorderRightMemory(BetaMemory bm, BetaNode betaNode, RightTupleSets srcRightTuples) {
        RightTuple tempRightTuple;
        RightTuple next;
        RightTupleMemory rtm = bm.getRightTupleMemory();
        boolean resumeFromCurrent = !betaNode.isIndexedUnificationJoin() && !rtm.getIndexType().isComparison();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
                if (resumeFromCurrent && rightTuple.getBlocked() != null) {
                    for (tempRightTuple = (RightTuple)rightTuple.getNext(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getNext()) {
                    }
                    if (tempRightTuple == null) {
                        for (tempRightTuple = (RightTuple)rightTuple.getPrevious(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getPrevious()) {
                        }
                    }
                    rightTuple.setTempNextRightTuple(tempRightTuple);
                }
                rightTuple.setTempBlocked(rightTuple.getBlocked());
                rightTuple.nullBlocked();
                rtm.remove(rightTuple);
            }
            rightTuple = next;
        }
        rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getTempRightTupleMemory() != null) {
                rtm.add(rightTuple);
                if (resumeFromCurrent) {
                    tempRightTuple = rightTuple.getTempNextRightTuple();
                    if (rightTuple.getBlocked() != null && tempRightTuple == null && rightTuple.getMemory() == rightTuple.getTempRightTupleMemory()) {
                        rightTuple.setTempNextRightTuple(rightTuple);
                    }
                }
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static boolean useLeftMemory(LeftTupleSource tupleSource, LeftTuple leftTuple) {
        Object object;
        boolean useLeftMemory = true;
        if (!(tupleSource.isLeftTupleMemoryEnabled() || (object = leftTuple.getRootLeftTuple().getLastHandle().getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        return useLeftMemory;
    }
}

