/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Iterator;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;

public class SynchronizedPropagationList
implements PropagationList {
    private final InternalWorkingMemory workingMemory;
    private volatile PropagationEntry head;
    private volatile PropagationEntry tail;

    public SynchronizedPropagationList(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(final PropagationEntry entry) {
        boolean executed;
        if (entry.requiresImmediateFlushingIfNotFiring() && (executed = this.workingMemory.getAgenda().executeIfNotFiring(new Runnable(){

            @Override
            public void run() {
                ((PhreakTimerNode.TimerAction)entry).execute(SynchronizedPropagationList.this.workingMemory, true);
            }
        }))) {
            return;
        }
        SynchronizedPropagationList synchronizedPropagationList = this;
        synchronized (synchronizedPropagationList) {
            boolean wasEmpty;
            boolean bl = wasEmpty = this.head == null;
            if (wasEmpty) {
                this.head = entry;
            } else {
                this.tail.setNext(entry);
            }
            this.tail = entry;
            if (wasEmpty) {
                this.workingMemory.getAgenda().notifyHalt();
            }
        }
    }

    @Override
    public void flush() {
        while (this.head != null) {
            this.internalFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlush() {
        SynchronizedPropagationList synchronizedPropagationList = this;
        synchronized (synchronizedPropagationList) {
            PropagationEntry currentHead = this.head;
            this.head = null;
            this.tail = null;
        }
        for (PropagationEntry entry = currentHead; entry != null; entry = entry.getNext()) {
            entry.execute(this.workingMemory);
        }
    }

    @Override
    public synchronized void flushNonMarshallable() {
        PropagationEntry newHead = null;
        PropagationEntry newTail = null;
        for (PropagationEntry entry = this.head; entry != null; entry = entry.getNext()) {
            if (entry.isMarshallable()) {
                if (newHead == null) {
                    newHead = entry;
                } else {
                    newTail.setNext(entry);
                }
                newTail = entry;
                continue;
            }
            entry.execute(this.workingMemory);
        }
        this.head = newHead;
        this.tail = newTail;
    }

    @Override
    public synchronized void reset() {
        this.head = null;
        this.tail = null;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public synchronized Iterator<PropagationEntry> iterator() {
        return new PropagationEntryIterator(this.head);
    }

    public static class PropagationEntryIterator
    implements Iterator<PropagationEntry> {
        private PropagationEntry next;

        public PropagationEntryIterator(PropagationEntry head) {
            this.next = head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PropagationEntry next() {
            PropagationEntry current = this.next;
            this.next = current.getNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

