/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ChainedChangeMove
extends ChangeMove {
    protected final SingletonInverseVariableSupply inverseVariableSupply;

    public ChainedChangeMove(Object entity, GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        super(entity, variableDescriptor, toPlanningValue);
        this.inverseVariableSupply = inverseVariableSupply;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return super.isMoveDoable(scoreDirector) && !ObjectUtils.equals((Object)this.entity, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return new ChainedChangeMove(this.entity, this.variableDescriptor, this.inverseVariableSupply, oldValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        Object newTrailingEntity;
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        Object oldTrailingEntity = this.inverseVariableSupply.getInverseSingleton(this.entity);
        Object object = newTrailingEntity = this.toPlanningValue == null ? null : this.inverseVariableSupply.getInverseSingleton(this.toPlanningValue);
        if (oldTrailingEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, oldTrailingEntity, oldValue);
        }
        scoreDirector.changeVariableFacade(this.variableDescriptor, this.entity, this.toPlanningValue);
        if (newTrailingEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, newTrailingEntity, this.entity);
        }
    }
}

