/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.ListIterable;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainReversingSwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainSwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class SubChainSwapMoveSelector
extends GenericMoveSelector {
    protected final SubChainSelector leftSubChainSelector;
    protected final SubChainSelector rightSubChainSelector;
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final boolean randomSelection;
    protected final boolean selectReversingMoveToo;
    protected SingletonInverseVariableSupply inverseVariableSupply = null;

    public SubChainSwapMoveSelector(SubChainSelector leftSubChainSelector, SubChainSelector rightSubChainSelector, boolean randomSelection, boolean selectReversingMoveToo) {
        this.leftSubChainSelector = leftSubChainSelector;
        this.rightSubChainSelector = rightSubChainSelector;
        this.randomSelection = randomSelection;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.variableDescriptor = leftSubChainSelector.getVariableDescriptor();
        if (leftSubChainSelector.getVariableDescriptor() != rightSubChainSelector.getVariableDescriptor()) {
            throw new IllegalStateException("The selector (" + this + ") has a leftSubChainSelector's variableDescriptor (" + leftSubChainSelector.getVariableDescriptor() + ") which is not equal to the rightSubChainSelector's variableDescriptor (" + rightSubChainSelector.getVariableDescriptor() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(leftSubChainSelector);
        if (leftSubChainSelector != rightSubChainSelector) {
            this.phaseLifecycleSupport.addEventListener(rightSubChainSelector);
        }
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(this.variableDescriptor));
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.leftSubChainSelector.isCountable() && this.rightSubChainSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftSubChainSelector.isNeverEnding() || this.rightSubChainSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftSubChainSelector, this.rightSubChainSelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, SubChain>((ListIterable)this.leftSubChainSelector, (ListIterable)this.rightSubChainSelector){
                private Move nextReversingSelection;
                {
                    this.nextReversingSelection = null;
                }

                @Override
                protected Move createUpcomingSelection() {
                    if (SubChainSwapMoveSelector.this.selectReversingMoveToo && this.nextReversingSelection != null) {
                        Move upcomingSelection = this.nextReversingSelection;
                        this.nextReversingSelection = null;
                        return upcomingSelection;
                    }
                    return (Move)super.createUpcomingSelection();
                }

                @Override
                protected Move newSwapSelection(SubChain leftSubSelection, SubChain rightSubSelection) {
                    if (SubChainSwapMoveSelector.this.selectReversingMoveToo) {
                        this.nextReversingSelection = new SubChainReversingSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection);
                    }
                    return new SubChainSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, SubChain>((Iterable)this.leftSubChainSelector, (Iterable)this.rightSubChainSelector){

            @Override
            protected Move newSwapSelection(SubChain leftSubSelection, SubChain rightSubSelection) {
                boolean reversing = SubChainSwapMoveSelector.this.selectReversingMoveToo ? SubChainSwapMoveSelector.this.workingRandom.nextBoolean() : false;
                return reversing ? new SubChainReversingSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection) : new SubChainSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftSubChainSelector + ", " + this.rightSubChainSelector + ")";
    }
}

