/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager.finalist;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.AbstractFinalistPodium;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class StrategicOscillationByLevelFinalistPodium
extends AbstractFinalistPodium {
    protected final boolean referenceBestScoreInsteadOfLastStepScore;
    protected Number[] referenceLevelNumbers;
    protected Score finalistScore;
    protected Number[] finalistLevelNumbers;

    public StrategicOscillationByLevelFinalistPodium(boolean referenceBestScoreInsteadOfLastStepScore) {
        this.referenceBestScoreInsteadOfLastStepScore = referenceBestScoreInsteadOfLastStepScore;
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.referenceLevelNumbers = this.referenceBestScoreInsteadOfLastStepScore ? stepScope.getPhaseScope().getBestScore().toLevelNumbers() : stepScope.getPhaseScope().getLastCompletedStepScope().getScore().toLevelNumbers();
        this.finalistScore = null;
        this.finalistLevelNumbers = null;
    }

    @Override
    public void addMove(LocalSearchMoveScope moveScope) {
        Number[] moveLevelNumbers;
        Score moveScore;
        int comparison;
        boolean accepted = moveScope.getAccepted();
        if (this.finalistIsAccepted && !accepted) {
            return;
        }
        if (accepted && !this.finalistIsAccepted) {
            this.finalistIsAccepted = true;
            this.finalistScore = null;
            this.finalistLevelNumbers = null;
        }
        if ((comparison = this.doComparison(moveScore = moveScope.getScore(), moveLevelNumbers = moveScore.toLevelNumbers())) > 0) {
            this.finalistScore = moveScore;
            this.finalistLevelNumbers = moveLevelNumbers;
            this.finalistList.clear();
            this.finalistList.add(moveScope);
        } else if (comparison == 0) {
            this.finalistList.add(moveScope);
        }
    }

    private int doComparison(Score moveScore, Number[] moveLevelNumbers) {
        if (this.finalistScore == null) {
            return 1;
        }
        for (int i = 0; i < this.referenceLevelNumbers.length; ++i) {
            boolean finalistIsHigher;
            boolean moveIsHigher = ((Comparable)((Object)moveLevelNumbers[i])).compareTo(this.referenceLevelNumbers[i]) > 0;
            boolean bl = finalistIsHigher = ((Comparable)((Object)this.finalistLevelNumbers[i])).compareTo(this.referenceLevelNumbers[i]) > 0;
            if (moveIsHigher) {
                if (finalistIsHigher) break;
                return 1;
            }
            if (!finalistIsHigher) continue;
            return -1;
        }
        return moveScore.compareTo(this.finalistScore);
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.referenceLevelNumbers = null;
        this.finalistScore = null;
        this.finalistLevelNumbers = null;
    }
}

