/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirectorFactory
implements InnerScoreDirectorFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolutionDescriptor solutionDescriptor;
    protected ScoreDefinition scoreDefinition;
    protected InitializingScoreTrend initializingScoreTrend;
    protected InnerScoreDirectorFactory assertionScoreDirectorFactory = null;
    protected boolean assertClonedSolution = false;

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public void setSolutionDescriptor(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    @Override
    public InitializingScoreTrend getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public void setInitializingScoreTrend(InitializingScoreTrend initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
    }

    public InnerScoreDirectorFactory getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(InnerScoreDirectorFactory assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    public boolean isAssertClonedSolution() {
        return this.assertClonedSolution;
    }

    public void setAssertClonedSolution(boolean assertClonedSolution) {
        this.assertClonedSolution = assertClonedSolution;
    }

    @Override
    public InnerScoreDirector buildScoreDirector() {
        return this.buildScoreDirector(true);
    }

    @Override
    public void assertScoreFromScratch(Solution solution) {
        Object score = solution.getScore();
        InnerScoreDirector uncorruptedScoreDirector = this.buildScoreDirector(true);
        uncorruptedScoreDirector.setWorkingSolution(solution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        uncorruptedScoreDirector.dispose();
        if (!score.equals(uncorruptedScore)) {
            throw new IllegalStateException("Score corruption: the solution's score (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ").");
        }
    }
}

