/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.scope;

import java.util.List;
import java.util.Random;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.ScoreUtils;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSolverScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int startingSolverCount;
    protected Random workingRandom;
    protected InnerScoreDirector scoreDirector;
    protected Long startingSystemTimeMillis;
    protected Long endingSystemTimeMillis;
    protected Score startingInitializedScore;
    protected volatile Solution bestSolution;
    protected int bestUninitializedVariableCount;
    protected Score bestScore;
    protected Long bestSolutionTimeMillis;

    public int getStartingSolverCount() {
        return this.startingSolverCount;
    }

    public void setStartingSolverCount(int startingSolverCount) {
        this.startingSolverCount = startingSolverCount;
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public InnerScoreDirector getScoreDirector() {
        return this.scoreDirector;
    }

    public void setScoreDirector(InnerScoreDirector scoreDirector) {
        this.scoreDirector = scoreDirector;
    }

    public Long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public void setStartingSystemTimeMillis(Long startingSystemTimeMillis) {
        this.startingSystemTimeMillis = startingSystemTimeMillis;
    }

    public Long getEndingSystemTimeMillis() {
        return this.endingSystemTimeMillis;
    }

    public void setEndingSystemTimeMillis(Long endingSystemTimeMillis) {
        this.endingSystemTimeMillis = endingSystemTimeMillis;
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.scoreDirector.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirector.getScoreDefinition();
    }

    public Solution getWorkingSolution() {
        return this.scoreDirector.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.scoreDirector.getWorkingEntityCount();
    }

    public List<Object> getWorkingEntityList() {
        return this.scoreDirector.getWorkingEntityList();
    }

    public int getWorkingValueCount() {
        return this.scoreDirector.getWorkingValueCount();
    }

    public Score calculateScore() {
        return this.scoreDirector.calculateScore();
    }

    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        this.scoreDirector.assertExpectedWorkingScore(expectedWorkingScore, completedAction);
    }

    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        this.scoreDirector.assertWorkingScoreFromScratch(workingScore, completedAction);
    }

    public void assertScoreFromScratch(Solution solution) {
        this.scoreDirector.getScoreDirectorFactory().assertScoreFromScratch(solution);
    }

    public Score getStartingInitializedScore() {
        return this.startingInitializedScore;
    }

    public void setStartingInitializedScore(Score startingInitializedScore) {
        this.startingInitializedScore = startingInitializedScore;
    }

    public long getCalculateCount() {
        return this.scoreDirector.getCalculateCount();
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public int getBestUninitializedVariableCount() {
        return this.bestUninitializedVariableCount;
    }

    public void setBestUninitializedVariableCount(int bestUninitializedVariableCount) {
        if (bestUninitializedVariableCount < 0) {
            throw new IllegalArgumentException("The bestUninitializedVariableCount (" + bestUninitializedVariableCount + ") cannot be negative.");
        }
        this.bestUninitializedVariableCount = bestUninitializedVariableCount;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public Long getBestSolutionTimeMillis() {
        return this.bestSolutionTimeMillis;
    }

    public void setBestSolutionTimeMillis(Long bestSolutionTimeMillis) {
        this.bestSolutionTimeMillis = bestSolutionTimeMillis;
    }

    public boolean isBestSolutionInitialized() {
        return this.bestUninitializedVariableCount == 0;
    }

    public long calculateTimeMillisSpent() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public void setWorkingSolutionFromBestSolution() {
        this.scoreDirector.setWorkingSolution(this.scoreDirector.cloneSolution(this.bestSolution));
    }

    public String getBestScoreWithUninitializedPrefix() {
        return ScoreUtils.getScoreWithUninitializedPrefix(this.bestUninitializedVariableCount, this.bestScore);
    }
}

