/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorPublisher;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.TypeArguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key<T> implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding<?> binding;
            if (!(p instanceof InjectorPublisher) || (binding = (i = ((InjectorPublisher)p).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key<T> justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorPublisher)) continue;
            Injector i = ((InjectorPublisher)p).getInjector();
            try {
                Binding<T> binding = i.getBinding(justInTimeKey);
                if (!InjectorPublisher.isVisible(binding)) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

