/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.reteoo.nodes.ReteSlidingLengthWindow;
import org.drools.reteoo.nodes.ReteSlidingTimeWindow;

public class ReteWindowNode
extends WindowNode
implements ObjectSinkNode,
RightTupleSink,
MemoryFactory {
    public ReteWindowNode() {
    }

    public ReteWindowNode(int id, List<AlphaNodeFieldConstraint> constraints, List<Behavior> behaviors, ObjectSource objectSource, BuildContext context) {
        super(id, constraints, ReteWindowNode.convertBehaviors(behaviors), objectSource, context);
    }

    private static List<Behavior> convertBehaviors(List<Behavior> behaviors) {
        ArrayList<Behavior> converted = new ArrayList<Behavior>();
        for (Behavior b : behaviors) {
            if (b instanceof SlidingLengthWindow) {
                converted.add(new ReteSlidingLengthWindow((int)((SlidingLengthWindow)b).getSize()));
                continue;
            }
            if (b instanceof SlidingTimeWindow) {
                converted.add(new ReteSlidingTimeWindow((int)((SlidingTimeWindow)b).getSize()));
                continue;
            }
            converted.add(b);
        }
        return converted;
    }

    public void attach(BuildContext context) {
        this.source.addObjectSink((ObjectSink)this);
        if (context == null || context.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink((ObjectSink)this, propagationContext, workingMemory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        ReteWindowMemory memory = (ReteWindowMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        EventFactHandle evFh = (EventFactHandle)factHandle;
        memory.gate.lock();
        try {
            boolean index = false;
            for (AlphaNodeFieldConstraint constraint : this.getConstraints()) {
                if (constraint.isAllowed((InternalFactHandle)evFh, workingMemory)) continue;
                return;
            }
            RightTupleImpl rightTuple = new RightTupleImpl((InternalFactHandle)evFh, (RightTupleSink)this);
            rightTuple.setPropagationContext(pctx);
            EventFactHandle clonedFh = evFh.cloneAndLink();
            rightTuple.setContextObject((Object)clonedFh);
            if (!this.behavior.assertFact((Object)memory.behaviorContext, (InternalFactHandle)clonedFh, pctx, workingMemory)) {
                return;
            }
            this.sink.propagateAssertObject((InternalFactHandle)clonedFh, pctx, workingMemory);
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory wm) {
        ReteWindowMemory memory = (ReteWindowMemory)wm.getNodeMemory((MemoryFactory)this);
        memory.gate.lock();
        try {
            this.behavior.retractFact((Object)memory.behaviorContext, rightTuple.getFactHandle(), pctx, wm);
        }
        finally {
            memory.gate.unlock();
        }
        InternalFactHandle clonedFh = (InternalFactHandle)rightTuple.getContextObject();
        ObjectTypeNode.doRetractObject((InternalFactHandle)clonedFh, (PropagationContext)pctx, (InternalWorkingMemory)wm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteWindowMemory memory = (ReteWindowMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.gate.lock();
        EventFactHandle originalFactHandle = (EventFactHandle)rightTuple.getFactHandle();
        EventFactHandle cloneFactHandle = (EventFactHandle)rightTuple.getContextObject();
        originalFactHandle.quickCloneUpdate((DefaultFactHandle)cloneFactHandle);
        try {
            boolean index = false;
            boolean isAllowed = true;
            for (AlphaNodeFieldConstraint constraint : this.getConstraints()) {
                if (constraint.isAllowed((InternalFactHandle)cloneFactHandle, workingMemory)) continue;
                isAllowed = false;
                break;
            }
            if (isAllowed) {
                ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(cloneFactHandle.getFirstLeftTuple(), cloneFactHandle.getFirstRightTuple(), this.epNode);
                cloneFactHandle.clearLeftTuples();
                cloneFactHandle.clearRightTuples();
                this.sink.propagateModifyObject((InternalFactHandle)cloneFactHandle, modifyPreviousTuples, context, workingMemory);
                modifyPreviousTuples.retractTuples(context, workingMemory);
            } else {
                ObjectTypeNode.doRetractObject((InternalFactHandle)cloneFactHandle, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
            }
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteWindowMemory memory = (ReteWindowMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.gate.lock();
        try {
            this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory wm) {
        ReteWindowMemory memory = (ReteWindowMemory)wm.getNodeMemory((MemoryFactory)this);
        memory.gate.lock();
        try {
            ObjectTypeNode.ObjectTypeNodeMemory omem = (ObjectTypeNode.ObjectTypeNodeMemory)wm.getNodeMemory((MemoryFactory)this.getObjectTypeNode());
            Iterator it = omem.iterator();
            while (it.hasNext()) {
                sink.assertObject((InternalFactHandle)it.next(), context, wm);
            }
        }
        finally {
            memory.gate.unlock();
        }
    }

    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        ReteWindowMemory memory = new ReteWindowMemory();
        memory.behaviorContext = this.behavior.createBehaviorContext();
        memory.gate = new ReentrantLock();
        return memory;
    }

    public static class ReteWindowMemory
    extends WindowNode.WindowMemory {
        public transient ReentrantLock gate;
    }
}

