/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.graph.NodeAdjacencies;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class DirectedNodeAdjacencies<N>
implements NodeAdjacencies<N> {
    private final Map<N, Adjacency> adjacentNodes;
    private int predecessorCount;
    private int successorCount;

    private DirectedNodeAdjacencies(Map<N, Adjacency> adjacentNodes, int predecessorCount, int successorCount) {
        this.adjacentNodes = Preconditions.checkNotNull(adjacentNodes, "adjacentNodes");
        this.predecessorCount = predecessorCount;
        this.successorCount = successorCount;
    }

    static <N> DirectedNodeAdjacencies<N> of() {
        return new DirectedNodeAdjacencies(Maps.newHashMapWithExpectedSize(11), 0, 0);
    }

    static <N> DirectedNodeAdjacencies<N> ofImmutable(Map<N, Adjacency> adjacentNodes, int predecessorCount, int successorCount) {
        return new DirectedNodeAdjacencies<N>(ImmutableMap.copyOf(adjacentNodes), predecessorCount, successorCount);
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodes.keySet());
    }

    @Override
    public Set<N> predecessors() {
        return new AbstractSet<N>(){

            @Override
            public Iterator<N> iterator() {
                return Iterators.filter(DirectedNodeAdjacencies.this.adjacentNodes().iterator(), new Predicate<N>(){

                    @Override
                    public boolean apply(N node) {
                        return DirectedNodeAdjacencies.this.isPredecessor(node);
                    }
                });
            }

            @Override
            public int size() {
                return DirectedNodeAdjacencies.this.predecessorCount;
            }

            @Override
            public boolean contains(Object o) {
                return DirectedNodeAdjacencies.this.isPredecessor(o);
            }
        };
    }

    @Override
    public Set<N> successors() {
        return new AbstractSet<N>(){

            @Override
            public Iterator<N> iterator() {
                return Iterators.filter(DirectedNodeAdjacencies.this.adjacentNodes().iterator(), new Predicate<N>(){

                    @Override
                    public boolean apply(N node) {
                        return DirectedNodeAdjacencies.this.isSuccessor(node);
                    }
                });
            }

            @Override
            public int size() {
                return DirectedNodeAdjacencies.this.successorCount;
            }

            @Override
            public boolean contains(Object o) {
                return DirectedNodeAdjacencies.this.isSuccessor(o);
            }
        };
    }

    @Override
    public void removePredecessor(Object node) {
        Preconditions.checkNotNull(node, "node");
        Adjacency adjacency = this.adjacentNodes.get(node);
        if (adjacency == Adjacency.BOTH) {
            this.adjacentNodes.put(node, Adjacency.SUCC);
            --this.predecessorCount;
        } else if (adjacency == Adjacency.PRED) {
            this.adjacentNodes.remove(node);
            --this.predecessorCount;
        }
        Preconditions.checkState(this.predecessorCount >= 0);
    }

    @Override
    public void removeSuccessor(Object node) {
        Preconditions.checkNotNull(node, "node");
        Adjacency adjacency = this.adjacentNodes.get(node);
        if (adjacency == Adjacency.BOTH) {
            this.adjacentNodes.put(node, Adjacency.PRED);
            --this.successorCount;
        } else if (adjacency == Adjacency.SUCC) {
            this.adjacentNodes.remove(node);
            --this.successorCount;
        }
        Preconditions.checkState(this.successorCount >= 0);
    }

    @Override
    public void addPredecessor(N node) {
        Preconditions.checkNotNull(node, "node");
        Adjacency adjacency = this.adjacentNodes.get(node);
        if (adjacency == null) {
            this.adjacentNodes.put(node, Adjacency.PRED);
            ++this.predecessorCount;
        } else if (adjacency == Adjacency.SUCC) {
            this.adjacentNodes.put(node, Adjacency.BOTH);
            ++this.predecessorCount;
        }
        Preconditions.checkState(this.predecessorCount >= 1);
    }

    @Override
    public void addSuccessor(N node) {
        Preconditions.checkNotNull(node, "node");
        Adjacency adjacency = this.adjacentNodes.get(node);
        if (adjacency == null) {
            this.adjacentNodes.put(node, Adjacency.SUCC);
            ++this.successorCount;
        } else if (adjacency == Adjacency.PRED) {
            this.adjacentNodes.put(node, Adjacency.BOTH);
            ++this.successorCount;
        }
        Preconditions.checkState(this.successorCount >= 1);
    }

    private boolean isPredecessor(Object node) {
        Adjacency adjacency = this.adjacentNodes.get(node);
        return adjacency == Adjacency.PRED || adjacency == Adjacency.BOTH;
    }

    private boolean isSuccessor(Object node) {
        Adjacency adjacency = this.adjacentNodes.get(node);
        return adjacency == Adjacency.SUCC || adjacency == Adjacency.BOTH;
    }

    static enum Adjacency {
        PRED,
        SUCC,
        BOTH;

    }
}

