/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.admin.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.admin.MigrationReportInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class ProcessAdminServicesClientImpl
extends AbstractKieServicesClientImpl
implements ProcessAdminServicesClient {
    public ProcessAdminServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public ProcessAdminServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public MigrationReportInstance migrateProcessInstance(String containerId, Long processInstanceId, String targetContainerId, String targetProcessId) {
        return this.migrateProcessInstance(containerId, processInstanceId, targetContainerId, targetProcessId, new HashMap<String, String>());
    }

    @Override
    public MigrationReportInstance migrateProcessInstance(String containerId, Long processInstanceId, String targetContainerId, String targetProcessId, Map<String, String> nodeMapping) {
        MigrationReportInstance reportInstance = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?targetContainerId=" + targetContainerId + "&targetProcessId=" + targetProcessId;
            reportInstance = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{id}/processes/instances/{pInstanceId}", valuesMap) + queryString, nodeMapping, MigrationReportInstance.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "migrateProcessInstance", this.serialize(this.safeMap(nodeMapping)), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, targetContainerId, targetProcessId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            reportInstance = (MigrationReportInstance)response.getResult();
        }
        return reportInstance;
    }

    @Override
    public List<MigrationReportInstance> migrateProcessInstances(String containerId, List<Long> processInstancesId, String targetContainerId, String targetProcessId) {
        return this.migrateProcessInstances(containerId, processInstancesId, targetContainerId, targetProcessId, new HashMap<String, String>());
    }

    @Override
    public List<MigrationReportInstance> migrateProcessInstances(String containerId, List<Long> processInstancesId, String targetContainerId, String targetProcessId, Map<String, String> nodeMapping) {
        MigrationReportInstanceList reportInstanceList = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryStringBase = this.buildQueryString("pInstanceId", processInstancesId);
            String queryString = queryStringBase + "&targetContainerId=" + targetContainerId + "&targetProcessId=" + targetProcessId;
            reportInstanceList = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{id}/processes/instances", valuesMap) + queryString, nodeMapping, MigrationReportInstanceList.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "migrateProcessInstances", this.serialize(this.safeMap(nodeMapping)), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstancesId, targetContainerId, targetProcessId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            reportInstanceList = (MigrationReportInstanceList)response.getResult();
        }
        if (reportInstanceList != null) {
            return reportInstanceList.getItems();
        }
        return Collections.emptyList();
    }
}

