/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.cases.CaseAdHocFragment;
import org.kie.server.api.model.cases.CaseAdHocFragmentList;
import org.kie.server.api.model.cases.CaseComment;
import org.kie.server.api.model.cases.CaseCommentList;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseFile;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMilestone;
import org.kie.server.api.model.cases.CaseMilestoneList;
import org.kie.server.api.model.cases.CaseRoleAssignment;
import org.kie.server.api.model.cases.CaseRoleAssignmentList;
import org.kie.server.api.model.cases.CaseStage;
import org.kie.server.api.model.cases.CaseStageList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.CaseServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class CaseServicesClientImpl
extends AbstractKieServicesClientImpl
implements CaseServicesClient {
    public CaseServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public CaseServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public String startCase(String containerId, String caseDefinitionId) {
        return this.startCase(containerId, caseDefinitionId, new CaseFile());
    }

    @Override
    public String startCase(String containerId, String caseDefinitionId, CaseFile caseFile) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseDefId", caseDefinitionId);
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/{caseDefId}/instances", valuesMap), caseFile, String.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "startCase", this.serialize(caseFile), this.marshaller.getFormat().getType(), new Object[]{containerId, caseDefinitionId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (String)((Wrapped)result).unwrap();
        }
        return result;
    }

    @Override
    public CaseInstance getCaseInstance(String containerId, String caseId) {
        return this.getCaseInstance(containerId, caseId, false, false, false, false);
    }

    @Override
    public CaseInstance getCaseInstance(String containerId, String caseId, boolean withData, boolean withRoles, boolean withMilestones, boolean withStages) {
        CaseInstance caseInstance = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = "?withData=" + withData + "&withRoles=" + withRoles + "&withMilestones=" + withMilestones + "&withStages=" + withStages;
            caseInstance = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}", valuesMap) + queryString, CaseInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "getCaseInstance", this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, withData, withRoles, withMilestones, withStages})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            caseInstance = this.deserialize((String)response.getResult(), CaseInstance.class);
        }
        return caseInstance;
    }

    public void cancelOrDestroyCaseInstance(String containerId, String caseId, boolean destroy) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = "?destroy=" + destroy;
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}", valuesMap) + queryString, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "cancelCaseInstance", new Object[]{containerId, caseId, destroy})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void cancelCaseInstance(String containerId, String caseId) {
        this.cancelOrDestroyCaseInstance(containerId, caseId, false);
    }

    @Override
    public void destroyCaseInstance(String containerId, String caseId) {
        this.cancelOrDestroyCaseInstance(containerId, caseId, true);
    }

    @Override
    public Map<String, Object> getCaseInstanceData(String containerId, String caseId) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/caseFile", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "getCaseFileData", this.marshaller.getFormat().getType(), new Object[]{containerId, caseId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Map)((Wrapped)result).unwrap();
        }
        return (Map)result;
    }

    @Override
    public Object getCaseInstanceData(String containerId, String caseId, String name) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("dataId", name);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/caseFile/{dataId}", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "getCaseFileDataByName", this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, name})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return ((Wrapped)result).unwrap();
        }
        return result;
    }

    @Override
    public void putCaseInstanceData(String containerId, String caseId, Map<String, Object> data) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/caseFile", valuesMap), data, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "putCaseFileData", this.serialize(this.safeMap(data)), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void putCaseInstanceData(String containerId, String caseId, String name, Object data) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("dataId", name);
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/caseFile/{dataId}", valuesMap), data, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "putCaseFileDataByName", this.serialize(data), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, name})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeCaseInstanceData(String containerId, String caseId, String ... names) {
        List<String> variablesToRemove = Arrays.asList(names);
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = this.getAdditionalParams("", "dataId", variablesToRemove);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/caseFile", valuesMap) + queryString, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "removeCaseFileDataByName", new Object[]{containerId, caseId, variablesToRemove})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void addDynamicUserTask(String containerId, String caseId, String name, String description, String actors, String groups, Map<String, Object> data) {
        HashMap<String, Object> taskSpecMap = new HashMap<String, Object>();
        taskSpecMap.put("name", name);
        taskSpecMap.put("description", description);
        taskSpecMap.put("actors", actors);
        taskSpecMap.put("groups", groups);
        taskSpecMap.put("data", data);
        this.internalAddDynamicTask(containerId, caseId, null, taskSpecMap);
    }

    @Override
    public void addDynamicTask(String containerId, String caseId, String nodeType, String name, Map<String, Object> data) {
        HashMap<String, Object> taskSpecMap = new HashMap<String, Object>();
        taskSpecMap.put("name", name);
        taskSpecMap.put("nodeType", nodeType);
        taskSpecMap.put("data", data);
        this.internalAddDynamicTask(containerId, caseId, null, taskSpecMap);
    }

    @Override
    public void addDynamicUserTaskToStage(String containerId, String caseId, String stageId, String name, String description, String actors, String groups, Map<String, Object> data) {
        HashMap<String, Object> taskSpecMap = new HashMap<String, Object>();
        taskSpecMap.put("name", name);
        taskSpecMap.put("description", description);
        taskSpecMap.put("actors", actors);
        taskSpecMap.put("groups", groups);
        taskSpecMap.put("data", data);
        this.internalAddDynamicTask(containerId, caseId, stageId, taskSpecMap);
    }

    @Override
    public void addDynamicTaskToStage(String containerId, String caseId, String stageId, String nodeType, String name, Map<String, Object> data) {
        HashMap<String, Object> taskSpecMap = new HashMap<String, Object>();
        taskSpecMap.put("name", name);
        taskSpecMap.put("nodeType", nodeType);
        taskSpecMap.put("data", data);
        this.internalAddDynamicTask(containerId, caseId, stageId, taskSpecMap);
    }

    @Override
    public void addDynamicSubProcess(String containerId, String caseId, String processId, Map<String, Object> data) {
        this.internalAddDynamicSubProcess(containerId, caseId, null, processId, data);
    }

    @Override
    public void addDynamicSubProcessToStage(String containerId, String caseId, String stageId, String processId, Map<String, Object> data) {
        this.internalAddDynamicSubProcess(containerId, caseId, stageId, processId, data);
    }

    @Override
    public void triggerAdHocFragment(String containerId, String caseId, String adHocName, Map<String, Object> data) {
        this.internalTriggerAdHoc(containerId, caseId, null, adHocName, data);
    }

    @Override
    public void triggerAdHocFragmentInStage(String containerId, String caseId, String stageId, String adHocName, Map<String, Object> data) {
        this.internalTriggerAdHoc(containerId, caseId, stageId, adHocName, data);
    }

    @Override
    public List<CaseMilestone> getMilestones(String containerId, String caseId, boolean achievedOnly, Integer page, Integer pageSize) {
        CaseMilestoneList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = this.getPagingQueryString("?achievedOnly=" + achievedOnly, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/milestones", valuesMap) + queryString, CaseMilestoneList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getMilestones", new Object[]{containerId, caseId, achievedOnly, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseMilestoneList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseStage> getStages(String containerId, String caseId, boolean activeOnly, Integer page, Integer pageSize) {
        CaseStageList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = this.getPagingQueryString("?activeOnly=" + activeOnly, page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/stages", valuesMap) + queryString, CaseStageList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getStages", new Object[]{containerId, caseId, activeOnly, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseStageList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseAdHocFragment> getAdHocFragments(String containerId, String caseId) {
        CaseAdHocFragmentList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/adhocfragmets", valuesMap), CaseAdHocFragmentList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getAdHocFragments", new Object[]{containerId, caseId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseAdHocFragmentList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseRoleAssignment> getRoleAssignments(String containerId, String caseId) {
        CaseRoleAssignmentList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/roles", valuesMap), CaseRoleAssignmentList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "getRoleAssignment", new Object[]{containerId, caseId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseRoleAssignmentList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<NodeInstance> getActiveNodes(String containerId, String caseId, Integer page, Integer pageSize) {
        NodeInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getActiveNodes", new Object[]{containerId, caseId, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (NodeInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessInstance> getActiveProcessInstances(String containerId, String caseId, Integer page, Integer pageSize) {
        return this.getProcessInstances(containerId, caseId, null, page, pageSize);
    }

    @Override
    public List<ProcessInstance> getProcessInstances(String containerId, String caseId, List<Integer> status, Integer page, Integer pageSize) {
        ProcessInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/processes/instances", valuesMap) + queryString, ProcessInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getProcessInstancesForCase", new Object[]{containerId, caseId, this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (ProcessInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public void assignUserToRole(String containerId, String caseId, String roleName, String user) {
        this.internalAddRoleAssignment(containerId, caseId, roleName, user, null);
    }

    @Override
    public void assignGroupToRole(String containerId, String caseId, String roleName, String group) {
        this.internalAddRoleAssignment(containerId, caseId, roleName, null, group);
    }

    @Override
    public void removeUserFromRole(String containerId, String caseId, String roleName, String user) {
        this.internalRemoveRoleAssignment(containerId, caseId, roleName, user, null);
    }

    @Override
    public void removeGroupFromRole(String containerId, String caseId, String roleName, String group) {
        this.internalRemoveRoleAssignment(containerId, caseId, roleName, null, group);
    }

    @Override
    public List<CaseComment> getComments(String containerId, String caseId, Integer page, Integer pageSize) {
        CaseCommentList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/comments", valuesMap) + queryString, CaseCommentList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "getComments", new Object[]{containerId, caseId, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseCommentList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public void addComment(String containerId, String caseId, String author, String text) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = "?author=" + author;
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/comments", valuesMap) + queryString, text, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "addCommentToCase", this.serialize(text), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, author})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void updateComment(String containerId, String caseId, String commentId, String author, String text) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("caseCommentId", commentId);
            String queryString = "?author=" + author;
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/comments/{caseCommentId}", valuesMap) + queryString, this.serialize(text), null, new HashMap<String, String>());
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "updateCommentInCase", this.serialize(text), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, commentId, author})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeComment(String containerId, String caseId, String commentId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("caseCommentId", commentId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/comments/{caseCommentId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "removeCommentFromCase", new Object[]{containerId, caseId, commentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<CaseInstance> getCaseInstances(Integer page, Integer pageSize) {
        return this.getCaseInstances(null, page, pageSize);
    }

    @Override
    public List<CaseInstance> getCaseInstances(List<Integer> status, Integer page, Integer pageSize) {
        CaseInstanceList list = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/cases/instances", valuesMap) + queryString, CaseInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseInstances", new Object[]{this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseInstance> getCaseInstancesOwnedBy(String owner, List<Integer> status, Integer page, Integer pageSize) {
        CaseInstanceList list = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("?owner=" + owner, page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/cases/instances", valuesMap) + queryString, CaseInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseInstancesOwnedBy", new Object[]{owner, this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseInstance> getCaseInstancesByContainer(String containerId, List<Integer> status, Integer page, Integer pageSize) {
        CaseInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances", valuesMap) + queryString, CaseInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseInstancesByContainer", new Object[]{containerId, this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseInstance> getCaseInstancesByDefinition(String containerId, String caseDefinitionId, List<Integer> status, Integer page, Integer pageSize) {
        CaseInstanceList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseDefId", caseDefinitionId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/{caseDefId}/instances", valuesMap) + queryString, CaseInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseInstancesByDefinition", new Object[]{containerId, caseDefinitionId, this.safeList(status), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseDefinition> getCaseDefinitionsByContainer(String containerId, Integer page, Integer pageSize) {
        CaseDefinitionList list = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases", valuesMap), CaseDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseDefinitionsByContainer", new Object[]{containerId, page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseDefinitionList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseDefinition> getCaseDefinitions(String filter, Integer page, Integer pageSize) {
        CaseDefinitionList list = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = "";
            if (filter != null) {
                queryString = "?filter=" + this.emptyIfNull(filter);
            }
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"queries/cases", valuesMap) + queryString, CaseDefinitionList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseDefinitions", new Object[]{this.emptyIfNull(filter), page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseDefinitionList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<CaseDefinition> getCaseDefinitions(Integer page, Integer pageSize) {
        return this.getCaseDefinitions(null, page, pageSize);
    }

    @Override
    public CaseDefinition getCaseDefinition(String containerId, String caseDefinitionId) {
        CaseDefinition result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseDefId", caseDefinitionId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/{caseDefId}", valuesMap), CaseDefinition.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseDefinition", new Object[]{containerId, caseDefinitionId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (CaseDefinition)response.getResult();
        }
        return result;
    }

    protected void internalAddDynamicTask(String containerId, String caseId, String stageId, Map<String, Object> taskSpecMap) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            if (stageId != null) {
                valuesMap.put("caseStageId", stageId);
                this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/stages/{caseStageId}/tasks", valuesMap), taskSpecMap, null);
            } else {
                this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/tasks", valuesMap), taskSpecMap, null);
            }
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "addDynamicTask", this.serialize(taskSpecMap), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, this.emptyIfNull(stageId)})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    protected void internalAddDynamicSubProcess(String containerId, String caseId, String stageId, String processId, Map<String, Object> taskSpecMap) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("pId", processId);
            if (stageId != null) {
                valuesMap.put("caseStageId", stageId);
                this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/stages/{caseStageId}/processes/{pId}", valuesMap), taskSpecMap, null);
            } else {
                this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/processes/{pId}", valuesMap), taskSpecMap, null);
            }
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "addDynamicSubprocess", this.serialize(this.safeMap(taskSpecMap)), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, this.emptyIfNull(stageId), processId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    protected void internalTriggerAdHoc(String containerId, String caseId, String stageId, String adHocName, Map<String, Object> data) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("nodeName", adHocName);
            if (stageId != null) {
                valuesMap.put("caseStageId", stageId);
                this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/stages/{caseStageId}/tasks/{nodeName}", valuesMap), data, null, new HashMap<String, String>());
            } else {
                this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/tasks/{nodeName}", valuesMap), data, null, new HashMap<String, String>());
            }
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "triggerAdHocNode", this.serialize(this.safeMap(data)), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, this.emptyIfNull(stageId), this.emptyIfNull(adHocName)})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    protected void internalRemoveRoleAssignment(String containerId, String caseId, String roleName, String user, String group) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("caseRoleName", roleName);
            String queryString = "?user=" + this.emptyIfNull(user) + "&group=" + this.emptyIfNull(group);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/roles/{caseRoleName}", valuesMap) + queryString, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "removeFromRole", new Object[]{containerId, caseId, roleName, this.emptyIfNull(user), this.emptyIfNull(group)})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    protected void internalAddRoleAssignment(String containerId, String caseId, String roleName, String user, String group) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("caseId", caseId);
            valuesMap.put("caseRoleName", roleName);
            String queryString = "?user=" + this.emptyIfNull(user) + "&group=" + this.emptyIfNull(group);
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/cases/instances/{caseId}/roles/{caseRoleName}", valuesMap) + queryString, null, null, new HashMap<String, String>());
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseService", "assignToRole", new Object[]{containerId, caseId, roleName, this.emptyIfNull(user), this.emptyIfNull(group)})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    protected String emptyIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }
}

