/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.AbstractConfigurableNetwork;
import com.google.common.graph.DirectedMultiNodeConnections;
import com.google.common.graph.DirectedNodeConnections;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NodeConnections;
import com.google.common.graph.UndirectedMultiNodeConnections;
import com.google.common.graph.UndirectedNodeConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;

class ConfigurableNetwork<N, E>
extends AbstractConfigurableNetwork<N, E>
implements MutableNetwork<N, E> {
    ConfigurableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        super(builder);
    }

    ConfigurableNetwork(NetworkBuilder<? super N, ? super E> builder, Map<N, NodeConnections<N, E>> nodeConnections, Map<E, N> edgeToReferenceNode) {
        super(builder, nodeConnections, edgeToReferenceNode);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, "node");
        if (this.containsNode(node)) {
            return false;
        }
        this.nodeConnections.put(node, this.newNodeConnections());
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(E edge, N node1, N node2) {
        Preconditions.checkNotNull(edge, "edge");
        Preconditions.checkNotNull(node1, "node1");
        Preconditions.checkNotNull(node2, "node2");
        Preconditions.checkArgument(this.allowsSelfLoops() || !node1.equals(node2), "Can't add self-loop edge on node %s, as self-loops are not allowed.", node1);
        boolean containsN1 = this.containsNode(node1);
        boolean containsN2 = this.containsNode(node2);
        if (this.containsEdge(edge)) {
            Preconditions.checkArgument(containsN1 && containsN2 && this.edgesConnecting(node1, node2).contains(edge), "Edge %s already exists between the following nodes: %s, so it can't be reused to connect node %s to %s", edge, this.incidentNodes(edge), node1, node2);
            return false;
        }
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument(!containsN1 || !containsN2 || !this.successors(node1).contains(node2), "Nodes %s and %s are already connected by a different edge.", node1, node2);
        }
        if (!containsN1) {
            this.addNode(node1);
        }
        NodeConnections connectionsN1 = (NodeConnections)this.nodeConnections.get(node1);
        connectionsN1.addOutEdge(edge, node2);
        if (!containsN2) {
            this.addNode(node2);
        }
        NodeConnections connectionsN2 = (NodeConnections)this.nodeConnections.get(node2);
        connectionsN2.addInEdge(edge, node1);
        this.edgeToReferenceNode.put(edge, node1);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(Object node) {
        Preconditions.checkNotNull(node, "node");
        if (!this.containsNode(node)) {
            return false;
        }
        for (Object edge : ImmutableList.copyOf(this.incidentEdges(node))) {
            this.removeEdge(edge);
        }
        this.nodeConnections.remove(node);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeEdge(Object edge) {
        Preconditions.checkNotNull(edge, "edge");
        Object node1 = this.edgeToReferenceNode.get(edge);
        if (node1 == null) {
            return false;
        }
        Object node2 = ((NodeConnections)this.nodeConnections.get(node1)).oppositeNode(edge);
        ((NodeConnections)this.nodeConnections.get(node1)).removeOutEdge(edge);
        ((NodeConnections)this.nodeConnections.get(node2)).removeInEdge(edge);
        this.edgeToReferenceNode.remove(edge);
        return true;
    }

    private NodeConnections<N, E> newNodeConnections() {
        return this.isDirected() ? (this.allowsParallelEdges() ? DirectedMultiNodeConnections.of() : DirectedNodeConnections.of()) : (this.allowsParallelEdges() ? UndirectedMultiNodeConnections.of() : UndirectedNodeConnections.of());
    }
}

