/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablelong;

import java.util.Arrays;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableLongScoreHolder
extends AbstractScoreHolder {
    private long[] hardScores;
    private long[] softScores;

    public BendableLongScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public long getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public long getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    public void addHardConstraintMatch(RuleContext kcontext, final int hardLevel, final long weight) {
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerLongConstraintMatch(kcontext, hardLevel, weight, new AbstractScoreHolder.LongConstraintUndoListener(){

            @Override
            public void undo() {
                long[] lArray = BendableLongScoreHolder.this.hardScores;
                int n = hardLevel;
                lArray[n] = lArray[n] - weight;
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final int softLevel, final long weight) {
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerLongConstraintMatch(kcontext, this.getHardLevelsSize() + softLevel, weight, new AbstractScoreHolder.LongConstraintUndoListener(){

            @Override
            public void undo() {
                long[] lArray = BendableLongScoreHolder.this.softScores;
                int n = softLevel;
                lArray[n] = lArray[n] - weight;
            }
        });
    }

    @Override
    public Score extractScore(int initScore) {
        return new BendableLongScore(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

