/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.impl.domain.common.AlphabeticMemberComparator;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.BeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.FieldMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MethodMemberAccessor;

public class ConfigUtils {
    public static <T> T newInstance(Object bean, String propertyName, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("The " + bean.getClass().getSimpleName() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor.", e);
        }
    }

    public static <C extends AbstractConfig<C>> C inheritConfig(C original, C inherited) {
        if (inherited != null) {
            if (original == null) {
                original = inherited.newInstance();
            }
            original.inherit(inherited);
        }
        return original;
    }

    public static <C extends AbstractConfig<C>> List<C> inheritMergeableListConfig(List<C> originalList, List<C> inheritedList) {
        if (inheritedList != null) {
            ArrayList<C> mergedList = new ArrayList<C>(inheritedList.size() + (originalList == null ? 0 : originalList.size()));
            for (AbstractConfig inherited : inheritedList) {
                AbstractConfig copy = inherited.newInstance();
                copy.inherit((AbstractConfig)inherited);
                mergedList.add(copy);
            }
            if (originalList != null) {
                mergedList.addAll(originalList);
            }
            originalList = mergedList;
        }
        return originalList;
    }

    public static <T> T inheritOverwritableProperty(T original, T inherited) {
        if (original != null) {
            return original;
        }
        return inherited;
    }

    public static <T> List<T> inheritMergeableListProperty(List<T> originalList, List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return new ArrayList<T>(inheritedList);
        }
        ArrayList<T> mergedList = new ArrayList<T>(inheritedList);
        mergedList.addAll(originalList);
        return mergedList;
    }

    public static <K, T> Map<K, T> inheritMergeableMapProperty(Map<K, T> originalMap, Map<K, T> inheritedMap) {
        if (inheritedMap == null) {
            return originalMap;
        }
        if (originalMap == null) {
            return inheritedMap;
        }
        LinkedHashMap<K, T> mergedMap = new LinkedHashMap<K, T>(inheritedMap);
        mergedMap.putAll(originalMap);
        return mergedMap;
    }

    public static <T> T mergeProperty(T a, T b) {
        return (T)(Objects.equals(a, b) ? a : null);
    }

    public static <T> T meldProperty(T a, T b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        return ConfigUtils.mergeProperty(a, b);
    }

    public static boolean isEmptyCollection(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int ceilDivide(int dividend, int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0 ? 0 : (Integer.signum(dividend) * Integer.signum(divisor) < 0 ? 0 : 1);
        return dividend / divisor + correction;
    }

    public static long floorDivide(long dividend, long divisor) {
        if (divisor == 0L) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0L ? 0 : (Long.signum(dividend) * Long.signum(divisor) < 0 ? -1 : 0);
        return dividend / divisor + (long)correction;
    }

    public static List<Class<?>> getAllAnnotatedLineageClasses(Class<?> bottomClass, Class<? extends Annotation> annotation) {
        if (!bottomClass.isAnnotationPresent(annotation)) {
            return Collections.emptyList();
        }
        ArrayList lineageClassList = new ArrayList();
        lineageClassList.add(bottomClass);
        Class<?> superclass = bottomClass.getSuperclass();
        lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superclass, annotation));
        for (Class<?> superInterface : bottomClass.getInterfaces()) {
            lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superInterface, annotation));
        }
        return lineageClassList;
    }

    public static List<Member> getDeclaredMembers(Class<?> baseClass) {
        Stream<Field> fieldStream = Stream.of(baseClass.getDeclaredFields()).sorted(new AlphabeticMemberComparator());
        Stream<Method> methodStream = Stream.of(baseClass.getDeclaredMethods()).sorted(new AlphabeticMemberComparator());
        return Stream.concat(fieldStream, methodStream).collect(Collectors.toList());
    }

    public static Class<? extends Annotation> extractAnnotationClass(Member member, Class<? extends Annotation> ... annotations) {
        Class<? extends Annotation> annotationClass = null;
        for (Class<? extends Annotation> detectedAnnotationClass : annotations) {
            if (!((AnnotatedElement)((Object)member)).isAnnotationPresent(detectedAnnotationClass)) continue;
            if (annotationClass != null) {
                throw new IllegalStateException("The class (" + member.getDeclaringClass() + ") has a member (" + member + ") that has both a " + annotationClass.getSimpleName() + " annotation and a " + detectedAnnotationClass.getSimpleName() + " annotation.");
            }
            annotationClass = detectedAnnotationClass;
        }
        return annotationClass;
    }

    public static MemberAccessor buildMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return new FieldMemberAccessor(field);
        }
        if (member instanceof Method) {
            MemberAccessor memberAccessor;
            Method method = (Method)member;
            switch (memberAccessorType) {
                case FIELD_OR_READ_METHOD: {
                    if (ReflectionHelper.isGetterMethod(method)) {
                        memberAccessor = new BeanPropertyMemberAccessor(method);
                        break;
                    }
                    ReflectionHelper.assertReadMethod(method, annotationClass);
                    memberAccessor = new MethodMemberAccessor(method);
                    break;
                }
                case FIELD_OR_GETTER_METHOD: 
                case FIELD_OR_GETTER_METHOD_WITH_SETTER: {
                    ReflectionHelper.assertGetterMethod(method, annotationClass);
                    memberAccessor = new BeanPropertyMemberAccessor(method);
                    break;
                }
                default: {
                    throw new IllegalStateException("The memberAccessorType (" + (Object)((Object)memberAccessorType) + ") is not implemented.");
                }
            }
            if (memberAccessorType == MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER && !memberAccessor.supportSetter()) {
                throw new IllegalStateException("The class (" + method.getDeclaringClass() + ") has a " + annotationClass.getSimpleName() + " annotated getter method (" + method + "), but lacks a setter for that property (" + memberAccessor.getName() + ").");
            }
            return memberAccessor;
        }
        throw new IllegalStateException("Impossible state: the member (" + member + ")'s type is not a " + Field.class.getSimpleName() + " or a " + Method.class.getSimpleName() + ".");
    }

    private ConfigUtils() {
    }

    public static enum MemberAccessorType {
        FIELD_OR_READ_METHOD,
        FIELD_OR_GETTER_METHOD,
        FIELD_OR_GETTER_METHOD_WITH_SETTER;

    }
}

