/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.AbstractRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;

public class SnapshotArtifactRepositoryMetadata
extends AbstractRepositoryMetadata {
    private Artifact artifact;

    public SnapshotArtifactRepositoryMetadata(Artifact artifact) {
        super(SnapshotArtifactRepositoryMetadata.createMetadata(artifact, null));
        this.artifact = artifact;
    }

    public SnapshotArtifactRepositoryMetadata(Artifact artifact, Snapshot snapshot) {
        super(SnapshotArtifactRepositoryMetadata.createMetadata(artifact, SnapshotArtifactRepositoryMetadata.createVersioning(snapshot)));
        this.artifact = artifact;
    }

    @Override
    public boolean storedInGroupDirectory() {
        return false;
    }

    @Override
    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    @Override
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Override
    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    @Override
    public Object getKey() {
        return "snapshot " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.artifact.isSnapshot();
    }

    @Override
    public int getNature() {
        return this.isSnapshot() ? 2 : 1;
    }

    @Override
    public ArtifactRepository getRepository() {
        return this.artifact.getRepository();
    }

    @Override
    public void setRepository(ArtifactRepository remoteRepository) {
        this.artifact.setRepository(remoteRepository);
    }
}

